/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.convertible;

import java.io.IOException;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.convertible.parametrized.JsonNode;
import org.neo4j.ogm.domain.convertible.parametrized.StringMapEntity;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class ParameterizedConversionTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() throws IOException {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.convertible.parametrized"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @After
    public void tearDown() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldConvertParametrizedMap() {
        JsonNode jsonNode = new JsonNode();
        jsonNode.payload = Utils.map((Object[])new Object[]{"key", "value"});
        this.session.save((Object)jsonNode);
        this.session.clear();
        JsonNode found = (JsonNode)this.session.load(JsonNode.class, (Serializable)jsonNode.id);
        Assertions.assertThat((boolean)found.payload.containsKey("key")).isTrue();
        Assertions.assertThat((Object)found.payload.get("key")).isEqualTo((Object)"value");
    }

    @Test
    public void shouldConvertParameterizedStringMap() {
        StringMapEntity entity = new StringMapEntity();
        this.session.save((Object)entity);
        this.session.clear();
        StringMapEntity loaded = (StringMapEntity)this.session.load(StringMapEntity.class, (Serializable)entity.getId());
        Assertions.assertThat((Object)loaded).isNotNull();
        Assertions.assertThat(loaded.getStringMap()).hasSize(3);
    }
}

