/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.education;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.education.Course;
import org.neo4j.ogm.domain.education.School;
import org.neo4j.ogm.domain.education.Student;
import org.neo4j.ogm.domain.education.Teacher;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class EducationIntegrationTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() throws IOException {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.education"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void loadingCourseByPropertyShouldNotLoadOtherEntitiesWithSamePropertyValue() {
        Course course = new Course("CompSci");
        Student student = new Student("CompSci");
        course.setStudents(Collections.singletonList(student));
        this.session.save((Object)course);
        Collection courses = this.session.loadAll(Course.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"CompSci"));
        Assertions.assertThat((Iterable)courses).hasSize(1);
        Assertions.assertThat(courses.iterator().next()).isEqualTo((Object)course);
        Assertions.assertThat(((Course)courses.iterator().next()).getStudents()).hasSize(1);
    }

    @Test
    public void loadingASchoolWithNegativeDepthShouldLoadAllConnectedEntities() {
        School hogwarts = new School("Hogwarts");
        Student harry = new Student("Harry Potter");
        Student ron = new Student("Ron Weasley");
        Student hermione = new Student("Hermione Granger");
        Course transfiguration = new Course("Transfiguration");
        transfiguration.setStudents(Arrays.asList(harry, hermione, ron));
        Course potions = new Course("Potions");
        potions.setStudents(Arrays.asList(ron, hermione));
        Course dark = new Course("Defence Against The Dark Arts");
        dark.setStudents(Collections.singletonList(harry));
        Teacher minerva = new Teacher("Minerva McGonagall");
        minerva.setCourses(Collections.singletonList(transfiguration));
        minerva.setSchool(hogwarts);
        Teacher severus = new Teacher("Severus Snape");
        severus.setCourses(Arrays.asList(potions, dark));
        severus.setSchool(hogwarts);
        hogwarts.setTeachers(Arrays.asList(minerva, severus));
        this.session.save((Object)hogwarts);
        this.session.clear();
        hogwarts = (School)this.session.load(School.class, (Serializable)hogwarts.getId(), -1);
        Assertions.assertThat(hogwarts.getTeachers()).hasSize(2);
        for (Teacher teacher : hogwarts.getTeachers()) {
            if (teacher.getName().equals("Severus Snape")) {
                Assertions.assertThat(teacher.getCourses()).hasSize(2);
                for (Course course : teacher.getCourses()) {
                    if (course.getName().equals("Potions")) {
                        Assertions.assertThat(course.getStudents()).hasSize(2);
                        continue;
                    }
                    Assertions.assertThat(course.getStudents()).hasSize(1);
                }
                continue;
            }
            Assertions.assertThat(teacher.getCourses()).hasSize(1);
            Assertions.assertThat(teacher.getCourses().get(0).getStudents()).hasSize(3);
        }
    }
}

