/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.election;

import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.context.MappedRelationship;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.domain.election.Candidate;
import org.neo4j.ogm.domain.election.Voter;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class ElectionTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.election"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
    }

    @After
    public void clearDatabase() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldAllowACandidateToVoteForHerself() {
        Candidate candidate;
        candidate.candidateVotedFor = candidate = new Candidate("Hilary Clinton");
        this.session.save((Object)candidate);
        Assertions.assertThat((Long)candidate.getId()).isNotNull();
        Assertions.assertThat((Long)candidate.candidateVotedFor.getId()).isNotNull();
        Assertions.assertThat((Long)candidate.candidateVotedFor.getId()).isEqualTo((Object)candidate.getId());
        this.session.clear();
        Long voterId = candidate.getId();
        Voter voter = (Voter)this.session.load(Voter.class, (Serializable)voterId);
        Assertions.assertThat((Long)voter.getId()).isNotNull();
        Assertions.assertThat((Long)voter.candidateVotedFor.getId()).isNotNull();
        Assertions.assertThat((Long)voter.candidateVotedFor.getId()).isEqualTo((Object)voter.getId());
    }

    @Test
    public void shouldAllowASelfReferenceToBeSavedFromTheReferredSide() {
        Candidate candidate;
        candidate.candidateVotedFor = candidate = new Candidate("Hilary Clinton");
        this.session.save((Object)candidate.candidateVotedFor);
        this.session.clear();
        Long voterId = candidate.candidateVotedFor.getId();
        Voter voter = (Voter)this.session.load(Voter.class, (Serializable)voterId);
        Assertions.assertThat((Long)voter.getId()).isNotNull();
        Assertions.assertThat((Long)voter.candidateVotedFor.getId()).isNotNull();
        Assertions.assertThat((Long)voter.candidateVotedFor.getId()).isEqualTo((Object)voter.getId());
    }

    @Test
    public void shouldAllowVoterToChangeHerMind() {
        Candidate a = new Candidate("A");
        Candidate b = new Candidate("B");
        Voter v = new Voter("V");
        v.candidateVotedFor = b;
        this.session.save((Object)a);
        this.session.save((Object)v);
        MappingContext context = ((Neo4jSession)this.session).context();
        Assertions.assertThat((boolean)context.containsRelationship(new MappedRelationship(v.getId().longValue(), "CANDIDATE_VOTED_FOR", b.getId().longValue(), Voter.class, Candidate.class))).isTrue();
        this.session.clear();
        a = (Candidate)this.session.load(Candidate.class, (Serializable)a.getId());
        v = (Voter)this.session.load(Voter.class, (Serializable)v.getId());
        Assertions.assertThat((Long)v.candidateVotedFor.getId()).isEqualTo((Object)b.getId());
        Assertions.assertThat((boolean)context.containsRelationship(new MappedRelationship(v.getId().longValue(), "CANDIDATE_VOTED_FOR", b.getId().longValue(), Voter.class, Candidate.class))).isTrue();
        v.candidateVotedFor = a;
        this.session.save((Object)v);
        this.session.clear();
        this.session.load(Candidate.class, (Serializable)b.getId());
        this.session.load(Voter.class, (Serializable)v.getId());
        Assertions.assertThat((Long)v.candidateVotedFor.getId()).isEqualTo((Object)a.getId());
        Assertions.assertThat((boolean)context.containsRelationship(new MappedRelationship(v.getId().longValue(), "CANDIDATE_VOTED_FOR", a.getId().longValue(), Voter.class, Candidate.class))).isTrue();
        Assertions.assertThat((boolean)context.containsRelationship(new MappedRelationship(v.getId().longValue(), "CANDIDATE_VOTED_FOR", b.getId().longValue(), Voter.class, Candidate.class))).isFalse();
        this.session.clear();
    }
}

