/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.friendships;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.friendships.Friendship;
import org.neo4j.ogm.domain.friendships.Person;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class FriendshipsRelationshipEntityTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() throws IOException {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.friendships"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldSaveFromStartObjectSetsAllObjectIds() {
        Person mike = new Person("Mike");
        Person dave = new Person("Dave");
        dave.getFriends().add(new Friendship(dave, mike, 5));
        this.session.save((Object)dave);
        Assertions.assertThat((Long)dave.getId()).isNotNull();
        Assertions.assertThat((Long)mike.getId()).isNotNull();
        Assertions.assertThat((Long)dave.getFriends().get(0).getId()).isNotNull();
    }

    @Test
    public void shouldSaveAndReloadAllSetsAllObjectIdsAndReferencesCorrectly() {
        Person mike = new Person("Mike");
        Person dave = new Person("Dave");
        dave.getFriends().add(new Friendship(dave, mike, 5));
        this.session.save((Object)dave);
        Collection personList = this.session.loadAll(Person.class);
        int expected = 2;
        Assertions.assertThat((int)personList.size()).isEqualTo(expected);
        for (Person person : personList) {
            if (person.getName().equals("Dave")) {
                --expected;
                Assertions.assertThat((String)person.getFriends().get(0).getFriend().getName()).isEqualTo((Object)"Mike");
                continue;
            }
            if (!person.getName().equals("Mike")) continue;
            --expected;
            Assertions.assertThat((String)person.getFriends().get(0).getPerson().getName()).isEqualTo((Object)"Dave");
        }
        Assertions.assertThat((int)expected).isEqualTo(0);
    }

    @Test
    public void shouldSaveFromRelationshipEntitySetsAllObjectIds() {
        Person mike = new Person("Mike");
        Person dave = new Person("Dave");
        Friendship friendship = new Friendship(dave, mike, 5);
        dave.getFriends().add(friendship);
        this.session.save((Object)friendship);
        Assertions.assertThat((Long)dave.getId()).isNotNull();
        Assertions.assertThat((Long)mike.getId()).isNotNull();
        Assertions.assertThat((Long)dave.getFriends().get(0).getId()).isNotNull();
    }

    @Test
    public void shouldLoadStartObjectHydratesProperly() {
        Person mike = new Person("Mike");
        Person dave = new Person("Dave");
        Friendship friendship = new Friendship(dave, mike, 5);
        dave.getFriends().add(friendship);
        this.session.save((Object)dave);
        Person daveCopy = (Person)this.session.load(Person.class, (Serializable)dave.getId());
        Friendship friendshipCopy = daveCopy.getFriends().get(0);
        Person mikeCopy = friendshipCopy.getFriend();
        Assertions.assertThat((Long)daveCopy.getId()).isNotNull();
        Assertions.assertThat((Long)mikeCopy.getId()).isNotNull();
        Assertions.assertThat((Long)friendshipCopy.getId()).isNotNull();
        Assertions.assertThat((String)daveCopy.getName()).isEqualTo((Object)"Dave");
        Assertions.assertThat((String)mikeCopy.getName()).isEqualTo((Object)"Mike");
        Assertions.assertThat((int)friendshipCopy.getStrength()).isEqualTo(5);
    }

    @Test
    public void shouldLoadRelationshipEntityObjectHydratesProperly() {
        Person mike = new Person("Mike");
        Person dave = new Person("Dave");
        Friendship friendship = new Friendship(dave, mike, 5);
        dave.getFriends().add(friendship);
        this.session.save((Object)dave);
        Friendship friendshipCopy = (Friendship)this.session.load(Friendship.class, (Serializable)friendship.getId());
        Person daveCopy = friendshipCopy.getPerson();
        Person mikeCopy = friendshipCopy.getFriend();
        Assertions.assertThat((Long)daveCopy.getId()).isNotNull();
        Assertions.assertThat((Long)mikeCopy.getId()).isNotNull();
        Assertions.assertThat((Long)friendshipCopy.getId()).isNotNull();
        Assertions.assertThat((String)daveCopy.getName()).isEqualTo((Object)"Dave");
        Assertions.assertThat((String)mikeCopy.getName()).isEqualTo((Object)"Mike");
        Assertions.assertThat((int)friendshipCopy.getStrength()).isEqualTo(5);
    }

    @Test
    public void shouldRetrieveRelationshipEntitySetPropertyCorrectly() {
        Person mike = new Person("Mike");
        Person dave = new Person("Dave");
        HashSet<String> hobbies = new HashSet<String>();
        hobbies.add("Swimming");
        hobbies.add("Cooking");
        dave.getFriends().add(new Friendship(dave, mike, 5, hobbies));
        this.session.save((Object)dave);
        Assertions.assertThat((Long)dave.getId()).isNotNull();
        Assertions.assertThat((Long)mike.getId()).isNotNull();
        Assertions.assertThat((Long)dave.getFriends().get(0).getId()).isNotNull();
        this.session.clear();
        mike = (Person)this.session.load(Person.class, (Serializable)mike.getId());
        Assertions.assertThat(mike.getFriends().get(0).getSharedHobbies()).hasSize(2);
    }
}

