/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.hierarchy.dualRelationships;

import java.io.IOException;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.hierarchy.dualRelation.DataView;
import org.neo4j.ogm.domain.hierarchy.dualRelation.DataViewOwned;
import org.neo4j.ogm.domain.hierarchy.dualRelation.Thing;
import org.neo4j.ogm.domain.hierarchy.dualRelation.ThingOwned;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class DualRelationshipTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.hierarchy.dualRelation"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @After
    public void cleanup() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldRehydrateProperlyUsingLoad() {
        Thing thing1 = new Thing();
        Thing thing2 = new Thing();
        DataView dataview = new DataView();
        dataview.setName("dataview");
        thing1.setName("owner");
        thing2.setName("shared");
        dataview.setOwner(thing1);
        dataview.getSharedWith().add(thing2);
        this.session.save((Object)dataview);
        this.session.clear();
        DataView found = (DataView)this.session.load(DataView.class, (Serializable)dataview.getId());
        Assertions.assertThat((String)found.getOwner().getName()).isEqualTo((Object)"owner");
        Assertions.assertThat((String)found.getSharedWith().get(0).getName()).isEqualTo((Object)"shared");
        Assertions.assertThat(found.getSharedWith()).hasSize(1);
    }

    @Test
    public void shouldRehydrateProperlyWithQuery() {
        Thing thing1 = new Thing();
        Thing thing2 = new Thing();
        DataView dataview = new DataView();
        dataview.setName("dataview");
        thing1.setName("owner");
        thing2.setName("shared");
        dataview.setOwner(thing1);
        dataview.getSharedWith().add(thing2);
        this.session.save((Object)dataview);
        this.session.clear();
        String query = "MATCH (n:DataView) WITH n MATCH p=(n)-[*0..1]-(m) RETURN n,nodes(p),rels(p)";
        DataView found = (DataView)this.session.queryForObject(DataView.class, query, Utils.map((Object[])new Object[0]));
        Assertions.assertThat(found.getSharedWith()).hasSize(1);
        Assertions.assertThat((String)found.getOwner().getName()).isEqualTo((Object)"owner");
        Assertions.assertThat((String)found.getSharedWith().get(0).getName()).isEqualTo((Object)"shared");
    }

    @Test
    public void shouldRehydrateEntitiesWithAbstractParentProperlyUsingLoad() {
        ThingOwned thing1 = new ThingOwned();
        ThingOwned thing2 = new ThingOwned();
        DataViewOwned dataview = new DataViewOwned();
        dataview.setName("dataview");
        thing1.setName("owner");
        thing2.setName("shared");
        dataview.setOwner(thing1);
        dataview.getSharedWith().add(thing2);
        this.session.save((Object)dataview);
        this.session.clear();
        DataViewOwned found = (DataViewOwned)this.session.load(DataViewOwned.class, (Serializable)dataview.getId());
        Assertions.assertThat((String)found.getOwner().getName()).isEqualTo((Object)"owner");
        Assertions.assertThat((String)found.getSharedWith().get(0).getName()).isEqualTo((Object)"shared");
        Assertions.assertThat(found.getSharedWith()).hasSize(1);
    }

    @Test
    public void shouldRehydrateEntitiesWithAbstractParentProperlyWithQuery() {
        ThingOwned thing1 = new ThingOwned();
        ThingOwned thing2 = new ThingOwned();
        DataViewOwned dataview = new DataViewOwned();
        dataview.setName("dataview");
        thing1.setName("owner");
        thing2.setName("shared");
        dataview.setOwner(thing1);
        dataview.getSharedWith().add(thing2);
        this.session.save((Object)dataview);
        this.session.clear();
        String query = "MATCH (n:DataViewOwned) WITH n MATCH p=(n)-[*0..1]-(m) RETURN n,nodes(p),rels(p)";
        DataViewOwned found = (DataViewOwned)this.session.queryForObject(DataViewOwned.class, query, Utils.map((Object[])new Object[0]));
        Assertions.assertThat((Object)found).isNotNull();
        Assertions.assertThat(found.getSharedWith()).hasSize(1);
        Assertions.assertThat((String)found.getOwner().getName()).isEqualTo((Object)"owner");
        Assertions.assertThat((String)found.getSharedWith().get(0).getName()).isEqualTo((Object)"shared");
    }
}

