/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.ingredients;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.domain.ingredients.Ingredient;
import org.neo4j.ogm.domain.ingredients.Pairing;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class IngredientsIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.ingredients"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldBeAbleToAddInterrelatedPairings() {
        Ingredient chicken = new Ingredient("Chicken");
        this.session.save((Object)chicken);
        Ingredient carrot = new Ingredient("Carrot");
        this.session.save((Object)carrot);
        Ingredient butter = new Ingredient("Butter");
        this.session.save((Object)butter);
        Pairing pairing = new Pairing();
        pairing.setFirst(chicken);
        pairing.setSecond(carrot);
        pairing.setAffinity("EXCELLENT");
        carrot.addPairing(pairing);
        this.session.save((Object)chicken);
        Pairing pairing2 = new Pairing();
        pairing2.setFirst(chicken);
        pairing2.setSecond(butter);
        pairing2.setAffinity("EXCELLENT");
        carrot.addPairing(pairing2);
        this.session.save((Object)chicken);
        Pairing pairing3 = new Pairing();
        pairing3.setFirst(carrot);
        pairing3.setSecond(butter);
        pairing3.setAffinity("EXCELLENT");
        carrot.addPairing(pairing3);
        this.session.save((Object)carrot);
    }

    @Test
    public void shouldBeAbleToLoadIngredientsWithoutPairings() {
        Ingredient chicken = new Ingredient("Chicken");
        this.session.save((Object)chicken);
        Ingredient carrot = new Ingredient("Carrot");
        this.session.save((Object)carrot);
        Ingredient butter = new Ingredient("Butter");
        this.session.save((Object)butter);
        Pairing pairing = new Pairing();
        pairing.setFirst(chicken);
        pairing.setSecond(carrot);
        pairing.setAffinity("EXCELLENT");
        carrot.addPairing(pairing);
        this.session.save((Object)chicken);
        Pairing pairing2 = new Pairing();
        pairing2.setFirst(chicken);
        pairing2.setSecond(butter);
        pairing2.setAffinity("EXCELLENT");
        carrot.addPairing(pairing2);
        this.session.save((Object)chicken);
        Pairing pairing3 = new Pairing();
        pairing3.setFirst(carrot);
        pairing3.setSecond(butter);
        pairing3.setAffinity("EXCELLENT");
        carrot.addPairing(pairing3);
        this.session.save((Object)carrot);
        this.session.clear();
        for (Ingredient i : this.session.loadAll(Ingredient.class, 0)) {
            ((IterableAssert)Assertions.assertThat(i.getPairings()).as(i.getName(), new Object[0])).hasSize(0);
        }
    }

    @Test
    public void shouldBeAbleToLoadPairingWithCustomDepth() {
        Ingredient chicken = new Ingredient("Chicken");
        this.session.save((Object)chicken);
        Ingredient carrot = new Ingredient("Carrot");
        this.session.save((Object)carrot);
        Ingredient butter = new Ingredient("Butter");
        this.session.save((Object)butter);
        Ingredient pineapple = new Ingredient("Pineapple");
        this.session.save((Object)pineapple);
        Ingredient ham = new Ingredient("Ham");
        this.session.save((Object)ham);
        Ingredient sage = new Ingredient("Sage");
        this.session.save((Object)sage);
        Pairing pairing = new Pairing();
        pairing.setFirst(chicken);
        pairing.setSecond(carrot);
        pairing.setAffinity("EXCELLENT");
        this.session.save((Object)pairing);
        Pairing pairing2 = new Pairing();
        pairing2.setFirst(chicken);
        pairing2.setSecond(pineapple);
        pairing2.setAffinity("GOOD");
        this.session.save((Object)pairing2);
        Pairing pairing3 = new Pairing();
        pairing3.setFirst(pineapple);
        pairing3.setSecond(ham);
        pairing3.setAffinity("TRIED AND TESTED");
        this.session.save((Object)pairing3);
        Pairing pairing4 = new Pairing();
        pairing4.setFirst(carrot);
        pairing4.setSecond(butter);
        pairing4.setAffinity("GOOD");
        this.session.save((Object)pairing4);
        Pairing pairing5 = new Pairing();
        pairing5.setFirst(butter);
        pairing5.setSecond(sage);
        pairing5.setAffinity("EXCELLENT");
        this.session.save((Object)pairing5);
        this.session.clear();
        Pairing carrotChicken = (Pairing)this.session.load(Pairing.class, (Serializable)pairing.getId());
        Assertions.assertThat((Object)carrotChicken).isNotNull();
        Assertions.assertThat((String)carrotChicken.getAffinity()).isEqualTo((Object)"EXCELLENT");
        Assertions.assertThat((Object)carrotChicken.getFirst()).isNotNull();
        Assertions.assertThat(carrotChicken.getFirst().getPairings()).hasSize(2);
        Assertions.assertThat((Object)carrotChicken.getSecond()).isNotNull();
        Assertions.assertThat(carrotChicken.getSecond().getPairings()).hasSize(2);
        Ingredient loadedChicken = carrotChicken.getFirst().getName().equals("Chicken") ? carrotChicken.getFirst() : carrotChicken.getSecond();
        Ingredient loadedPineapple = null;
        for (Pairing p : loadedChicken.getPairings()) {
            if (p.getFirst().getName().equals("Pineapple")) {
                loadedPineapple = p.getFirst();
            }
            if (!p.getSecond().getName().equals("Pineapple")) continue;
            loadedPineapple = p.getSecond();
        }
        Assertions.assertThat(loadedPineapple).isNotNull();
        Assertions.assertThat(loadedPineapple.getPairings()).hasSize(1);
        Ingredient loadedCarrot = carrotChicken.getFirst().getName().equals("Carrot") ? carrotChicken.getFirst() : carrotChicken.getSecond();
        Ingredient loadedButter = null;
        for (Pairing p : loadedCarrot.getPairings()) {
            if (p.getFirst().getName().equals("Butter")) {
                loadedButter = p.getFirst();
            }
            if (!p.getSecond().getName().equals("Butter")) continue;
            loadedButter = p.getSecond();
        }
        Assertions.assertThat(loadedButter).isNotNull();
        Assertions.assertThat(loadedButter.getPairings()).hasSize(1);
        this.session.clear();
        carrotChicken = (Pairing)this.session.load(Pairing.class, (Serializable)pairing.getId(), 2);
        Assertions.assertThat((Object)carrotChicken).isNotNull();
        Assertions.assertThat((String)carrotChicken.getAffinity()).isEqualTo((Object)"EXCELLENT");
        Assertions.assertThat((Object)carrotChicken.getFirst()).isNotNull();
        Assertions.assertThat(carrotChicken.getFirst().getPairings()).hasSize(2);
        Assertions.assertThat((Object)carrotChicken.getSecond()).isNotNull();
        Assertions.assertThat(carrotChicken.getSecond().getPairings()).hasSize(2);
        loadedChicken = carrotChicken.getFirst().getName().equals("Chicken") ? carrotChicken.getFirst() : carrotChicken.getSecond();
        loadedPineapple = null;
        for (Pairing p : loadedChicken.getPairings()) {
            if (p.getFirst().getName().equals("Pineapple")) {
                loadedPineapple = p.getFirst();
            }
            if (!p.getSecond().getName().equals("Pineapple")) continue;
            loadedPineapple = p.getSecond();
        }
        Assertions.assertThat((Object)loadedPineapple).isNotNull();
        Assertions.assertThat(loadedPineapple.getPairings()).hasSize(2);
        loadedCarrot = carrotChicken.getFirst().getName().equals("Carrot") ? carrotChicken.getFirst() : carrotChicken.getSecond();
        loadedButter = null;
        for (Pairing p : loadedCarrot.getPairings()) {
            if (p.getFirst().getName().equals("Butter")) {
                loadedButter = p.getFirst();
            }
            if (!p.getSecond().getName().equals("Butter")) continue;
            loadedButter = p.getSecond();
        }
        Assertions.assertThat((Object)loadedButter).isNotNull();
        Assertions.assertThat(loadedButter.getPairings()).hasSize(2);
    }

    @Test
    public void shouldBeAbleToLoadIngredientsWithPagingAndDepth() {
        Ingredient chicken = new Ingredient("Chicken");
        this.session.save((Object)chicken);
        Ingredient carrot = new Ingredient("Carrot");
        this.session.save((Object)carrot);
        Ingredient butter = new Ingredient("Butter");
        this.session.save((Object)butter);
        Pairing pairing = new Pairing();
        pairing.setFirst(chicken);
        pairing.setSecond(carrot);
        pairing.setAffinity("EXCELLENT");
        carrot.addPairing(pairing);
        this.session.save((Object)chicken);
        Pairing pairing2 = new Pairing();
        pairing2.setFirst(chicken);
        pairing2.setSecond(butter);
        pairing2.setAffinity("EXCELLENT");
        carrot.addPairing(pairing2);
        this.session.save((Object)chicken);
        Pairing pairing3 = new Pairing();
        pairing3.setFirst(carrot);
        pairing3.setSecond(butter);
        pairing3.setAffinity("EXCELLENT");
        carrot.addPairing(pairing3);
        this.session.save((Object)carrot);
        this.session.clear();
        Collection ingredients = this.session.loadAll(Ingredient.class, new Pagination(0, 1));
        Assertions.assertThat((Iterable)ingredients).hasSize(1);
        this.session.clear();
        ingredients = this.session.loadAll(Ingredient.class, new Pagination(1, 1));
        Assertions.assertThat((Iterable)ingredients).hasSize(1);
        this.session.clear();
        ingredients = this.session.loadAll(Ingredient.class, new Pagination(0, 2));
        Assertions.assertThat((Iterable)ingredients).hasSize(2);
        ingredients = this.session.loadAll(Ingredient.class, new Pagination(0, 3));
        Assertions.assertThat((Iterable)ingredients).hasSize(3);
        this.session.clear();
        Collection pairings = this.session.loadAll(Pairing.class, new Pagination(0, 1));
        Assertions.assertThat((Iterable)pairings).hasSize(1);
        this.session.clear();
        pairings = this.session.loadAll(Pairing.class, new Pagination(1, 1));
        Assertions.assertThat((Iterable)pairings).hasSize(1);
        this.session.clear();
        pairings = this.session.loadAll(Pairing.class, new Pagination(0, 2));
        Assertions.assertThat((Iterable)pairings).hasSize(2);
        this.session.clear();
        pairings = this.session.loadAll(Pairing.class, new Pagination(0, 3));
        Assertions.assertThat((Iterable)pairings).hasSize(3);
    }

    @Test
    public void shouldBeAbleToLoadIngredientsWithFiltersPagingAndDepth() {
        Ingredient chicken = new Ingredient("Chicken");
        this.session.save((Object)chicken);
        Ingredient carrot = new Ingredient("Chicken");
        this.session.save((Object)carrot);
        Ingredient butter = new Ingredient("Chicken");
        this.session.save((Object)butter);
        Pairing pairing = new Pairing();
        pairing.setFirst(chicken);
        pairing.setSecond(carrot);
        pairing.setAffinity("EXCELLENT");
        carrot.addPairing(pairing);
        this.session.save((Object)chicken);
        Pairing pairing2 = new Pairing();
        pairing2.setFirst(chicken);
        pairing2.setSecond(butter);
        pairing2.setAffinity("EXCELLENT");
        carrot.addPairing(pairing2);
        this.session.save((Object)chicken);
        Pairing pairing3 = new Pairing();
        pairing3.setFirst(carrot);
        pairing3.setSecond(butter);
        pairing3.setAffinity("EXCELLENT");
        carrot.addPairing(pairing3);
        this.session.save((Object)carrot);
        this.session.clear();
        Collection ingredients = this.session.loadAll(Ingredient.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Chicken"), new Pagination(0, 1));
        Assertions.assertThat((Iterable)ingredients).hasSize(1);
        this.session.clear();
        ingredients = this.session.loadAll(Ingredient.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Chicken"), new Pagination(1, 1));
        Assertions.assertThat((Iterable)ingredients).hasSize(1);
        this.session.clear();
        ingredients = this.session.loadAll(Ingredient.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Chicken"), new Pagination(0, 2));
        Assertions.assertThat((Iterable)ingredients).hasSize(2);
        ingredients = this.session.loadAll(Ingredient.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Chicken"), new Pagination(0, 3));
        Assertions.assertThat((Iterable)ingredients).hasSize(3);
        this.session.clear();
        Collection pairings = this.session.loadAll(Pairing.class, new Filter("affinity", ComparisonOperator.EQUALS, (Object)"EXCELLENT"), new Pagination(0, 1));
        Assertions.assertThat((Iterable)pairings).hasSize(1);
        this.session.clear();
        pairings = this.session.loadAll(Pairing.class, new Filter("affinity", ComparisonOperator.EQUALS, (Object)"EXCELLENT"), new Pagination(1, 1));
        Assertions.assertThat((Iterable)pairings).hasSize(1);
        this.session.clear();
        pairings = this.session.loadAll(Pairing.class, new Filter("affinity", ComparisonOperator.EQUALS, (Object)"EXCELLENT"), new Pagination(0, 2));
        Assertions.assertThat((Iterable)pairings).hasSize(2);
        pairings = this.session.loadAll(Pairing.class, new Filter("affinity", ComparisonOperator.EQUALS, (Object)"EXCELLENT"), new Pagination(0, 3));
        Assertions.assertThat((Iterable)pairings).hasSize(3);
    }
}

