/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.locking;

import java.io.Serializable;
import java.util.Collection;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.locking.Location;
import org.neo4j.ogm.domain.locking.PowerUser;
import org.neo4j.ogm.domain.locking.User;
import org.neo4j.ogm.exception.OptimisticLockingException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class NodeOptimisticLockingTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void setUpClass() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.locking"});
    }

    @Before
    public void setUp() throws Exception {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void whenSaveNewNodeThenSetVersionToZero() {
        User frantisek = new User("Frantisek");
        this.session.save((Object)frantisek);
        Assertions.assertThat((Long)frantisek.getVersion()).isEqualTo(0L);
        this.session.clear();
        User loaded = (User)this.session.load(User.class, (Serializable)frantisek.getId());
        Assertions.assertThat((Long)loaded.getVersion()).isEqualTo(0L);
    }

    @Test
    public void givenNodeWhenUpdateNodeThenIncrementVersion() {
        User frantisek = new User("Frantisek");
        this.session.save((Object)frantisek);
        frantisek.setName("Frantisek Hartman");
        this.session.save((Object)frantisek);
        Assertions.assertThat((Long)frantisek.getVersion()).isEqualTo(1L);
        this.session.clear();
        User loaded = (User)this.session.load(User.class, (Serializable)frantisek.getId());
        Assertions.assertThat((String)loaded.getName()).isEqualTo((Object)"Frantisek Hartman");
        Assertions.assertThat((Long)loaded.getVersion()).isEqualTo(1L);
    }

    @Test
    public void givenNodeWithWrongVersionWhenSaveNodeThenFailWithOptimisticLockingException() {
        User frantisek = new User("Frantisek");
        this.session.save((Object)frantisek);
        frantisek.setName("Frantisek Hartman");
        this.session.save((Object)frantisek);
        User wrongVersion = new User("Frantisek");
        wrongVersion.setId(frantisek.getId());
        wrongVersion.setVersion(0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.session.save((Object)wrongVersion)).isInstanceOf(OptimisticLockingException.class)).hasMessageContaining("Entity with type='[User]'").hasMessageContaining("id='" + frantisek.getId() + "' had incorrect version 0");
    }

    @Test
    public void saveOnNonExistingEntityShouldFailWithOptimisticLockingException() {
        User frantisek = new User("Frantisek");
        this.session.save((Object)frantisek);
        this.session.delete((Object)frantisek);
        frantisek.setName("Frantisek Hartman");
        Assertions.assertThatThrownBy(() -> this.session.save((Object)frantisek)).isInstanceOf(OptimisticLockingException.class);
        Collection users = this.session.loadAll(User.class);
        Assertions.assertThat((Iterable)users).isEmpty();
    }

    @Test
    public void givenNodeWhenDeleteThenNodeIsDeleted() {
        User frantisek = new User("Frantisek");
        this.session.save((Object)frantisek);
        this.session.delete((Object)frantisek);
        Collection users = this.session.loadAll(User.class);
        Assertions.assertThat((Iterable)users).isEmpty();
    }

    @Test
    public void givenNodeWithWrongVersionWhenDeleteThenThrowOptimisticLockingException() {
        User frantisek = new User("Frantisek");
        this.session.save((Object)frantisek);
        frantisek.setVersion(1L);
        Assertions.assertThatThrownBy(() -> this.session.delete((Object)frantisek)).isInstanceOf(OptimisticLockingException.class);
    }

    @Test
    public void shouldWorkWithInheritedVersionField() {
        PowerUser frantisek = new PowerUser("Frantisek");
        this.session.save((Object)frantisek);
        Assertions.assertThat((Long)frantisek.getVersion()).isEqualTo(0L);
        frantisek.setName("Frantisek Hartman");
        this.session.save((Object)frantisek);
        Assertions.assertThat((Long)frantisek.getVersion()).isEqualTo(1L);
    }

    @Test
    public void shouldWorkWithCustomVersionFieldName() {
        Location london = new Location("London");
        this.session.save((Object)london);
        Assertions.assertThat((Long)london.getCustomVersion()).isEqualTo(0L);
        london.setName("Greater London");
        this.session.save((Object)london);
        Assertions.assertThat((Long)london.getCustomVersion()).isEqualTo(1L);
    }
}

