/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.locking;

import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.locking.FriendOf;
import org.neo4j.ogm.domain.locking.User;
import org.neo4j.ogm.exception.OptimisticLockingException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class SessionCacheOptimisticLockingTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void setUpClass() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.locking"});
    }

    @Before
    public void setUp() throws Exception {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldLoadNewNodeVersionInSessionAfterFailureToSave() {
        Session session1 = sessionFactory.openSession();
        User frantisek = new User("Frantisek");
        session1.save((Object)frantisek);
        Session session2 = sessionFactory.openSession();
        User updated = new User("Frantisek The Ugly");
        updated.setId(frantisek.getId());
        updated.setVersion(0L);
        session2.save((Object)updated);
        try {
            frantisek.setName("Frantisek The Mighty");
            session1.save((Object)frantisek);
            Assertions.fail((String)"Should have thrown OptimisticLockingException");
        }
        catch (OptimisticLockingException e) {
            User loaded = (User)session1.load(User.class, (Serializable)frantisek.getId());
            Assertions.assertThat((String)loaded.getName()).isEqualTo((Object)"Frantisek The Ugly");
        }
    }

    @Test
    public void shouldLoadNewNodeVersionInSessionAfterFailureToDelete() {
        Session session1 = sessionFactory.openSession();
        User frantisek = new User("Frantisek");
        session1.save((Object)frantisek);
        Session session2 = sessionFactory.openSession();
        User updated = new User("Frantisek The Ugly");
        updated.setId(frantisek.getId());
        updated.setVersion(0L);
        session2.save((Object)updated);
        try {
            session1.delete((Object)frantisek);
            Assertions.fail((String)"Should have thrown OptimisticLockingException");
        }
        catch (OptimisticLockingException e) {
            User loaded = (User)session1.load(User.class, (Serializable)frantisek.getId());
            Assertions.assertThat((String)loaded.getName()).isEqualTo((Object)"Frantisek The Ugly");
            session1.delete((Object)loaded);
            loaded = (User)session1.load(User.class, (Serializable)frantisek.getId());
            Assertions.assertThat((Object)loaded).isNull();
        }
    }

    @Test
    public void shouldLoadNewRelationshipVersionInSessionAfterFailureToSave() {
        Session session1 = sessionFactory.openSession();
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        friendOf.setDescription("m-o");
        session1.save((Object)friendOf);
        Session session2 = sessionFactory.openSession();
        FriendOf updated = new FriendOf(michael, oliver);
        updated.setDescription("updated session 2");
        updated.setId(friendOf.getId());
        updated.setVersion(0L);
        session2.save((Object)updated, 0);
        try {
            friendOf.setDescription("updated session 1");
            session1.save((Object)friendOf, 0);
            Assertions.fail((String)"Should have thrown OptimisticLockingException");
        }
        catch (OptimisticLockingException e) {
            FriendOf loaded = (FriendOf)session1.load(FriendOf.class, (Serializable)friendOf.getId());
            Assertions.assertThat((String)loaded.getDescription()).isEqualTo((Object)"updated session 2");
        }
    }

    @Test
    public void shouldLoadNewRelationshipVersionInSessionAfterFailureToDelete() {
        Session session1 = sessionFactory.openSession();
        User michael = new User("Michael");
        User oliver = new User("Oliver");
        FriendOf friendOf = michael.addFriend(oliver);
        friendOf.setDescription("m-o");
        session1.save((Object)friendOf);
        Session session2 = sessionFactory.openSession();
        FriendOf updated = new FriendOf(michael, oliver);
        updated.setDescription("updated session 2");
        updated.setId(friendOf.getId());
        updated.setVersion(0L);
        session2.save((Object)updated, 0);
        try {
            session1.delete((Object)friendOf);
            Assertions.fail((String)"Should have thrown OptimisticLockingException");
        }
        catch (OptimisticLockingException e) {
            FriendOf loaded = (FriendOf)session1.load(FriendOf.class, (Serializable)friendOf.getId());
            Assertions.assertThat((String)loaded.getDescription()).isEqualTo((Object)"updated session 2");
            session1.delete((Object)loaded);
            loaded = (FriendOf)session1.load(FriendOf.class, (Serializable)friendOf.getId());
            Assertions.assertThat((Object)loaded).isNull();
        }
    }

    @Test
    public void shouldLoadNewRelationshipVersionInSessionAfterFailureToDeleteBySave() {
        Session session1 = sessionFactory.openSession();
        User alice = new User("Alice");
        User bob = new User("Bob");
        FriendOf friendOf = alice.addFriend(bob);
        friendOf.setDescription("a-b");
        session1.save((Object)friendOf);
        Session session2 = sessionFactory.openSession();
        FriendOf updated = new FriendOf(alice, bob);
        updated.setDescription("updated session 2");
        updated.setId(friendOf.getId());
        updated.setVersion(0L);
        session2.save((Object)updated, 0);
        try {
            alice.clearFriends();
            bob.clearFriends();
            session1.save((Object)alice);
            Assertions.fail((String)"Should have thrown OptimisticLockingException");
        }
        catch (OptimisticLockingException e) {
            FriendOf loaded = (FriendOf)session1.load(FriendOf.class, (Serializable)friendOf.getId());
            Assertions.assertThat((String)loaded.getDescription()).isEqualTo((Object)"updated session 2");
            session1.delete((Object)loaded);
            loaded = (FriendOf)session1.load(FriendOf.class, (Serializable)friendOf.getId());
            Assertions.assertThat((Object)loaded).isNull();
        }
    }
}

