/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.music;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.domain.music.Album;
import org.neo4j.ogm.domain.music.Artist;
import org.neo4j.ogm.domain.music.Recording;
import org.neo4j.ogm.domain.music.Studio;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class MusicIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.music"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @After
    public void clear() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldSaveAndRetrieveEntitiesWithInvalidCharsInLabelsAndRels() {
        Studio emi = new Studio("EMI Studios, London");
        Artist theBeatles = new Artist("The Beatles");
        Album please = new Album("Please Please Me");
        Recording pleaseRecording = new Recording(please, emi, 1963);
        please.setRecording(pleaseRecording);
        theBeatles.getAlbums().add(please);
        please.setArtist(theBeatles);
        this.session.save((Object)theBeatles);
        theBeatles = (Artist)this.session.loadAll(Artist.class).iterator().next();
        Assertions.assertThat((String)theBeatles.getName()).isEqualTo((Object)"The Beatles");
        Assertions.assertThat(theBeatles.getAlbums()).hasSize(1);
        Assertions.assertThat((String)theBeatles.getAlbums().iterator().next().getName()).isEqualTo((Object)"Please Please Me");
        Assertions.assertThat((String)theBeatles.getAlbums().iterator().next().getRecording().getStudio().getName()).isEqualTo((Object)"EMI Studios, London");
        please = (Album)this.session.loadAll(Album.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Please Please Me")).iterator().next();
        Assertions.assertThat((String)please.getArtist().getName()).isEqualTo((Object)"The Beatles");
        Album hard = new Album("A Hard Day's Night");
        hard.setArtist(theBeatles);
        Recording hardRecording = new Recording(hard, emi, 1964);
        hard.setRecording(hardRecording);
        theBeatles.getAlbums().add(hard);
        this.session.save((Object)hard);
        Collection albums = this.session.loadAll(Album.class);
        Assertions.assertThat((Iterable)albums).hasSize(2);
        for (Album album : albums) {
            if (album.getName().equals("Please Please Me")) {
                Assertions.assertThat((int)album.getRecording().getYear()).isEqualTo(1963);
                continue;
            }
            Assertions.assertThat((int)album.getRecording().getYear()).isEqualTo(1964);
        }
    }

    @Test
    public void shouldLoadStudioWithLocationMissingInDomainModel() {
        this.session.query("CREATE (s:Studio {`studio-name`:'Abbey Road Studios'})", Utils.map((Object[])new Object[0]));
        Studio studio = (Studio)this.session.loadAll(Studio.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Abbey Road Studios")).iterator().next();
        Assertions.assertThat((Object)studio).isNotNull();
    }

    @Test
    public void shouldRetrieveEntityByPropertyWithZeroDepth() {
        Studio emi = new Studio("EMI Studios, London");
        Artist theBeatles = new Artist("The Beatles");
        Album please = new Album("Please Please Me");
        Recording pleaseRecording = new Recording(please, emi, 1963);
        please.setRecording(pleaseRecording);
        theBeatles.getAlbums().add(please);
        please.setArtist(theBeatles);
        this.session.save((Object)theBeatles);
        theBeatles = (Artist)this.session.loadAll(Artist.class).iterator().next();
        Assertions.assertThat((String)theBeatles.getName()).isEqualTo((Object)"The Beatles");
        Assertions.assertThat(theBeatles.getAlbums()).hasSize(1);
        Assertions.assertThat((String)theBeatles.getAlbums().iterator().next().getName()).isEqualTo((Object)"Please Please Me");
        Assertions.assertThat((String)theBeatles.getAlbums().iterator().next().getRecording().getStudio().getName()).isEqualTo((Object)"EMI Studios, London");
        this.session.clear();
        please = (Album)this.session.loadAll(Album.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Please Please Me"), 0).iterator().next();
        Assertions.assertThat((String)please.getName()).isEqualTo((Object)"Please Please Me");
        Assertions.assertThat((Object)please.getArtist()).isNull();
        Assertions.assertThat((Object)please.getRecording()).isNull();
    }

    @Test
    public void shouldSaveAndRetrieveArtistWithTwoRelationshipTypesToAlbums() {
        Studio emi = new Studio("EMI Studios, London");
        Studio olympic = new Studio("Olympic Studios, London");
        Artist theBeatles = new Artist("The Beatles");
        Artist eric = new Artist("Eric Clapton");
        Album slowhand = new Album("Slowhand");
        Recording slowRecording = new Recording(slowhand, olympic, 1977);
        slowhand.setRecording(slowRecording);
        slowhand.setArtist(eric);
        this.session.save((Object)slowhand);
        this.session.clear();
        Album theBeatlesAlbum = new Album("The Beatles");
        Recording pleaseRecording = new Recording(theBeatlesAlbum, emi, 1968);
        theBeatlesAlbum.setRecording(pleaseRecording);
        theBeatles.getAlbums().add(theBeatlesAlbum);
        theBeatlesAlbum.setArtist(theBeatles);
        theBeatlesAlbum.setGuestArtist(eric);
        this.session.save((Object)theBeatlesAlbum);
        theBeatles = (Artist)this.session.loadAll(Artist.class, new Filters().add(new Filter("name", ComparisonOperator.EQUALS, (Object)"The Beatles"))).iterator().next();
        Assertions.assertThat((String)theBeatles.getName()).isEqualTo((Object)"The Beatles");
        Assertions.assertThat(theBeatles.getAlbums()).hasSize(1);
        Assertions.assertThat((String)theBeatles.getAlbums().iterator().next().getName()).isEqualTo((Object)"The Beatles");
        Assertions.assertThat((String)theBeatles.getAlbums().iterator().next().getRecording().getStudio().getName()).isEqualTo((Object)"EMI Studios, London");
        Assertions.assertThat((Object)theBeatles.getAlbums().iterator().next().getGuestArtist()).isEqualTo((Object)eric);
        this.session.clear();
        Artist loadedEric = (Artist)this.session.loadAll(Artist.class, new Filters().add(new Filter("name", ComparisonOperator.EQUALS, (Object)"Eric Clapton"))).iterator().next();
        Assertions.assertThat((Object)loadedEric).isNotNull();
        Assertions.assertThat((String)loadedEric.getGuestAlbums().iterator().next().getName()).isEqualTo((Object)"The Beatles");
        Assertions.assertThat((String)loadedEric.getAlbums().iterator().next().getName()).isEqualTo((Object)"Slowhand");
    }

    @Test
    public void shouldBeAbleToQueryForLiteralMapWithAlias() {
        Studio emi = new Studio("EMI Studios, London");
        Artist theBeatles = new Artist("The Beatles");
        Album theBeatlesAlbum = new Album("The Beatles");
        Recording theBeatlesRec = new Recording(theBeatlesAlbum, emi, 1968);
        theBeatlesAlbum.setRecording(theBeatlesRec);
        theBeatles.getAlbums().add(theBeatlesAlbum);
        theBeatlesAlbum.setArtist(theBeatles);
        this.session.save((Object)theBeatlesAlbum);
        Album please = new Album("Please Please Me");
        Recording pleaseRecording = new Recording(please, emi, 1963);
        please.setRecording(pleaseRecording);
        theBeatles.getAlbums().add(please);
        please.setArtist(theBeatles);
        this.session.save((Object)theBeatles);
        Iterator resultIterator = ((Iterable)this.session.query("MATCH (n:`l'artiste`)-[:`HAS-ALBUM`]-(a) return {artist: collect(distinct n.name), albums: collect(a.name)} as result", Collections.EMPTY_MAP).queryResults()).iterator();
        Assertions.assertThat((boolean)resultIterator.hasNext()).isTrue();
        Map row = (Map)resultIterator.next();
        Map data = (Map)row.get("result");
        List albums = (List)data.get("albums");
        List artist = (List)data.get("artist");
        Assertions.assertThat((List)artist).hasSize(1);
        Assertions.assertThat((String)((String)artist.get(0))).isEqualTo((Object)"The Beatles");
        Assertions.assertThat((List)albums).hasSize(2);
        Assertions.assertThat((boolean)albums.contains("The Beatles")).isTrue();
        Assertions.assertThat((boolean)albums.contains("Please Please Me")).isTrue();
        Assertions.assertThat((boolean)resultIterator.hasNext()).isFalse();
    }

    @Test
    public void shouldBeAbleToQueryForLiteralMapWithoutAlias() {
        Studio emi = new Studio("EMI Studios, London");
        Artist theBeatles = new Artist("The Beatles");
        Album theBeatlesAlbum = new Album("The Beatles");
        Recording theBeatlesRec = new Recording(theBeatlesAlbum, emi, 1968);
        theBeatlesAlbum.setRecording(theBeatlesRec);
        theBeatles.getAlbums().add(theBeatlesAlbum);
        theBeatlesAlbum.setArtist(theBeatles);
        this.session.save((Object)theBeatlesAlbum);
        Album please = new Album("Please Please Me");
        Recording pleaseRecording = new Recording(please, emi, 1963);
        please.setRecording(pleaseRecording);
        theBeatles.getAlbums().add(please);
        please.setArtist(theBeatles);
        this.session.save((Object)theBeatles);
        Iterator resultIterator = ((Iterable)this.session.query("MATCH (n:`l'artiste`)-[:`HAS-ALBUM`]-(a) return {artist: collect(distinct n.name), albums: collect(a.name)}", Collections.EMPTY_MAP).queryResults()).iterator();
        Assertions.assertThat((boolean)resultIterator.hasNext()).isTrue();
        Map row = (Map)resultIterator.next();
        Map data = (Map)row.get("{artist: collect(distinct n.name), albums: collect(a.name)}");
        List albums = (List)data.get("albums");
        List artist = (List)data.get("artist");
        Assertions.assertThat((List)artist).hasSize(1);
        Assertions.assertThat((String)((String)artist.get(0))).isEqualTo((Object)"The Beatles");
        Assertions.assertThat((List)albums).hasSize(2);
        Assertions.assertThat((boolean)albums.contains("The Beatles")).isTrue();
        Assertions.assertThat((boolean)albums.contains("Please Please Me")).isTrue();
        Assertions.assertThat((boolean)resultIterator.hasNext()).isFalse();
    }

    @Test
    public void shouldSortByDomainPropertyName() {
        Studio emi = new Studio("EMI Studios, London");
        Studio olympic = new Studio("Olympic Studios, London");
        this.session.save((Object)emi);
        this.session.save((Object)olympic);
        this.session.clear();
        SortOrder name = new SortOrder().add(new String[]{"name"});
        Collection studios1 = this.session.loadAll(Studio.class, name);
        Collection studios2 = this.session.loadAll(Studio.class, name);
        Assertions.assertThat((String)((Studio)studios1.iterator().next()).getName()).isEqualTo((Object)"EMI Studios, London");
        Assertions.assertThat((String)((Studio)studios2.iterator().next()).getName()).isEqualTo((Object)"EMI Studios, London");
        studios1 = this.session.loadAll(Studio.class, new SortOrder().add(SortOrder.Direction.DESC, new String[]{"name"}));
        Assertions.assertThat((String)((Studio)studios1.iterator().next()).getName()).isEqualTo((Object)"Olympic Studios, London");
    }
}

