/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.numbers;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.persistence.examples.numbers.Bucket;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class BucketIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.persistence.examples.numbers"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @After
    public void tearDown() throws Exception {
        this.session.purgeDatabase();
    }

    @Test
    public void savedBucketShouldHaveDefaultValue() throws Exception {
        Bucket bucket = new Bucket();
        this.session.save((Object)bucket);
        this.session.clear();
        Bucket loaded = (Bucket)this.session.load(Bucket.class, (Serializable)bucket.getId());
        Assertions.assertThat(loaded.getNumbers()).containsOnly((Object[])new Integer[]{1, 2, 3});
    }

    @Test
    public void emptiedBucketShouldBeEmptyAfterReload() throws Exception {
        Bucket bucket = new Bucket();
        bucket.setNumbers(Collections.emptyList());
        this.session.save((Object)bucket);
        this.session.clear();
        Bucket loaded = (Bucket)this.session.load(Bucket.class, (Serializable)bucket.getId());
        Assertions.assertThat(loaded.getNumbers()).isEmpty();
    }
}

