/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.restaurant;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.function.ContainsAnyComparison;
import org.neo4j.ogm.cypher.function.DistanceComparison;
import org.neo4j.ogm.cypher.function.DistanceFromPoint;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.neo4j.ogm.domain.restaurant.Branch;
import org.neo4j.ogm.domain.restaurant.Franchise;
import org.neo4j.ogm.domain.restaurant.Location;
import org.neo4j.ogm.domain.restaurant.Restaurant;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class RestaurantIntegrationTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.restaurant"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @After
    public void teardown() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldSaveRestaurantWithCompositeLocationConverter() {
        Restaurant restaurant = new Restaurant("San Francisco International Airport (SFO)", new Location(37.61649, -122.38681), 94128);
        this.session.save((Object)restaurant);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RestaurantIntegrationTest.getGraphDatabaseService(), (String)"CREATE (n:`Restaurant` {name: 'San Francisco International Airport (SFO)', latitude: 37.61649, longitude: -122.38681, zip: 94128, score: 0.0, halal: false, specialities:[]})");
    }

    @Test
    public void shouldSaveBranchWitlCompositeLocationConverter() throws Exception {
        Franchise franchise = new Franchise();
        Restaurant restaurant = new Restaurant();
        Branch branch = new Branch(new Location(37.61649, -122.38681), franchise, restaurant);
        this.session.save((Object)branch);
        this.session.clear();
        Branch loaded = (Branch)this.session.load(Branch.class, (Serializable)branch.getId());
        Assertions.assertThat((double)loaded.getLocation().getLatitude()).isCloseTo(37.61649, Assertions.within((Double)1.0E-5));
        Assertions.assertThat((double)loaded.getLocation().getLongitude()).isCloseTo(-122.38681, Assertions.within((Double)1.0E-5));
    }

    @Test
    public void shouldQueryByDistance() {
        Restaurant restaurant = new Restaurant("San Francisco International Airport (SFO)", new Location(37.61649, -122.38681), 94128);
        this.session.save((Object)restaurant);
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("distance", 1000);
        Restaurant found = (Restaurant)this.session.queryForObject(Restaurant.class, "MATCH (r:Restaurant) WHERE distance(point({latitude: r.latitude, longitude:r.longitude}),point({latitude:37.0, longitude:-118.0, crs: 'WGS-84'})) < {distance}*1000 RETURN r;", parameters);
        Assertions.assertThat((Object)found).isNotNull();
    }

    @Test
    public void shouldQueryByDistanceUsingFilter() {
        Restaurant restaurant = new Restaurant("San Francisco International Airport (SFO)", new Location(37.61649, -122.38681), 94128);
        this.session.save((Object)restaurant);
        this.session.clear();
        Filter filter = new Filter(new DistanceComparison(new DistanceFromPoint(Double.valueOf(37.61649), Double.valueOf(-122.38681), Double.valueOf(1000000.0))), ComparisonOperator.LESS_THAN);
        Collection found = this.session.loadAll(Restaurant.class, filter);
        Assertions.assertThat((Iterable)found).isNotNull();
        Assertions.assertThat((found.size() >= 1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void saveAndRetrieveRestaurantWithLocation() {
        Restaurant restaurant = new Restaurant("San Francisco International Airport (SFO)", new Location(37.61649, -122.38681), 94128);
        this.session.save((Object)restaurant);
        this.session.clear();
        Collection results = this.session.loadAll(Restaurant.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"San Francisco International Airport (SFO)"));
        Assertions.assertThat((Iterable)results).hasSize(1);
        Restaurant result = (Restaurant)results.iterator().next();
        Assertions.assertThat((Object)result.getLocation()).isNotNull();
        Assertions.assertThat((double)result.getLocation().getLatitude()).isCloseTo(37.61649, Assertions.within((Double)0.0));
        Assertions.assertThat((double)result.getLocation().getLongitude()).isCloseTo(-122.38681, Assertions.within((Double)0.0));
    }

    @Test
    public void shouldSyncMappedLabelsFromEntityToTheNode_and_NodeToEntity() {
        Restaurant restaurant = new Restaurant();
        restaurant.setName("House of Mushroom & Pepperoni");
        ArrayList<String> labels = new ArrayList<String>();
        labels.add("Delicious");
        labels.add("Ambiance");
        labels.add("Convenience");
        restaurant.labels = labels;
        this.session.save((Object)restaurant);
        this.session.clear();
        Restaurant loaded = (Restaurant)this.session.load(Restaurant.class, (Serializable)restaurant.getId());
        Assertions.assertThat((boolean)loaded.labels.contains("Delicious")).isTrue();
        Assertions.assertThat((boolean)loaded.labels.contains("Ambiance")).isTrue();
        Assertions.assertThat((boolean)loaded.labels.contains("Convenience")).isTrue();
        Assertions.assertThat(loaded.labels).hasSize(3);
    }

    @Test
    public void shouldUpdateLabelsCorrectly() throws Exception {
        Franchise franchise = new Franchise();
        Restaurant r1 = new Restaurant();
        r1.setName("La Strada Tooting");
        r1.labels = Arrays.asList("Delicious", "Foreign");
        Restaurant r2 = new Restaurant();
        r2.setName("La Strada Brno");
        r2.labels = Arrays.asList("Average", "Foreign");
        franchise.addBranch(new Branch(new Location(0.0, 0.0), franchise, r1));
        franchise.addBranch(new Branch(new Location(0.0, 0.0), franchise, r2));
        this.session.save((Object)franchise);
        r1.labels = Arrays.asList("Foreign");
        r2.labels = Arrays.asList("Foreign");
        this.session.save((Object)franchise);
        this.session.clear();
        Restaurant loadedR1 = (Restaurant)this.session.load(Restaurant.class, (Serializable)r1.getId());
        Assertions.assertThat(loadedR1.labels).containsOnly((Object[])new String[]{"Foreign"});
        Restaurant loadedR2 = (Restaurant)this.session.load(Restaurant.class, (Serializable)r2.getId());
        Assertions.assertThat(loadedR2.labels).containsOnly((Object[])new String[]{"Foreign"});
    }

    @Test
    public void shouldProvideUniqueParameterNamesForFilters() {
        Restaurant restaurant = new Restaurant();
        restaurant.setName("La Cocina De Flaming Lips");
        this.session.save((Object)restaurant);
        Restaurant another = new Restaurant();
        another.setName("Antica Pesa");
        this.session.save((Object)another);
        Filters filters = new Filters();
        Filter firstFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Foobar");
        firstFilter.setBooleanOperator(BooleanOperator.OR);
        filters.add(firstFilter);
        Filter secondFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Antica Pesa");
        secondFilter.setBooleanOperator(BooleanOperator.OR);
        filters.add(secondFilter);
        Collection results = this.session.loadAll(Restaurant.class, filters);
        Assertions.assertThat((results.size() >= 1 ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void shouldFilterByIsNullOrNotNull() {
        Restaurant kuroda = new Restaurant("Kuroda", "Mainly Ramen");
        this.session.save((Object)kuroda);
        Restaurant cyma = new Restaurant();
        cyma.setName("Cyma");
        this.session.save((Object)cyma);
        this.session.clear();
        Filter descriptionIsNull = new Filter("description", ComparisonOperator.IS_NULL, null);
        Collection results = this.session.loadAll(Restaurant.class, new Filters().add(descriptionIsNull));
        Assertions.assertThat((Iterable)results).hasSize(1);
        Restaurant restaurant = (Restaurant)results.iterator().next();
        Assertions.assertThat((String)restaurant.getName()).isEqualTo((Object)"Cyma");
        Filter descriptionIsNotNull = new Filter("description", ComparisonOperator.IS_NULL, null);
        descriptionIsNotNull.setNegated(true);
        results = this.session.loadAll(Restaurant.class, new Filters().add(descriptionIsNotNull));
        Assertions.assertThat((Iterable)results).hasSize(1);
        restaurant = (Restaurant)results.iterator().next();
        Assertions.assertThat((String)restaurant.getName()).isEqualTo((Object)"Kuroda");
    }

    @Test
    public void shouldFilterByPropertyWithConverter() {
        Restaurant kuroda = new Restaurant("Kuroda", 72.4);
        kuroda.setLaunchDate(new Date(1000L));
        this.session.save((Object)kuroda);
        Restaurant cyma = new Restaurant("Cyma", 80.5);
        cyma.setLaunchDate(new Date(2000L));
        this.session.save((Object)cyma);
        Filter launchDateFilter = new Filter("launchDate", ComparisonOperator.LESS_THAN, (Object)new Date(1001L));
        Collection results = this.session.loadAll(Restaurant.class, new Filters().add(launchDateFilter));
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Assertions.assertThat((String)((Restaurant)results.iterator().next()).getName()).isEqualTo((Object)"Kuroda");
        Filter anotherFilter = new Filter("launchDate", ComparisonOperator.EQUALS, (Object)new Date(999L));
        results = this.session.loadAll(Restaurant.class, new Filters().add(anotherFilter));
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).isEmpty();
    }

    @Test
    public void shouldFilterByPropertyStartingWith() {
        Restaurant sfo = new Restaurant("San Francisco International Airport (SFO)", 72.4);
        sfo.setLaunchDate(new Date(1000L));
        this.session.save((Object)sfo);
        Restaurant kuroda = new Restaurant("Kuroda", 80.5);
        kuroda.setLaunchDate(new Date(2000L));
        this.session.save((Object)kuroda);
        Filter filter = new Filter("name", ComparisonOperator.STARTING_WITH, (Object)"San Francisco");
        Collection results = this.session.loadAll(Restaurant.class, new Filters().add(filter));
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Assertions.assertThat((String)((Restaurant)results.iterator().next()).getName()).isEqualTo((Object)"San Francisco International Airport (SFO)");
    }

    @Test
    public void shouldFilterByPropertyEndingWith() {
        Restaurant sfo = new Restaurant("San Francisco International Airport (SFO)", 72.4);
        sfo.setLaunchDate(new Date(1000L));
        this.session.save((Object)sfo);
        Restaurant kuroda = new Restaurant("Kuroda", 80.5);
        kuroda.setLaunchDate(new Date(2000L));
        this.session.save((Object)kuroda);
        Filter filter = new Filter("name", ComparisonOperator.ENDING_WITH, (Object)"Airport (SFO)");
        Collection results = this.session.loadAll(Restaurant.class, new Filters().add(filter));
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Assertions.assertThat((String)((Restaurant)results.iterator().next()).getName()).isEqualTo((Object)"San Francisco International Airport (SFO)");
    }

    @Test
    public void shouldFilterByPropertyContaining() {
        Restaurant sfo = new Restaurant("San Francisco International Airport (SFO)", 72.4);
        sfo.setLaunchDate(new Date(1000L));
        this.session.save((Object)sfo);
        Restaurant kuroda = new Restaurant("Kuroda", 80.5);
        kuroda.setLaunchDate(new Date(2000L));
        this.session.save((Object)kuroda);
        Filter filter = new Filter("name", ComparisonOperator.CONTAINING, (Object)"International Airport");
        Collection results = this.session.loadAll(Restaurant.class, new Filters().add(filter));
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Assertions.assertThat((String)((Restaurant)results.iterator().next()).getName()).isEqualTo((Object)"San Francisco International Airport (SFO)");
    }

    @Test
    public void shouldFilterByPropertyIn() {
        Restaurant sfo = new Restaurant("San Francisco International Airport (SFO)", 72.4);
        sfo.setLaunchDate(new Date(1000L));
        this.session.save((Object)sfo);
        Restaurant kuroda = new Restaurant("Kuroda", 80.5);
        kuroda.setLaunchDate(new Date(2000L));
        this.session.save((Object)kuroda);
        Filter filter = new Filter("name", ComparisonOperator.IN, (Object)new String[]{"Kuroda", "Foo", "Bar"});
        Collection results = this.session.loadAll(Restaurant.class, new Filters().add(filter));
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Assertions.assertThat((String)((Restaurant)results.iterator().next()).getName()).isEqualTo((Object)"Kuroda");
    }

    @Test
    public void shouldFilterByCollectionContaining() {
        Restaurant sfo = new Restaurant("San Francisco International Airport (SFO)", 72.4);
        sfo.getSpecialities().add("burger");
        sfo.getSpecialities().add("pizza");
        this.session.save((Object)sfo);
        Restaurant kuroda = new Restaurant("Kuroda", 80.5);
        kuroda.getSpecialities().add("sushi");
        this.session.save((Object)kuroda);
        Filter f1 = new Filter("specialities", (FilterFunction)new ContainsAnyComparison(Arrays.asList("burger")));
        Collection burgers = this.session.loadAll(Restaurant.class, new Filters(new Filter[]{f1}));
        Assertions.assertThat((Iterable)burgers).hasSize(1);
        Assertions.assertThat((String)((Restaurant)burgers.iterator().next()).getName()).isEqualTo((Object)"San Francisco International Airport (SFO)");
        Filter f2 = new Filter("specialities", (FilterFunction)new ContainsAnyComparison(Arrays.asList("burger", "sushi")));
        Collection all = this.session.loadAll(Restaurant.class, new Filters(new Filter[]{f2}));
        Assertions.assertThat((Iterable)all).hasSize(2);
        Filter f3 = new Filter("specialities", (FilterFunction)new ContainsAnyComparison(Arrays.asList("sushi", "other")));
        Collection sushi = this.session.loadAll(Restaurant.class, new Filters(new Filter[]{f3}));
        Assertions.assertThat((Iterable)sushi).hasSize(1);
    }

    @Test
    public void shouldFilterByPropertyExists() {
        Restaurant sfo = new Restaurant("San Francisco International Airport (SFO)", 72.4);
        sfo.setLaunchDate(new Date(1000L));
        this.session.save((Object)sfo);
        Restaurant kuroda = new Restaurant("Kuroda", 80.5);
        kuroda.setLaunchDate(new Date(2000L));
        this.session.save((Object)kuroda);
        Filter exists = new Filter("name", ComparisonOperator.EXISTS);
        Collection results = this.session.loadAll(Restaurant.class, new Filters().add(exists));
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).hasSize(2);
        Filter notExists = new Filter("name", ComparisonOperator.EXISTS);
        notExists.setNegated(true);
        results = this.session.loadAll(Restaurant.class, new Filters().add(notExists));
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).isEmpty();
    }

    @Test
    public void shouldFilterByPropertyIsTrue() {
        Restaurant kazan = new Restaurant("Kazan", 77.0);
        kazan.setHalal(true);
        this.session.save((Object)kazan);
        Restaurant kuroda = new Restaurant("Kuroda", 72.4);
        kuroda.setHalal(false);
        this.session.save((Object)kuroda);
        Filter isHalal = new Filter("halal", ComparisonOperator.IS_TRUE);
        Collection results = this.session.loadAll(Restaurant.class, new Filters().add(isHalal));
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Assertions.assertThat((String)((Restaurant)results.iterator().next()).getName()).isEqualTo((Object)"Kazan");
        Filter notHalal = new Filter("halal", ComparisonOperator.IS_TRUE);
        notHalal.setNegated(true);
        results = this.session.loadAll(Restaurant.class, new Filters().add(notHalal));
        Assertions.assertThat((Iterable)results).isNotNull();
        Assertions.assertThat((Iterable)results).hasSize(1);
        Assertions.assertThat((String)((Restaurant)results.iterator().next()).getName()).isEqualTo((Object)"Kuroda");
    }
}

