/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.social;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.domain.social.Individual;
import org.neo4j.ogm.domain.social.Mortal;
import org.neo4j.ogm.domain.social.Person;
import org.neo4j.ogm.domain.social.SocialUser;
import org.neo4j.ogm.domain.social.User;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.EventListener;
import org.neo4j.ogm.session.event.EventListenerAdapter;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class SocialRelationshipsIntegrationTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.social"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @After
    public void clearDatabase() {
        this.session.purgeDatabase();
    }

    @Test
    public void saveUndirectedSavesOutgoingRelationship() {
        User userA = new User("A");
        User userB = new User("B");
        userA.getFriends().add(userB);
        this.session.save((Object)userA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:User {name:'A'}) CREATE (b:User {name:'B'}) CREATE (a)-[:FRIEND]->(b)");
    }

    @Test
    public void saveUnmarkedSavesOutgoingRelationship() {
        Individual individualA = new Individual();
        individualA.setName("A");
        Individual individualB = new Individual();
        individualB.setName("B");
        individualA.setFriends(Collections.singletonList(individualB));
        this.session.save((Object)individualA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:Individual {name:'A', age: 0, code:0, bankBalance:0.0}) CREATE (b:Individual {name:'B', age:0, code:0, bankBalance:0.0}) CREATE (a)-[:FRIENDS]->(b)");
    }

    @Test
    public void saveOutgoingSavesOutgoingRelationship() {
        Person personA = new Person("A");
        Person personB = new Person("B");
        personA.getPeopleILike().add(personB);
        this.session.save((Object)personA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:Person {name:'A'}) CREATE (b:Person {name:'B'}) CREATE (a)-[:LIKES]->(b)");
    }

    @Test
    public void saveIncomingSavesIncomingRelationship() {
        Mortal mortalA = new Mortal("A");
        Mortal mortalB = new Mortal("B");
        mortalA.getKnownBy().add(mortalB);
        this.session.save((Object)mortalA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:Mortal {name:'A'}) CREATE (b:Mortal {name:'B'}) CREATE (a)<-[:KNOWN_BY]-(b)");
    }

    @Test
    public void saveOutgoingSavesOutgoingRelationshipInBothDirections() {
        Person personA = new Person("A");
        Person personB = new Person("B");
        personA.getPeopleILike().add(personB);
        personB.getPeopleILike().add(personA);
        this.session.save((Object)personA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:Person {name:'A'}) CREATE (b:Person {name:'B'}) CREATE (a)-[:LIKES]->(b) CREATE (b)-[:LIKES]->(a)");
    }

    @Test
    public void saveOutgoingToExistingNodesSavesOutgoingRelationshipInBothDirections() {
        Person personA = new Person("A");
        Person personB = new Person("B");
        this.session.save((Object)personA);
        this.session.save((Object)personB);
        personA.getPeopleILike().add(personB);
        personB.getPeopleILike().add(personA);
        this.session.save((Object)personA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:Person {name:'A'}) CREATE (b:Person {name:'B'}) CREATE (a)-[:LIKES]->(b) CREATE (b)-[:LIKES]->(a)");
    }

    @Test
    public void updateOutgoingRelSavesOutgoingRelationshipInBothDirections() {
        Person personA = new Person("A");
        Person personB = new Person("B");
        Person personC = new Person("C");
        personA.getPeopleILike().add(personB);
        personB.getPeopleILike().add(personA);
        this.session.save((Object)personA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:Person {name:'A'}) CREATE (b:Person {name:'B'}) CREATE (a)-[:LIKES]->(b) CREATE (b)-[:LIKES]->(a)");
        personA.getPeopleILike().clear();
        personA.getPeopleILike().add(personC);
        personC.getPeopleILike().add(personA);
        this.session.save((Object)personA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:Person {name:'A'}) CREATE (b:Person {name:'B'}) CREATE (c:Person {name:'C'})  CREATE (a)-[:LIKES]->(c) CREATE (c)-[:LIKES]->(a) CREATE (b)-[:LIKES]->(a)");
    }

    @Test
    public void updateOutgoingRelInListSavesOutgoingRelationshipInBothDirections() {
        Person personA = new Person("A");
        Person personB = new Person("B");
        Person personC = new Person("C");
        Person personD = new Person("D");
        personA.getPeopleILike().add(personB);
        personA.getPeopleILike().add(personC);
        personB.getPeopleILike().add(personA);
        personD.getPeopleILike().add(personA);
        this.session.save((Object)personA);
        this.session.save((Object)personB);
        this.session.save((Object)personC);
        this.session.save((Object)personD);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:Person {name:'A'}) CREATE (b:Person {name:'B'}) CREATE (c:Person {name:'C'}) CREATE (d:Person {name:'D'})CREATE (a)-[:LIKES]->(b) CREATE (a)-[:LIKES]->(c) CREATE (b)-[:LIKES]->(a) CREATE (d)-[:LIKES]->(a)");
    }

    @Test
    public void shouldManageRelationshipsToTheSameNodeType() {
        SocialUser userA = new SocialUser("A");
        SocialUser userB = new SocialUser("B");
        SocialUser userC = new SocialUser("C");
        SocialUser userD = new SocialUser("D");
        SocialUser userE = new SocialUser("E");
        SocialUser userF = new SocialUser("F");
        SocialUser userG = new SocialUser("G");
        HashSet<SocialUser> friends = new HashSet<SocialUser>();
        friends.add(userB);
        friends.add(userE);
        HashSet<SocialUser> following = new HashSet<SocialUser>();
        following.add(userB);
        following.add(userE);
        HashSet<SocialUser> followers = new HashSet<SocialUser>();
        followers.add(userB);
        followers.add(userE);
        userA.setFollowers(followers);
        userA.setFriends(friends);
        userA.setFollowing(following);
        this.session.save((Object)userA);
        this.session.clear();
        userA = (SocialUser)this.session.load(SocialUser.class, (Serializable)userA.getId());
        Assertions.assertThat(userA.getFriends()).hasSize(2);
        Assertions.assertThat(userA.getFollowers()).hasSize(2);
        Assertions.assertThat(userA.getFollowing()).hasSize(2);
    }

    @Test
    public void shouldUseOptimizedQueryToSaveExistingRelations() {
        SocialUser userA = new SocialUser("A");
        SocialUser userB = new SocialUser("B");
        SocialUser userE = new SocialUser("E");
        this.session.save((Object)userA);
        this.session.save((Object)userB);
        this.session.save((Object)userE);
        HashSet<SocialUser> friends = new HashSet<SocialUser>();
        friends.add(userB);
        friends.add(userE);
        HashSet<SocialUser> following = new HashSet<SocialUser>();
        following.add(userB);
        following.add(userE);
        HashSet<SocialUser> followers = new HashSet<SocialUser>();
        followers.add(userB);
        followers.add(userE);
        userA.setFollowers(followers);
        userA.setFriends(friends);
        userA.setFollowing(following);
        this.session.save((Object)userA);
        this.session.clear();
        userA = (SocialUser)this.session.load(SocialUser.class, (Serializable)userA.getId());
        Assertions.assertThat(userA.getFriends()).hasSize(2);
        Assertions.assertThat(userA.getFollowers()).hasSize(2);
        Assertions.assertThat(userA.getFollowing()).hasSize(2);
    }

    @Test
    public void removeUndirectedRelationship() {
        User userA = new User("A");
        User userB = new User("B");
        userA.getFriends().add(userB);
        this.session.save((Object)userA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:User {name:'A'}) CREATE (b:User {name:'B'}) CREATE (a)-[:FRIEND]->(b)");
        userA.unfriend(userB);
        this.session.save((Object)userA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)SocialRelationshipsIntegrationTest.getGraphDatabaseService(), (String)"CREATE (a:User {name:'A'}) CREATE (b:User {name:'B'})");
    }

    @Test
    public void shouldBePossibleToDeleteRelationshipToPurgedNodeWithEventListener() throws Exception {
        this.session.register((EventListener)new EventListenerAdapter());
        Person a1 = new Person("a1");
        Person a2 = new Person("a2");
        Person b = new Person("b");
        a1.setPeopleILike(Arrays.asList(b));
        a2.setPeopleILike(Arrays.asList(b));
        this.session.save((Object)a1);
        this.session.save((Object)a2);
        a1.setPeopleILike(Collections.emptyList());
        this.session.save((Object)a1);
        a2.setPeopleILike(Collections.emptyList());
        this.session.save((Object)a2);
    }
}

