/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.examples.spies;

import java.io.IOException;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.spies.Spy;
import org.neo4j.ogm.domain.spies.Target;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class SpyIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.spies"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @Test
    public void shouldSaveAndLoadSpyInEachDirection() {
        Spy mata = new Spy("Mata Hari");
        Spy julius = new Spy("Julius Rosenberg");
        Target mataJulius = new Target();
        mataJulius.setSpy(mata);
        mataJulius.setTarget(julius);
        mataJulius.setCode("Hawk");
        Target juliusMata = new Target();
        juliusMata.setSpy(julius);
        juliusMata.setTarget(mata);
        juliusMata.setCode("Robin");
        mata.setSpiesOn(mataJulius);
        mata.setSpiedOnBy(juliusMata);
        julius.setSpiesOn(juliusMata);
        julius.setSpiedOnBy(mataJulius);
        this.session.save((Object)mata);
        this.session.save((Object)julius);
        this.session.clear();
        mata = (Spy)this.session.load(Spy.class, (Serializable)mata.getId());
        Assertions.assertThat((Object)mata).isNotNull();
        Assertions.assertThat((String)mata.getSpiesOn().getTarget().getName()).isEqualTo((Object)julius.getName());
        Assertions.assertThat((String)mata.getSpiedOnBy().getCode()).isEqualTo((Object)"Robin");
        Assertions.assertThat((String)mata.getSpiedOnBy().getSpy().getName()).isEqualTo((Object)julius.getName());
        this.session.clear();
        julius = (Spy)this.session.load(Spy.class, (Serializable)julius.getId());
        Assertions.assertThat((Object)julius).isNotNull();
        Assertions.assertThat((String)julius.getSpiesOn().getTarget().getName()).isEqualTo((Object)mata.getName());
        Assertions.assertThat((String)julius.getSpiedOnBy().getCode()).isEqualTo((Object)"Hawk");
        Assertions.assertThat((String)julius.getSpiedOnBy().getSpy().getName()).isEqualTo((Object)mata.getName());
    }
}

