/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.identity;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityTest
extends MultiDriverTestClass {
    private static final Logger logger = LoggerFactory.getLogger(IdentityTest.class);
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.persistence.identity"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
    }

    @After
    public void cleanup() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldCreateRelationshipEntityWhenDifferentStartAndEndNodesAreHashCodeEqual() {
        Node start = new Node();
        Node end = new Node();
        Assertions.assertThat((Object)end).isEqualTo((Object)start);
        HashSet<Node> nodes = new HashSet<Node>();
        nodes.add(start);
        nodes.add(end);
        Assertions.assertThat(nodes).hasSize(1);
        this.session.save((Object)start);
        this.session.save((Object)end);
        Edge edge = new Edge();
        edge.start = start;
        edge.end = end;
        start.link = edge;
        this.session.save((Object)edge);
        this.session.clear();
        Node checkNode = (Node)this.session.load(Node.class, (Serializable)start.id);
        Assertions.assertThat((Object)checkNode.link).isNotNull();
        Assertions.assertThat((Long)checkNode.link.start.id).isEqualTo((Object)start.id);
        Assertions.assertThat((Long)checkNode.link.end.id).isEqualTo((Object)end.id);
    }

    @Test
    public void shouldBeAbleToLoadAllNodesOfATypeEvenIfTheyAreConsideredEqual() {
        Node nodeA = new Node();
        this.session.save((Object)nodeA);
        Node nodeB = new Node();
        this.session.save((Object)nodeB);
        this.session.clear();
        Collection allNodes = this.session.loadAll(Node.class);
        Assertions.assertThat((Iterable)allNodes).hasSize(2);
    }

    @Test
    public void shouldBeAbleToLoadAllREsEvenIfTheyAreConsideredEqual() {
        Node nodeA = new Node();
        this.session.save((Object)nodeA);
        Node nodeB = new Node();
        this.session.save((Object)nodeB);
        Node nodeC = new Node();
        this.session.save((Object)nodeC);
        Edge edge1 = new Edge();
        edge1.start = nodeA;
        edge1.end = nodeB;
        this.session.save((Object)edge1);
        Edge edge2 = new Edge();
        edge2.start = nodeB;
        edge2.end = nodeC;
        this.session.save((Object)edge2);
        this.session.clear();
        Collection allEdges = this.session.loadAll(Edge.class);
        Assertions.assertThat((Iterable)allEdges).hasSize(2);
    }

    @Test
    public void shouldBeAbleToLoadAllRelatedNodesIfTheyAreConsideredEqual() throws Exception {
        Node nodeA = new Node();
        Node nodeB = new Node();
        Node nodeC = new Node();
        nodeA.related = Arrays.asList(nodeB, nodeC);
        this.session.save((Object)nodeA);
        logger.info("related: {}", nodeA.related);
        this.session.clear();
        Node loadedA = (Node)this.session.load(Node.class, (Serializable)nodeA.id);
        logger.info("related: {}", loadedA.related);
        Assertions.assertThat(loadedA.related).hasSize(2);
    }

    @Test
    public void indistinguishableRelationshipsMapAsSingleRelatedEntityInstance() throws Exception {
        Map ids = IdentityTest.getGraphDatabaseService().execute("CREATE (n1:NODE), (n2:NODE),(n1)-[:RELATED]->(n2),(n1)-[:RELATED]->(n2)RETURN id(n1) AS id1, id(n2) AS id2").next();
        Node node = (Node)this.session.load(Node.class, (Serializable)((Long)ids.get("id1")));
        Assertions.assertThat(node.related).hasSize(1);
    }

    @Test
    public void indistinguishableEntityInstancesMapAsSingleRelationship() throws Exception {
        Node nodeA = new Node();
        Node nodeB = new Node();
        nodeA.related = Arrays.asList(nodeB, nodeB);
        this.session.save((Object)nodeA);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)IdentityTest.getGraphDatabaseService(), (String)"CREATE (n1:NODE), (n2:NODE),(n1)-[:RELATED]->(n2)");
    }

    @RelationshipEntity(type="EDGE")
    public static class Edge {
        Long id;
        @StartNode
        Node start;
        @EndNode
        Node end;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }
    }

    @NodeEntity(label="NODE")
    public static class Node {
        Long id;
        @Relationship(type="EDGE")
        Edge link;
        @Relationship(type="RELATED", direction="OUTGOING")
        List<Node> related;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 1;
        }

        public String toString() {
            return "Node{id=" + this.id + '}';
        }
    }
}

