/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.persistence.examples.stage.edges.LastDrama;
import org.neo4j.ogm.persistence.examples.stage.edges.PlayedInDrama;
import org.neo4j.ogm.persistence.examples.stage.nodes.Drama;
import org.neo4j.ogm.persistence.examples.stage.nodes.StageActor;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class AbstractWithGenericPropertyRelationshipTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.persistence.model", "org.neo4j.ogm.persistence.examples.stage"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldReloadEntitiesJustSaved() {
        StageActor stageActor = new StageActor("first actor");
        Drama firstDrama = new Drama("malade imaginaire");
        Drama secondDrama = new Drama("Le cid");
        stageActor.dramas.add(new PlayedInDrama(stageActor, firstDrama, "rel1"));
        stageActor.dramas.add(new PlayedInDrama(stageActor, secondDrama, "rel2"));
        stageActor.lastDrama = new LastDrama(stageActor, secondDrama, "last");
        this.session.save((Object)stageActor);
        this.session.clear();
        StageActor reloadedActor = (StageActor)this.session.load(StageActor.class, (Serializable)stageActor.id);
        Assertions.assertThat(reloadedActor.dramas).hasSize(2);
        Assertions.assertThat((Object)reloadedActor.lastDrama).isNotNull();
    }

    @Ignore
    @Test
    public void testQueryByGenericRelationshipType() {
        SomeNode someNode = new SomeNode();
        this.session.save(someNode);
        SomeOtherNode someOtherNode = new SomeOtherNode();
        this.session.save((Object)someOtherNode);
        RelationshipImplementation relationshipImplementation = new RelationshipImplementation();
        relationshipImplementation.a = someNode;
        relationshipImplementation.b = someOtherNode;
        this.session.save(relationshipImplementation);
        AnotherRelationshipImplementation anotherRelationshipImplementation = new AnotherRelationshipImplementation();
        anotherRelationshipImplementation.a = someNode;
        anotherRelationshipImplementation.b = someOtherNode;
        this.session.save(anotherRelationshipImplementation);
        Collection relationship = this.session.loadAll(L.class);
        Assertions.assertThat((Iterable)relationship).hasSize(1);
    }

    @Test
    public void testGenericTypeInConcreteRelationship() {
        SomeNode someNode = new SomeNode();
        this.session.save(someNode);
        SomeOtherNode someOtherNode = new SomeOtherNode();
        this.session.save((Object)someOtherNode);
        RelationshipImplementation relationshipImplementation = new RelationshipImplementation();
        relationshipImplementation.a = someNode;
        relationshipImplementation.b = someOtherNode;
        this.session.save(relationshipImplementation);
        AnotherRelationshipImplementation anotherRelationshipImplementation = new AnotherRelationshipImplementation();
        anotherRelationshipImplementation.a = someNode;
        anotherRelationshipImplementation.b = someOtherNode;
        this.session.save(anotherRelationshipImplementation);
        AnotherRelationshipImplementation retrieved = (AnotherRelationshipImplementation)this.session.load(AnotherRelationshipImplementation.class, (Serializable)anotherRelationshipImplementation.id);
        Assertions.assertThat((Long)someNode.id).isEqualTo((Object)retrieved.a.id);
    }

    @NodeEntity
    public final class SomeOtherNode {
        Long id;
    }

    @NodeEntity
    public final class SomeNode<T> {
        Long id;
        @Relationship
        private List<L<T>> listOfLs;
    }

    @RelationshipEntity(type="abstractDynamicProperty")
    public abstract class L<T> {
        Long id;
        private T property;
        @StartNode
        public SomeNode a;
        @EndNode
        public SomeOtherNode b;
    }

    @RelationshipEntity(type="relDynamicProperty")
    public class RelationshipImplementation<T>
    extends L<T> {
    }

    @RelationshipEntity(type="otherRelDynamicProperty")
    public class AnotherRelationshipImplementation<T>
    extends L<T> {
    }
}

