/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.context.EntityGraphMapper;
import org.neo4j.ogm.context.EntityMapper;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.cypher.compiler.Compiler;
import org.neo4j.ogm.domain.blog.Post;
import org.neo4j.ogm.domain.education.Course;
import org.neo4j.ogm.domain.education.School;
import org.neo4j.ogm.domain.education.Student;
import org.neo4j.ogm.domain.education.Teacher;
import org.neo4j.ogm.domain.forum.Forum;
import org.neo4j.ogm.domain.forum.ForumTopicLink;
import org.neo4j.ogm.domain.forum.Topic;
import org.neo4j.ogm.domain.policy.Person;
import org.neo4j.ogm.domain.policy.Policy;
import org.neo4j.ogm.domain.social.Individual;
import org.neo4j.ogm.domain.types.EntityWithUnmanagedFieldType;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.request.StatementFactory;
import org.neo4j.ogm.request.Statements;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.request.RowStatementFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class EntityGraphMapperTest
extends MultiDriverTestClass {
    private EntityMapper mapper;
    private static MetaData mappingMetadata;
    private static MappingContext mappingContext;
    private Session session;

    @BeforeClass
    public static void setUpTestDatabase() {
        mappingMetadata = new MetaData(new String[]{"org.neo4j.ogm.domain.education", "org.neo4j.ogm.domain.forum", "org.neo4j.ogm.domain.social", "org.neo4j.ogm.domain.policy"});
        mappingContext = new MappingContext(mappingMetadata);
    }

    @Before
    public void setUpMapper() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.policy", "org.neo4j.ogm.domain.election", "org.neo4j.ogm.domain.forum", "org.neo4j.ogm.domain.education", "org.neo4j.ogm.domain.types"});
        mappingContext.clear();
        this.mapper = new EntityGraphMapper(mappingMetadata, mappingContext);
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test(expected=NullPointerException.class)
    public void shouldThrowExceptionOnAttemptToMapNullObjectToCypherQuery() {
        this.mapper.map(null);
    }

    @Test
    public void createObjectWithLabelsAndProperties() {
        Student newStudent = new Student("Gary");
        this.session.save((Object)newStudent);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (:Student:DomainObject {name:\"Gary\"})");
    }

    @Test
    public void updateObjectPropertyAndLabel() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (s:Student {name:'Sheila Smythe'}) RETURN id(s) AS id");
        Long sid = Long.valueOf(executionResult.next().get("id").toString());
        Student sheila = (Student)this.session.load(Student.class, (Serializable)sid);
        sheila.setName("Sheila Smythe-Jones");
        this.session.save((Object)sheila);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (s:DomainObject:Student {name:'Sheila Smythe-Jones'})");
    }

    @Test
    public void doNothingIfNothingHasChanged() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (s:Student:DomainObject {name:'Sheila Smythe'}) RETURN id(s) AS id");
        Long existingNodeId = Long.valueOf(executionResult.next().get("id").toString());
        Student sheila = new Student();
        sheila.setId(existingNodeId);
        sheila.setName("Sheila Smythe");
        mappingContext.addNodeEntity((Object)sheila);
        Compiler compiler = this.mapper.map((Object)sheila).getCompiler();
        compiler.useStatementFactory((StatementFactory)new RowStatementFactory());
        Statements cypher = new Statements(compiler.getAllStatements());
        Assertions.assertThat((List)cypher.getStatements()).isEmpty();
    }

    @Test
    public void addObjectToCollection() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (c:Course {name:'BSc Computer Science'})-[:STUDENTS]->(s:Student:DomainObject {name:'Gianfranco'}) RETURN id(s) AS student_id, id(c) AS course_id");
        Map resultSetRow = executionResult.next();
        Long studentId = Long.valueOf(resultSetRow.get("student_id").toString());
        Long courseId = Long.valueOf(resultSetRow.get("course_id").toString());
        Student gianFranco = (Student)this.session.load(Student.class, (Serializable)studentId);
        Course bscComputerScience = (Course)this.session.load(Course.class, (Serializable)courseId);
        Student lakshmipathy = new Student("Lakshmipathy");
        bscComputerScience.setStudents(Arrays.asList(lakshmipathy, gianFranco));
        this.session.save((Object)bscComputerScience);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (c:Course {name:'BSc Computer Science'}), (x:Student:DomainObject {name:'Gianfranco'}), (y:Student:DomainObject {name:'Lakshmipathy'}) WITH c, x, y MERGE (c)-[:STUDENTS]->(x) MERGE (c)-[:STUDENTS]->(y)");
    }

    @Test
    public void persistManyToOneObjectFromSingletonSide() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (s:School:DomainObject {name:'Waller'})-[:TEACHERS]->(t:Teacher {name:'Mary'})-[:SCHOOL]->(s) RETURN id(s) AS school_id, id(t) AS teacher_id");
        Map resultSetRow = executionResult.next();
        Long wallerId = Long.valueOf(resultSetRow.get("school_id").toString());
        Long maryId = Long.valueOf(resultSetRow.get("teacher_id").toString());
        School waller = (School)this.session.load(School.class, (Serializable)wallerId);
        Teacher mary = (Teacher)this.session.load(Teacher.class, (Serializable)maryId);
        mary.setId(maryId);
        Teacher jim = new Teacher("Jim");
        jim.setSchool(waller);
        Assertions.assertThat((boolean)waller.getTeachers().contains(jim)).isTrue();
        this.session.save((Object)jim);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (s:School:DomainObject {name:'Waller'}), (m:Teacher {name:'Mary'}), (j:Teacher {name:'Jim'}), (j)-[:SCHOOL]->(s), (m)-[:SCHOOL]->(s), (s)-[:TEACHERS]->(j), (s)-[:TEACHERS]->(m)");
    }

    @Test
    public void shouldNotGetIntoAnInfiniteLoopWhenSavingObjectsThatReferenceEachOther() {
        Teacher missJones = new Teacher("Miss Jones");
        Teacher mrWhite = new Teacher("Mr White");
        School school = new School("Hilly Fields");
        school.setTeachers(Arrays.asList(missJones, mrWhite));
        this.session.save((Object)school);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (j:Teacher {name:'Miss Jones'}), (w:Teacher {name:'Mr White'}), (s:School:DomainObject {name:'Hilly Fields'}), (s)-[:TEACHERS]->(j)-[:SCHOOL]->(s), (s)-[:TEACHERS]->(w)-[:SCHOOL]->(s)");
    }

    @Test
    public void shouldCorrectlyPersistObjectGraphsSeveralLevelsDeep() {
        Student sheila = new Student();
        sheila.setName("Sheila Smythe");
        Student gary = new Student();
        gary.setName("Gary Jones");
        Student winston = new Student();
        winston.setName("Winston Charles");
        Course physics = new Course();
        physics.setName("GCSE Physics");
        physics.setStudents(Arrays.asList(gary, sheila));
        Course maths = new Course();
        maths.setName("A-Level Mathematics");
        maths.setStudents(Arrays.asList(sheila, winston));
        Teacher teacher = new Teacher();
        teacher.setName("Mrs Kapoor");
        teacher.setCourses(Arrays.asList(physics, maths));
        this.session.save((Object)teacher);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (t:Teacher {name:'Mrs Kapoor'}), (p:Course {name:'GCSE Physics'}), (m:Course {name:'A-Level Mathematics'}), (s:Student:DomainObject {name:'Sheila Smythe'}), (g:Student:DomainObject {name:'Gary Jones'}), (w:Student:DomainObject {name:'Winston Charles'}), (t)-[:COURSES]->(p)-[:STUDENTS]->(s), (t)-[:COURSES]->(m)-[:STUDENTS]->(s), (p)-[:STUDENTS]->(g), (m)-[:STUDENTS]->(w)");
    }

    @Test
    public void shouldCorrectlyRemoveRelationshipWhenItemIsRemovedFromCollection() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (c:Course {name:'GCSE Music'}), (c)-[:STUDENTS]->(x:Student:DomainObject {name:'Xavier'}), (c)-[:STUDENTS]->(y:Student:DomainObject {name:'Yvonne'}), (c)-[:STUDENTS]->(z:Student:DomainObject {name:'Zack'}) RETURN id(c) AS course_id, id(x) AS xid, id(y) AS yid, id(z) AS zid");
        Map results = executionResult.next();
        executionResult.close();
        Long mid = (Long)results.get("course_id");
        Long xid = (Long)results.get("xid");
        Long yid = (Long)results.get("yid");
        Long zid = (Long)results.get("zid");
        Course music = (Course)this.session.load(Course.class, (Serializable)mid);
        Student xavier = (Student)this.session.load(Student.class, (Serializable)xid);
        Student yvonne = (Student)this.session.load(Student.class, (Serializable)yid);
        Student zack = (Student)this.session.load(Student.class, (Serializable)zid);
        music.setStudents(Arrays.asList(yvonne, xavier, zack));
        music.setStudents(Arrays.asList(yvonne));
        this.session.save((Object)music);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (:Student:DomainObject {name:'Xavier'}), (:Student:DomainObject {name:'Zack'}), (:Course {name:'GCSE Music'})-[:STUDENTS]->(:Student:DomainObject {name:'Yvonne'})");
    }

    @Test
    public void shouldCorrectlyRemoveRelationshipWhenItemIsMovedToDifferentCollection() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (t:Teacher {name:'Ms Thompson'}), (bs:Course {name:'GNVQ Business Studies'})-[:STUDENTS]->(s:Student:DomainObject {name:'Shivani'}), (dt:Course {name:'GCSE Design & Technology'})-[:STUDENTS]->(j:Student:DomainObject {name:'Jeff'}), (t)-[:COURSES]->(bs), (t)-[:COURSES]->(dt) RETURN id(t) AS teacher_id, id(bs) AS bs_id, id(dt) AS dt_id, id(s) AS s_id");
        Map results = executionResult.next();
        Long teacherId = (Long)results.get("teacher_id");
        Long businessStudiesCourseId = (Long)results.get("bs_id");
        Long designTechnologyCourseId = (Long)results.get("dt_id");
        Long studentId = (Long)results.get("s_id");
        Course designTech = (Course)this.session.load(Course.class, (Serializable)designTechnologyCourseId);
        Course businessStudies = (Course)this.session.load(Course.class, (Serializable)businessStudiesCourseId);
        Teacher msThompson = (Teacher)this.session.load(Teacher.class, (Serializable)teacherId);
        Student shivani = (Student)this.session.load(Student.class, (Serializable)studentId);
        businessStudies.setStudents(Collections.emptyList());
        designTech.getStudents().add(shivani);
        this.session.save((Object)msThompson);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (t:Teacher {name:'Ms Thompson'}), (bs:Course {name:'GNVQ Business Studies'}), (dt:Course {name:'GCSE Design & Technology'}), (dt)-[:STUDENTS]->(j:Student:DomainObject {name:'Jeff'}), (dt)-[:STUDENTS]->(s:Student:DomainObject {name:'Shivani'}), (t)-[:COURSES]->(bs), (t)-[:COURSES]->(dt)");
    }

    @Test
    @Ignore(value="Have to investigate why this fails intermittently")
    public void shouldCorrectlyRemoveRelationshipWhenItemIsDisconnectedFromNonOwningSide() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (s:School:DomainObject), (s)-[:TEACHERS]->(j:Teacher {name:'Miss Jones'}), (s)-[:TEACHERS]->(w:Teacher {name:'Mr White'}) RETURN id(s) AS school_id, id(j) AS jones_id, id(w) AS white_id");
        Map results = executionResult.next();
        executionResult.close();
        Long schoolId = (Long)results.get("school_id");
        Long whiteId = (Long)results.get("white_id");
        Long jonesId = (Long)results.get("jones_id");
        School hillsRoad = (School)this.session.load(School.class, (Serializable)schoolId);
        Teacher mrWhite = (Teacher)this.session.load(Teacher.class, (Serializable)whiteId);
        Teacher missJones = (Teacher)this.session.load(Teacher.class, (Serializable)jonesId);
        mrWhite.setSchool(null);
        this.session.save((Object)hillsRoad);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (w:Teacher {name:'Mr White'}), (j:Teacher {name:'Miss Jones'}), (s:School:DomainObject), (s)-[:TEACHERS]->(j), (j)-[:SCHOOL]->(s)");
    }

    @Test
    public void testVariablePersistenceToDepthZero() {
        Teacher claraOswald = new Teacher();
        Teacher dannyPink = new Teacher();
        School coalHillSchool = new School("Coal Hill");
        coalHillSchool.setTeachers(Arrays.asList(claraOswald, dannyPink));
        this.session.save((Object)coalHillSchool, 0);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (s:School:DomainObject {name:'Coal Hill'}) RETURN s");
    }

    @Test
    public void shouldGenerateCypherToPersistArraysOfPrimitives() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.social"});
        this.session = sessionFactory.openSession();
        Individual individual = new Individual();
        individual.setName("Jeff");
        individual.setAge(41);
        individual.setBankBalance(1000.5f);
        individual.setPrimitiveIntArray(new int[]{1, 6, 4, 7, 2});
        this.session.save((Object)individual);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (:Individual {name:'Jeff', age:41, bankBalance: 1000.50, code:0, primitiveIntArray:[1,6,4,7,2]})");
        this.session.clear();
        Individual loadedIndividual = (Individual)this.session.load(Individual.class, (Serializable)individual.getId());
        Assertions.assertThat((int[])loadedIndividual.getPrimitiveIntArray()).isEqualTo((Object)individual.getPrimitiveIntArray());
    }

    @Test
    public void shouldGenerateCypherToPersistByteArray() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.social"});
        this.session = sessionFactory.openSession();
        Individual individual = new Individual();
        individual.setAge(41);
        individual.setBankBalance(1000.5f);
        individual.setPrimitiveByteArray(new byte[]{1, 2, 3, 4, 5});
        this.session.save((Object)individual);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (:Individual {age:41, bankBalance: 1000.50, code:0, primitiveByteArray:'AQIDBAU='})");
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("MATCH (i:Individual) RETURN i.primitiveByteArray AS bytes");
        Map result = executionResult.next();
        executionResult.close();
        Assertions.assertThat(result.get("bytes")).as("The array wasn't persisted as the correct type", new Object[0]).isEqualTo((Object)"AQIDBAU=");
    }

    @Test
    public void shouldGenerateCypherToPersistCollectionOfBoxedPrimitivesToArrayOfPrimitives() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.social"});
        this.session = sessionFactory.openSession();
        Individual individual = new Individual();
        individual.setName("Gary");
        individual.setAge(36);
        individual.setBankBalance(99.25f);
        individual.setFavouriteRadioStations(new Vector<Double>(Arrays.asList(97.4, 105.4, 98.2)));
        this.session.save((Object)individual);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (:Individual {name:'Gary', age:36, bankBalance:99.25, code:0, favouriteRadioStations:[97.4, 105.4, 98.2]})");
    }

    @Test
    public void testVariablePersistenceToDepthOne() {
        School coalHillSchool = new School("Coal Hill");
        Teacher claraOswald = new Teacher("Clara Oswald");
        Teacher dannyPink = new Teacher("Danny Pink");
        Course english = new Course("English");
        Course maths = new Course("Maths");
        coalHillSchool.setTeachers(Arrays.asList(claraOswald, dannyPink));
        claraOswald.setCourses(Arrays.asList(english));
        dannyPink.setCourses(Arrays.asList(maths));
        this.session.save((Object)coalHillSchool, 1);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (s:School:DomainObject {name:'Coal Hill'}), (c:Teacher {name:'Clara Oswald'}), (d:Teacher {name:'Danny Pink'}), (s)-[:TEACHERS]->(c), (s)-[:TEACHERS]->(d)");
    }

    @Test
    public void testVariablePersistenceToDepthTwo() {
        School coalHillSchool = new School("Coal Hill");
        Teacher claraOswald = new Teacher("Clara Oswald");
        Teacher dannyPink = new Teacher("Danny Pink");
        Course english = new Course("English");
        Course maths = new Course("Maths");
        coalHillSchool.setTeachers(Arrays.asList(claraOswald, dannyPink));
        claraOswald.setCourses(Arrays.asList(english));
        dannyPink.setCourses(Arrays.asList(maths));
        this.session.save((Object)coalHillSchool, 2);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (school:School:DomainObject {name:'Coal Hill'}), (clara:Teacher {name:'Clara Oswald'}), (danny:Teacher {name:'Danny Pink'}), (english:Course {name:'English'}), (maths:Course {name:'Maths'}), (school)-[:TEACHERS]->(clara)-[:SCHOOL]->(school), (school)-[:TEACHERS]->(danny)-[:SCHOOL]->(school), (danny)-[:COURSES]->(maths), (clara)-[:COURSES]->(english)");
    }

    @Test
    public void shouldProduceCypherForSavingNewRichRelationshipBetweenNodes() {
        Forum forum = new Forum();
        forum.setName("SDN FAQs");
        Topic topic = new Topic();
        ForumTopicLink link = new ForumTopicLink();
        link.setForum(forum);
        link.setTopic(topic);
        link.setTimestamp(1647209L);
        forum.setTopicsInForum(Arrays.asList(link));
        this.session.save((Object)forum);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (f:Forum {name:'SDN FAQs'})-[:HAS_TOPIC {timestamp:1647209}]->(t:Topic)");
    }

    @Test
    public void shouldProduceCypherForUpdatingExistingRichRelationshipBetweenNodes() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (f:Forum {name:'Spring Data Neo4j'})-[r:HAS_TOPIC {timestamp:20000}]->(t:Topic {inActive:false}) RETURN id(f) AS forumId, id(t) AS topicId, id(r) AS relId");
        Map rs = executionResult.next();
        Long forumId = (Long)rs.get("forumId");
        Long topicId = (Long)rs.get("topicId");
        Long relationshipId = (Long)rs.get("relId");
        Forum forum = (Forum)this.session.load(Forum.class, (Serializable)forumId);
        Topic topic = (Topic)this.session.load(Topic.class, (Serializable)topicId);
        ForumTopicLink link = (ForumTopicLink)this.session.load(ForumTopicLink.class, (Serializable)relationshipId);
        link.setTimestamp(327790L);
        forum.setTopicsInForum(Arrays.asList(link));
        this.session.save((Object)forum);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (f:Forum {name:'Spring Data Neo4j'})-[r:HAS_TOPIC {timestamp:327790}]->(t:Topic {inActive:false})");
    }

    @Ignore
    @Test
    public void shouldSaveCollectionOfRichRelationships() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (f:Forum {name:'SDN 4.x'})-[r:HAS_TOPIC]->(t:Topic) RETURN id(f) AS forumId, id(r) AS relId, id(t) AS topicId");
        Map resultSet = executionResult.next();
        executionResult.close();
        Long forumId = (Long)resultSet.get("forumId");
        Long relationshipId = (Long)resultSet.get("relId");
        Long topicId = (Long)resultSet.get("topicId");
        Forum neo4jForum = new Forum();
        neo4jForum.setName("Neo4j Questions");
        Topic neo4jTopicOne = new Topic();
        Topic neo4jTopicTwo = new Topic();
        Forum sdnForum = new Forum();
        sdnForum.setId(forumId);
        sdnForum.setName("SDN 4.x");
        Topic sdnTopic = new Topic();
        sdnTopic.setTopicId(topicId);
        ForumTopicLink firstRelationshipEntity = new ForumTopicLink();
        firstRelationshipEntity.setId(relationshipId);
        firstRelationshipEntity.setForum(sdnForum);
        firstRelationshipEntity.setTopic(sdnTopic);
        firstRelationshipEntity.setTimestamp(500L);
        ForumTopicLink secondRelationshipEntity = new ForumTopicLink();
        secondRelationshipEntity.setForum(neo4jForum);
        secondRelationshipEntity.setTopic(neo4jTopicTwo);
        secondRelationshipEntity.setTimestamp(750L);
        ForumTopicLink thirdRelationshipEntity = new ForumTopicLink();
        thirdRelationshipEntity.setForum(neo4jForum);
        thirdRelationshipEntity.setTopic(neo4jTopicOne);
        thirdRelationshipEntity.setTimestamp(1000L);
        List<ForumTopicLink> linksToSave = Arrays.asList(firstRelationshipEntity, secondRelationshipEntity, thirdRelationshipEntity);
        Statements cypher = new Statements(this.mapper.map(linksToSave).getCompiler().getAllStatements());
        this.executeStatementsAndAssertSameGraph(cypher, "CREATE (:Forum {name:'SDN 4.x'})-[:HAS_TOPIC {timestamp:500}]->(x:Topic), (f:Forum {name:'Neo4j Questions'})-[:HAS_TOPIC {timestamp:750}]->(y:Topic), (f)-[:HAS_TOPIC {timestamp:1000}]->(z:Topic)");
    }

    @Test
    public void testCreateFirstReferenceFromOutgoingSide() {
        Person person1 = new Person("jim");
        Policy policy1 = new Policy("health");
        person1.getWritten().add(policy1);
        this.session.save((Object)person1);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (:Person:DomainObject { name :'jim' })-[:WRITES_POLICY]->(:Policy:DomainObject { name: 'health' })");
    }

    @Test
    public void testCreateFirstReferenceFromIncomingSide() {
        Person person1 = new Person("jim");
        Policy policy1 = new Policy("health");
        policy1.getWriters().add(person1);
        this.session.save((Object)policy1);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (:Person:DomainObject { name :'jim' })-[:WRITES_POLICY]->(:Policy:DomainObject { name: 'health' })");
    }

    @Test
    public void testDeleteExistingReferenceFromOutgoingSide() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (j:Person:DomainObject { name :'jim' })-[r:WRITES_POLICY]->(h:Policy:DomainObject { name: 'health' }) RETURN id(j) AS jid, id(r) AS rid, id(h) AS hid");
        Map resultSet = executionResult.next();
        executionResult.close();
        Long jid = (Long)resultSet.get("jid");
        Long hid = (Long)resultSet.get("hid");
        Person person = (Person)this.session.load(Person.class, (Serializable)jid);
        Policy policy = (Policy)this.session.load(Policy.class, (Serializable)hid);
        policy.setId(hid);
        policy.getWriters().add(person);
        person.getWritten().add(policy);
        person.getWritten().clear();
        this.session.save((Object)person);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (:Person:DomainObject { name :'jim' }) CREATE (:Policy:DomainObject { name: 'health' })");
    }

    @Test
    public void testDeleteExistingReferenceFromIncomingSide() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (j:Person:DomainObject { name :'jim' })-[r:WRITES_POLICY]->(h:Policy:DomainObject { name: 'health' }) RETURN id(j) AS jid, id(r) AS rid, id(h) AS hid");
        Map resultSet = executionResult.next();
        executionResult.close();
        Long jid = (Long)resultSet.get("jid");
        Long hid = (Long)resultSet.get("hid");
        Person person = (Person)this.session.load(Person.class, (Serializable)jid);
        Policy policy = (Policy)this.session.load(Policy.class, (Serializable)hid);
        policy.getWriters().add(person);
        person.getWritten().add(policy);
        policy.getWriters().clear();
        person.getWritten().clear();
        this.session.save((Object)policy);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (:Person:DomainObject { name :'jim' }) CREATE (:Policy:DomainObject { name: 'health' })");
    }

    @Test
    public void testAppendReferenceFromOutgoingSide() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (j:Person:DomainObject { name :'jim' })CREATE (h:Policy:DomainObject { name: 'health' }) CREATE (i:Policy:DomainObject { name: 'immigration' }) CREATE (j)-[r:WRITES_POLICY]->(h) RETURN id(j) AS jid, id(r) AS rid, id(h) AS hid, id(i) AS iid");
        Map resultSet = executionResult.next();
        executionResult.close();
        Long jid = (Long)resultSet.get("jid");
        Long hid = (Long)resultSet.get("hid");
        Long iid = (Long)resultSet.get("iid");
        Person jim = (Person)this.session.load(Person.class, (Serializable)jid);
        Policy health = (Policy)this.session.load(Policy.class, (Serializable)hid);
        Policy immigration = (Policy)this.session.load(Policy.class, (Serializable)iid);
        jim.getWritten().add(health);
        jim.getWritten().add(immigration);
        this.session.save((Object)jim);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (j:Person:DomainObject { name :'jim' }) CREATE (h:Policy:DomainObject { name: 'health' }) CREATE (i:Policy:DomainObject { name: 'immigration' }) CREATE (j)-[:WRITES_POLICY]->(h) CREATE (j)-[:WRITES_POLICY]->(i) ");
    }

    @Test
    public void testAppendReferenceFromIncomingSide() {
        Result executionResult = EntityGraphMapperTest.getGraphDatabaseService().execute("CREATE (j:Person:DomainObject { name :'jim' })CREATE (h:Policy:DomainObject { name: 'health' }) CREATE (i:Policy:DomainObject { name: 'immigration' }) CREATE (j)-[r:WRITES_POLICY]->(h) RETURN id(j) AS jid, id(r) AS rid, id(h) AS hid, id(i) AS iid");
        Map resultSet = executionResult.next();
        executionResult.close();
        Long jid = (Long)resultSet.get("jid");
        Long hid = (Long)resultSet.get("hid");
        Long iid = (Long)resultSet.get("iid");
        Person jim = (Person)this.session.load(Person.class, (Serializable)jid);
        Policy health = (Policy)this.session.load(Policy.class, (Serializable)hid);
        Policy immigration = (Policy)this.session.load(Policy.class, (Serializable)iid);
        jim.getWritten().add(health);
        immigration.getWriters().add(jim);
        this.session.save((Object)immigration, 2);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)"CREATE (j:Person:DomainObject { name :'jim' }) CREATE (h:Policy:DomainObject { name: 'health' }) CREATE (i:Policy:DomainObject { name: 'immigration' }) CREATE (j)-[:WRITES_POLICY]->(h) CREATE (j)-[:WRITES_POLICY]->(i) ");
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowMeaningfulErrorMessageWhenLoadingUnscannedEntity() throws Exception {
        this.session.load(Post.class, (Serializable)Long.valueOf(1L));
    }

    @Test
    public void shouldNotThrowNpeOnUnknownEntityFieldType() throws Exception {
        EntityWithUnmanagedFieldType entity = new EntityWithUnmanagedFieldType();
        ZonedDateTime now = ZonedDateTime.now();
        entity.setDate(now);
        this.session.save((Object)entity);
        this.session.clear();
        EntityWithUnmanagedFieldType loaded = (EntityWithUnmanagedFieldType)this.session.load(EntityWithUnmanagedFieldType.class, (Serializable)entity.getId());
        Assertions.assertThat((Object)loaded).isNotNull();
    }

    private void executeStatementsAndAssertSameGraph(Statements cypher, String sameGraphCypher) {
        ((ListAssert)Assertions.assertThat((List)cypher.getStatements()).as("The resultant cypher statements shouldn't be null", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)cypher.getStatements().isEmpty()).as("The resultant cypher statements shouldn't be empty", new Object[0])).isFalse();
        for (Statement query : cypher.getStatements()) {
            EntityGraphMapperTest.getGraphDatabaseService().execute(query.getStatement(), query.getParameters());
        }
        GraphTestUtils.assertSameGraph((GraphDatabaseService)EntityGraphMapperTest.getGraphDatabaseService(), (String)sameGraphCypher);
    }

    private void expect(String expected, Statements cypher) {
        Assertions.assertThat((String)((Statement)cypher.getStatements().get(0)).getStatement()).isEqualTo((Object)expected);
    }

    private String var(Long nodeId) {
        return "$" + nodeId;
    }
}

