/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.IOException;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.ogm.domain.cineasts.minimum.Actor;
import org.neo4j.ogm.domain.cineasts.minimum.Movie;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class RelationshipEntityPartialMappingTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetup() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.cineasts.minimum"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void testCreateActorRoleAndMovie() {
        Actor keanu = new Actor("Keanu Reeves");
        Movie matrix = new Movie("The Matrix");
        keanu.addRole("Neo", matrix);
        this.session.save((Object)keanu);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipEntityPartialMappingTest.getGraphDatabaseService(), (String)"create (a:Actor {name:'Keanu Reeves'}) create (m:Movie {name:'The Matrix'}) create (a)-[:ACTS_IN {played:'Neo'}]->(m)");
    }
}

