/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.model;

import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Result;
import org.neo4j.ogm.domain.election.Candidate;
import org.neo4j.ogm.domain.election.Voter;
import org.neo4j.ogm.domain.policy.Person;
import org.neo4j.ogm.domain.policy.Policy;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class RelationshipMappingTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetup() throws IOException {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.policy", "org.neo4j.ogm.domain.election"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void testThatABiDirectionalMappingIsEstablishedWhenAMutualRelationshipWithNoAnnotationsIsSaved() {
        Person jim = new Person("Jim");
        Policy policy = new Policy("Health");
        policy.getInfluencers().add(jim);
        jim.getInfluenced().add(policy);
        this.session.save((Object)policy);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n:Policy:DomainObject {name:'Health'})-[:INFLUENCERS]->(m:Person:DomainObject {name:'Jim'})-[:INFLUENCED]->(n)");
    }

    @Test
    public void testThatAnAnnotatedRelationshipOnTwoObjectsThatIsSavedFromTheOutgoingCreatesTheCorrectRelationshipInTheGraph() {
        Person jim = new Person("Jim");
        Policy policy = new Policy("Health");
        jim.getWritten().add(policy);
        this.session.save((Object)jim);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n:Policy:DomainObject {name:'Health'})<-[:WRITES_POLICY]-(m:Person:DomainObject {name:'Jim'})");
    }

    @Test
    public void testThatAnAnnotatedRelationshipSavedFromTheIncomingSideCreatesTheCorrectRelationshipInTheGraph() {
        Person jim = new Person("Jim");
        Policy policy = new Policy("Health");
        policy.getWriters().add(jim);
        this.session.save((Object)policy);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n:Policy:DomainObject {name:'Health'})<-[:WRITES_POLICY]-(m:Person:DomainObject {name:'Jim'})");
    }

    @Test
    public void testPersistAnnotatedSingleRelationshipMappingBothDomainObjectsParticipating() {
        Person jim = new Person("Jim");
        Policy policy = new Policy("Health");
        policy.getWriters().add(jim);
        jim.getWritten().add(policy);
        this.session.save((Object)policy);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n:Policy:DomainObject {name:'Health'})<-[:WRITES_POLICY]-(m:Person:DomainObject {name:'Jim'})");
    }

    @Test
    public void testAnnotatedRelationshipTypeWhenMethodsAreJsonIgnored() {
        Person jim = new Person("Jim");
        Policy policy = new Policy("Health");
        policy.setAuthorized(jim);
        jim.setAuthorized(policy);
        this.session.save((Object)jim);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (n:Policy:DomainObject {name:'Health'})<-[:AUTHORIZED_POLICY]-(m:Person:DomainObject {name:'Jim'})");
    }

    @Test
    public void shouldAllowVoterToChangeHerMind() {
        Result executionResult = RelationshipMappingTest.getGraphDatabaseService().execute("CREATE (a:Voter:Candidate {name:'A'}), (b:Voter:Candidate {name:'B'}), (v:Voter {name:'V'})-[:CANDIDATE_VOTED_FOR]->(b) RETURN id(a) AS a_id, id(b) AS b_id, id(v) AS v_id");
        Map results = executionResult.next();
        Long aid = (Long)results.get("a_id");
        Long bid = (Long)results.get("b_id");
        Long vid = (Long)results.get("v_id");
        Candidate a = (Candidate)this.session.load(Candidate.class, (Serializable)aid);
        Candidate b = (Candidate)this.session.load(Candidate.class, (Serializable)bid);
        Voter v = (Voter)this.session.load(Voter.class, (Serializable)vid);
        v.candidateVotedFor = a;
        this.session.save((Object)v);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)RelationshipMappingTest.getGraphDatabaseService(), (String)"CREATE (a:Voter:Candidate {name:'A'}) CREATE (b:Voter:Candidate {name:'B'}) CREATE (v:Voter {name:'V'})-[:CANDIDATE_VOTED_FOR]->(a)");
    }
}

