/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.postload;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.generic_hierarchy.AnotherEntity;
import org.neo4j.ogm.domain.generic_hierarchy.ChildA;
import org.neo4j.ogm.domain.generic_hierarchy.ChildB;
import org.neo4j.ogm.domain.generic_hierarchy.ChildC;
import org.neo4j.ogm.domain.postload.User;
import org.neo4j.ogm.domain.postload.UserWithBetterPostLoadMethod;
import org.neo4j.ogm.domain.postload.UserWithBrokenMethodDeclaration;
import org.neo4j.ogm.exception.core.MetadataException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class PostLoadTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.postload", "org.neo4j.ogm.domain.generic_hierarchy"});
    }

    @Before
    public void setUp() throws Exception {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
        User.resetPostLoadCount();
    }

    @Test
    public void shouldCallPostLoadMethod() throws Exception {
        User user = new User();
        this.session.save((Object)user);
        this.session.clear();
        User loaded = (User)this.session.load(User.class, (Serializable)user.getId());
        Assertions.assertThat((Object)loaded).isNotNull();
        Assertions.assertThat((int)User.getPostLoadCount()).isEqualTo(1);
    }

    @Test
    public void shouldCallPostLoadMethodWhenEntityIsInSession() throws Exception {
        User user = new User();
        this.session.save((Object)user);
        this.session.load(User.class, (Serializable)user.getId());
        this.session.load(User.class, (Serializable)user.getId());
        Assertions.assertThat((int)User.getPostLoadCount()).isEqualTo(2);
    }

    @Test
    public void shouldCallPostLoadForEachEntityOnce() throws Exception {
        User commonFriend = new User();
        User u1 = new User();
        User u2 = new User();
        commonFriend.addFriend(u1);
        commonFriend.addFriend(u2);
        this.session.save((Object)commonFriend);
        this.session.clear();
        this.session.query("MATCH (u:User)-[rel]-(friend:User) RETURN u,rel,friend", Collections.emptyMap());
        Assertions.assertThat((int)User.getPostLoadCount()).isEqualTo(3);
    }

    @Test
    public void shouldCallNonPublicFinalPostLoad() throws Exception {
        UserWithBetterPostLoadMethod user = new UserWithBetterPostLoadMethod();
        this.session.save((Object)user);
        this.session.clear();
        UserWithBetterPostLoadMethod loaded = (UserWithBetterPostLoadMethod)this.session.load(UserWithBetterPostLoadMethod.class, (Serializable)user.getId());
        Assertions.assertThat((Object)loaded).isNotNull();
        Assertions.assertThat((String)loaded.getRandomName()).isNotEqualTo((Object)user.getRandomName());
    }

    @Test
    public void shouldPreventAmbiguousPostLoadScenario() {
        UserWithBrokenMethodDeclaration user = new UserWithBrokenMethodDeclaration();
        this.session.save((Object)user);
        Assertions.assertThatExceptionOfType(MetadataException.class).isThrownBy(() -> this.session.loadAll(UserWithBrokenMethodDeclaration.class)).withMessage("Cannot have more than one post load method annotated with @PostLoad for class '%s'", new Object[]{UserWithBrokenMethodDeclaration.class.getName()});
    }

    @Test
    public void shouldRecognizeOverwrittenPostLoadFromSuperClass() {
        ChildA parent = new ChildA();
        parent.add(new ChildB());
        parent.add(new ChildB());
        parent.add(new ChildC());
        this.session.save((Object)parent);
        this.session.clear();
        Set<AnotherEntity> children = ((ChildA)this.session.load(ChildA.class, (Serializable)((Object)parent.getUuid()))).getChildren();
        ((IterableAssert)Assertions.assertThat(children).isNotEmpty()).filteredOn(ChildB.class::isInstance).allSatisfy(child -> {
            AbstractIntegerAssert cfr_ignored_0 = (AbstractIntegerAssert)Assertions.assertThat((Integer)((ChildB)child).getValue()).isNotNull();
        });
    }
}

