/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.relationships;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.forum.Member;
import org.neo4j.ogm.domain.forum.activity.Comment;
import org.neo4j.ogm.domain.forum.activity.Post;
import org.neo4j.ogm.domain.hierarchy.relations.BaseEntity;
import org.neo4j.ogm.domain.hierarchy.relations.Type1;
import org.neo4j.ogm.domain.hierarchy.relations.Type2;
import org.neo4j.ogm.domain.hierarchy.relations.Type3;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class HierarchyRelsTest
extends MultiDriverTestClass {
    private Session session;

    @Before
    public void init() throws IOException {
        this.session = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.hierarchy.relations", "org.neo4j.ogm.domain.forum"}).openSession();
        this.session.purgeDatabase();
    }

    @After
    public void cleanup() {
        this.session.purgeDatabase();
        this.session.clear();
    }

    @Test
    public void saveMultipleRelationshipsToBase() {
        Type1 node1 = new Type1();
        node1.name = "type1";
        Type2 node2 = new Type2();
        node2.name = "type2";
        node1.addIncoming(node2);
        node2.addIncoming(node1);
        Transaction transaction = this.session.beginTransaction();
        this.session.save((Object)node1);
        transaction.commit();
        transaction.close();
        this.session.clear();
        transaction = this.session.beginTransaction();
        BaseEntity entity = (BaseEntity)this.session.load(BaseEntity.class, (Serializable)node1.getGraphId());
        transaction.close();
        Assertions.assertThat(entity.getIncoming()).hasSize(1);
        Assertions.assertThat(entity.getOutgoing()).hasSize(1);
        Assertions.assertThat((Long)node2.getGraphId()).isEqualTo((Object)entity.getIncoming().get(0).getGraphId());
        Assertions.assertThat((Long)node2.getGraphId()).isEqualTo((Object)entity.getOutgoing().get(0).getGraphId());
    }

    @Test
    public void saveMultipleRelationsOfType() {
        Type3 node1 = new Type3();
        Type3 node2 = new Type3();
        node1.getType3In().add(node2);
        node1.getType3Out().add(node2);
        node2.getType3In().add(node1);
        node2.getType3Out().add(node1);
        this.session.save((Object)node1);
        this.session.clear();
        Type3 type3_1 = (Type3)this.session.load(Type3.class, (Serializable)node1.getGraphId());
        Assertions.assertThat(type3_1.getType3In()).hasSize(1);
        Assertions.assertThat(type3_1.getType3Out()).hasSize(1);
        this.session.clear();
        Type3 type3_2 = (Type3)this.session.load(Type3.class, (Serializable)node2.getGraphId());
        Assertions.assertThat(type3_2.getType3In()).hasSize(1);
        Assertions.assertThat(type3_2.getType3Out()).hasSize(1);
    }

    @Test
    public void shouldLoadRelationByAbstractParent() {
        Post post = new Post();
        post.setPost("sample post");
        Comment comment = new Comment();
        Date now = new Date();
        comment.setDate(now);
        Member member = new Member();
        member.setUserName("sample member");
        member.setActivityList(Arrays.asList(post, comment));
        this.session.save((Object)member);
        this.session.clear();
        Member reloaded = (Member)this.session.load(Member.class, (Serializable)member.getId());
        Assertions.assertThat((Object)reloaded).isNotNull();
        Assertions.assertThat((String)reloaded.getUserName()).isEqualTo((Object)"sample member");
        Assertions.assertThat(reloaded.getActivityList()).hasSize(2);
        Post p = (Post)StreamSupport.stream(reloaded.getActivityList().spliterator(), false).filter(elt -> elt.getClass().equals(Post.class)).findFirst().get();
        Assertions.assertThat((String)p.getPost()).isEqualTo((Object)"sample post");
        Comment c = (Comment)StreamSupport.stream(reloaded.getActivityList().spliterator(), false).filter(elt -> elt.getClass().equals(Comment.class)).findFirst().get();
        Assertions.assertThat((Date)c.getDate()).isEqualTo((Object)now);
    }
}

