/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.relationships;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.entityMapping.Movie;
import org.neo4j.ogm.domain.entityMapping.Person;
import org.neo4j.ogm.domain.entityMapping.Rating;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class MultipleRelationshipsTest
extends MultiDriverTestClass {
    private Session session;

    @Before
    public void init() throws IOException {
        this.session = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.entityMapping"}).openSession();
        this.session.purgeDatabase();
    }

    @After
    public void cleanup() {
        this.session.purgeDatabase();
        this.session.clear();
    }

    @Test
    public void shouldMapFromGraphToEntitiesCorrectly() {
        this.session.query("create (_5:`PersonX` {`name`:\"Jim\"})\ncreate (_6:`PersonX` {`name`:\"Mary\"})\ncreate (_7:`PersonX` {`name`:\"Bill\"})\ncreate (_8:`Movie` {`name`:\"Die Hard\"})\ncreate (_9:`Movie` {`name`:\"The Matrix\"})\ncreate (_5)-[:`FOLLOWS`]->(_6)\ncreate (_5)-[:`LIKES`]->(_6)\ncreate (_5)-[:`RATED` {`value`:4}]->(_9)\ncreate (_5)-[:`RATED` {`value`:5}]->(_8)\ncreate (_6)-[:`FOLLOWS`]->(_5)\ncreate (_6)-[:`FOLLOWS`]->(_7)\ncreate (_6)-[:`LIKES`]->(_5)\ncreate (_6)-[:`RATED` {`value`:5}]->(_8)\ncreate (_7)-[:`FOLLOWS`]->(_5)\ncreate (_7)-[:`LIKES`]->(_6)\ncreate (_7)-[:`RATED` {`value`:4}]->(_9)\ncreate (_7)-[:`RATED` {`value`:5}]->(_9)\n;\n", Collections.EMPTY_MAP);
        Person jim = (Person)this.session.loadAll(Person.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Jim")).iterator().next();
        Assertions.assertThat(jim.movieRatings).hasSize(2);
        Assertions.assertThat(jim.peopleILike).hasSize(1);
        Assertions.assertThat(jim.peopleWhoLikeMe).hasSize(1);
        Assertions.assertThat(jim.peopleIFollow).hasSize(1);
        Assertions.assertThat(jim.peopleWhoFollowMe).hasSize(2);
        Assertions.assertThat((String)jim.peopleILike.get((int)0).name).isEqualTo((Object)"Mary");
        Person bill = (Person)this.session.loadAll(Person.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Bill")).iterator().next();
        Assertions.assertThat(bill.movieRatings).hasSize(2);
        Assertions.assertThat(bill.peopleILike).hasSize(1);
        Assertions.assertThat(bill.peopleWhoLikeMe).isEmpty();
        Assertions.assertThat(bill.peopleIFollow).hasSize(1);
        Assertions.assertThat(bill.peopleWhoFollowMe).hasSize(1);
        Person mary = (Person)this.session.loadAll(Person.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Mary")).iterator().next();
        Movie dieHard = (Movie)this.session.loadAll(Movie.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"Die Hard")).iterator().next();
        Movie matrix = (Movie)this.session.loadAll(Movie.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"The Matrix")).iterator().next();
        Assertions.assertThat(mary.movieRatings).hasSize(1);
        Assertions.assertThat(mary.peopleILike).hasSize(1);
        Assertions.assertThat(mary.peopleWhoLikeMe).hasSize(2);
        Assertions.assertThat(mary.peopleIFollow).hasSize(2);
        Assertions.assertThat(mary.peopleWhoFollowMe).hasSize(1);
        Assertions.assertThat(matrix.ratings).hasSize(3);
        Assertions.assertThat(dieHard.ratings).hasSize(2);
    }

    @Test
    public void shouldCreateGraphProperly() {
        Person jim = new Person();
        Person mary = new Person();
        Person bill = new Person();
        jim.name = "Jim";
        mary.name = "Mary";
        bill.name = "Bill";
        bill.peopleIFollow.add(jim);
        bill.peopleILike.add(mary);
        bill.peopleWhoFollowMe.add(mary);
        mary.peopleIFollow.add(bill);
        mary.peopleIFollow.add(jim);
        mary.peopleILike.add(jim);
        mary.peopleWhoLikeMe.add(bill);
        mary.peopleWhoFollowMe.add(jim);
        mary.peopleWhoLikeMe.add(jim);
        jim.peopleIFollow.add(mary);
        jim.peopleILike.add(mary);
        jim.peopleWhoFollowMe.add(bill);
        jim.peopleWhoFollowMe.add(mary);
        jim.peopleWhoLikeMe.add(mary);
        this.session.save((Object)jim);
        Movie matrix = new Movie();
        matrix.name = "The Matrix";
        Movie dieHard = new Movie();
        dieHard.name = "Die Hard";
        Rating ratingOne = Rating.create(bill, matrix, 4);
        Rating ratingTwo = Rating.create(bill, matrix, 5);
        Rating ratingThree = Rating.create(jim, matrix, 3);
        Rating ratingFour = Rating.create(jim, dieHard, 5);
        Rating ratingFive = Rating.create(mary, dieHard, 5);
        bill.movieRatings.add(ratingOne);
        matrix.ratings.add(ratingOne);
        bill.movieRatings.add(ratingTwo);
        matrix.ratings.add(ratingTwo);
        jim.movieRatings.add(ratingThree);
        matrix.ratings.add(ratingThree);
        jim.movieRatings.add(ratingFour);
        dieHard.ratings.add(ratingFour);
        mary.movieRatings.add(ratingFive);
        dieHard.ratings.add(ratingFive);
        this.session.save((Object)bill);
        this.session.save((Object)jim);
        this.session.save((Object)mary);
        Long idDieHard = dieHard.id;
        Long idMatrix = matrix.id;
        Long idJim = jim.id;
        Long idBill = bill.id;
        Long idMary = mary.id;
        this.session.clear();
        jim = (Person)this.session.load(Person.class, (Serializable)idJim);
        Assertions.assertThat(jim.movieRatings).hasSize(2);
        Assertions.assertThat(jim.peopleILike).hasSize(1);
        Assertions.assertThat(jim.peopleWhoLikeMe).hasSize(1);
        Assertions.assertThat(jim.peopleIFollow).hasSize(1);
        Assertions.assertThat(jim.peopleWhoFollowMe).hasSize(2);
        bill = (Person)this.session.load(Person.class, (Serializable)idBill);
        Assertions.assertThat(bill.movieRatings).hasSize(2);
        Assertions.assertThat(bill.peopleILike).hasSize(1);
        Assertions.assertThat(bill.peopleWhoLikeMe).isEmpty();
        Assertions.assertThat(bill.peopleIFollow).hasSize(1);
        Assertions.assertThat(bill.peopleWhoFollowMe).hasSize(1);
        mary = (Person)this.session.load(Person.class, (Serializable)idMary);
        Assertions.assertThat(mary.movieRatings).hasSize(1);
        Assertions.assertThat(mary.peopleILike).hasSize(1);
        Assertions.assertThat(mary.peopleWhoLikeMe).hasSize(2);
        Assertions.assertThat(mary.peopleIFollow).hasSize(2);
        Assertions.assertThat(mary.peopleWhoFollowMe).hasSize(1);
        dieHard = (Movie)this.session.load(Movie.class, (Serializable)idDieHard);
        matrix = (Movie)this.session.load(Movie.class, (Serializable)idMatrix);
        Assertions.assertThat(matrix.ratings).hasSize(3);
        Assertions.assertThat(dieHard.ratings).hasSize(2);
        Person bob = new Person();
        bob.name = "Bob";
        Rating ratingSix = Rating.create(bob, matrix, 4);
        Rating ratingSeven = Rating.create(bob, matrix, 5);
        bob.movieRatings.add(ratingSix);
        bob.movieRatings.add(ratingSeven);
        this.session.save((Object)bob);
        this.session.clear();
        bob = (Person)this.session.load(Person.class, (Serializable)bob.id);
        Assertions.assertThat(bob.movieRatings).hasSize(2);
    }
}

