/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.relationships;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class RelationshipEntityTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;
    private U u;
    private M m;
    private R r1;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.persistence.relationships"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.u = new U("Luanne");
        this.m = new M("Taken");
        this.r1 = new R(this.u, this.m, "great!", 4);
        this.u.rset.add(this.r1);
        this.m.rset.add(this.r1);
        this.session.purgeDatabase();
    }

    @Test
    public void shouldAddR() {
        this.session.save((Object)this.u);
        R r2 = new R(this.u, this.m, "even better next time!", 5);
        this.u.rset.add(r2);
        this.m.rset.add(r2);
        this.session.save((Object)this.u);
        this.session.clear();
        this.m = (M)this.session.load(M.class, (Serializable)this.m.id);
        Assertions.assertThat(this.m.rset).hasSize(2);
    }

    @Test
    public void shouldUpdateExistingR() {
        this.session.save((Object)this.u);
        this.r1.stars = 3;
        this.session.save((Object)this.u);
        this.session.clear();
        this.m = (M)this.session.load(M.class, (Serializable)this.m.id);
        Assertions.assertThat(this.m.rset).hasSize(1);
        Assertions.assertThat((int)this.m.rset.iterator().next().stars).isEqualTo(3);
    }

    @Test
    public void shouldDeleteR() {
        this.session.save((Object)this.u);
        this.u.rset.clear();
        this.m.rset.clear();
        this.session.save((Object)this.u);
        this.session.clear();
        this.m = (M)this.session.load(M.class, (Serializable)this.m.id);
        this.u = (U)this.session.load(U.class, (Serializable)this.u.id);
        Assertions.assertThat((Object)this.m).isNotNull();
        Assertions.assertThat(this.m.rset).isEmpty();
        Assertions.assertThat((Object)this.u).isNotNull();
        Assertions.assertThat(this.u.rset).isEmpty();
    }

    @Test
    public void shouldReplaceExistingR() {
        this.session.save((Object)this.u);
        R r3 = new R(this.u, this.m, "Only Gravity sucks more than this film", 0);
        this.u.rset.clear();
        this.u.rset.add(r3);
        this.m.rset.clear();
        this.m.rset.add(r3);
        this.session.save((Object)this.u);
        this.session.clear();
        this.m = (M)this.session.load(M.class, (Serializable)this.m.id);
        Assertions.assertThat(this.m.rset).hasSize(1);
        Assertions.assertThat((int)this.m.rset.iterator().next().stars).isEqualTo(0);
    }

    @Test
    public void shouldDirectlyAddR() {
        this.session.save((Object)this.r1);
        this.session.clear();
        this.r1 = (R)this.session.load(R.class, (Serializable)this.r1.id);
        Assertions.assertThat(this.r1.m.rset).hasSize(1);
        Assertions.assertThat(this.r1.u.rset).hasSize(1);
    }

    @Test
    public void shouldDirectlyUpdateR() {
        this.session.save((Object)this.r1);
        this.r1 = (R)this.session.load(R.class, (Serializable)this.r1.id);
        this.r1.stars = 5;
        this.session.save((Object)this.r1);
        this.session.clear();
        Assertions.assertThat(this.r1.m.rset).hasSize(1);
        Assertions.assertThat(this.r1.u.rset).hasSize(1);
        Assertions.assertThat((Integer)this.r1.stars).isEqualTo((Object)5);
        this.u = (U)this.session.load(U.class, (Serializable)this.u.id);
        Assertions.assertThat(this.u.rset).hasSize(1);
        this.m = (M)this.session.load(M.class, (Serializable)this.m.id);
        Assertions.assertThat(this.m.rset).hasSize(1);
        Assertions.assertThat((Integer)this.m.rset.iterator().next().stars).isEqualTo((Object)5);
    }

    @Test
    public void shouldDirectlyDeleteR() {
        this.session.save((Object)this.r1);
        Assertions.assertThat((Object)this.session.getTransaction()).isNull();
        this.r1 = (R)this.session.load(R.class, (Serializable)this.r1.id);
        this.u = (U)this.session.load(U.class, (Serializable)this.u.id);
        this.m = (M)this.session.load(M.class, (Serializable)this.m.id);
        Assertions.assertThat((Object)this.m).isNotNull();
        Assertions.assertThat((Object)this.u).isNotNull();
        Assertions.assertThat((Object)this.r1).isNotNull();
        Assertions.assertThat((Object)this.session.getTransaction()).isNull();
        this.u.rset.clear();
        this.m.rset.clear();
        this.session.delete((Object)this.r1);
        Assertions.assertThat((Object)this.session.getTransaction()).isNull();
        this.session.clear();
        M qryM = (M)this.session.queryForObject(M.class, "MATCH (n:M) return n", Utils.map((Object[])new Object[0]));
        M findM = (M)this.session.queryForObject(M.class, "MATCH (n:M) WHERE ID(n) = { id } RETURN n", Utils.map((Object[])new Object[]{"id", this.m.id}));
        M findM2 = (M)this.session.queryForObject(M.class, "MATCH (n:M) WHERE ID(n) = { id } WITH n MATCH p=(n)-[*0..1]-(m) RETURN nodes(p)", Utils.map((Object[])new Object[]{"id", this.m.id}));
        Assertions.assertThat((Object)qryM).isNotNull();
        Assertions.assertThat((Object)findM).isNotNull();
        Assertions.assertThat((Object)findM2).isNotNull();
        this.session.clear();
        Assertions.assertThat((Object)this.session.load(R.class, (Serializable)this.r1.id)).isNull();
        this.m = (M)this.session.load(M.class, (Serializable)this.m.id);
        Assertions.assertThat((Object)this.m).isNotNull();
        Assertions.assertThat(this.m.rset).isEmpty();
        this.u = (U)this.session.load(U.class, (Serializable)this.u.id);
        Assertions.assertThat((Object)this.u).isNotNull();
        Assertions.assertThat(this.u.rset).isEmpty();
    }

    @Test
    public void shouldReplaceOneEndOfR() {
        M m2;
        this.session.save((Object)this.u);
        this.r1.m = m2 = new M("Lost");
        this.session.save((Object)this.r1);
        Assertions.assertThat((Object)this.u.rset.iterator().next().m).isEqualTo((Object)m2);
        this.session.clear();
        this.u = (U)this.session.load(U.class, (Serializable)this.u.id);
        Assertions.assertThat(this.u.rset).hasSize(1);
        Assertions.assertThat((String)this.u.rset.iterator().next().m.title).isEqualTo((Object)m2.title);
    }

    @Test(expected=MappingException.class)
    public void shouldThrowExceptionWhenTheStartNodeIsNull() {
        R invalidR = new R(null, this.m, "exception", 0);
        this.m.rset.add(invalidR);
        this.session.save((Object)this.m);
    }

    @Test(expected=MappingException.class)
    public void shouldThrowExceptionWhenTheEndNodeIsNull() {
        R invalidR = new R(this.u, null, "exception", 0);
        this.u.rset.add(invalidR);
        this.session.save((Object)this.u);
    }

    @Test(expected=RuntimeException.class)
    public void shouldThrowExceptionWhenRIsSavedWithMissingEndNodes() {
        R invalidR = new R(null, null, "exception", 0);
        this.session.save((Object)invalidR);
    }

    @Test
    public void shouldReloadCompleteRelationshipWhenStartAndEndNodesDontDeclareTheRelationshipExplicitly() {
        Vertex from = new Vertex();
        Vertex to = new Vertex();
        from.name = "from";
        to.name = "to";
        Arc link = new Arc();
        link.from = from;
        link.to = to;
        link.created = System.currentTimeMillis();
        this.session.save((Object)link);
        this.session.clear();
        Assertions.assertThat((Long)link.id).isNotNull();
        Arc reloaded = (Arc)this.session.queryForObject(Arc.class, "MATCH (f:Vertex)-[a:Arc]->(t:Vertex) return f, a, t", Utils.map((Object[])new Object[0]));
        Assertions.assertThat((Object)reloaded).isNotNull();
        Assertions.assertThat((Object)reloaded.from).isNotNull();
        Assertions.assertThat((Object)reloaded.to).isNotNull();
        Assertions.assertThat((Long)reloaded.id).isEqualTo((Object)link.id);
        Assertions.assertThat((Long)reloaded.from.id).isEqualTo((Object)from.id);
        Assertions.assertThat((Long)reloaded.to.id).isEqualTo((Object)to.id);
    }

    @RelationshipEntity(type="Arc")
    public static class Arc {
        Long id;
        Long created;
        @StartNode
        Vertex from;
        @EndNode
        Vertex to;
    }

    @NodeEntity(label="Vertex")
    public static class Vertex {
        Long id;
        String name;
    }

    @NodeEntity(label="M")
    public static class M {
        Long id;
        String title;
        @Relationship(type="EDGE", direction="INCOMING")
        Set<R> rset = new HashSet<R>();

        public M() {
        }

        public M(String title) {
            this.title = title;
        }
    }

    @RelationshipEntity(type="EDGE")
    public static class R {
        Long id;
        String comments;
        Integer stars;
        @StartNode
        U u;
        @EndNode
        M m;

        public R() {
        }

        public R(U u, M m, String comments, Integer stars) {
            this.u = u;
            this.m = m;
            this.comments = comments;
            this.stars = stars;
        }
    }

    @NodeEntity(label="U")
    public static class U {
        Long id;
        String name;
        @Relationship(type="EDGE", direction="OUTGOING")
        Set<R> rset = new HashSet<R>();

        public U() {
        }

        public U(String name) {
            this.name = name;
        }
    }
}

