/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.relationships.direct.aa;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class AATest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;
    private A a1;
    private A a2;
    private A a3;
    private A a4;
    private A loadedA1;
    private A loadedA2;
    private A loadedA3;
    private A loadedA4;

    @BeforeClass
    public static void oneTimeSetup() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.persistence.relationships.direct.aa"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
        this.setUpEntityModel();
    }

    @After
    public void cleanup() {
        this.session.purgeDatabase();
    }

    private void setUpEntityModel() {
        this.a1 = new A();
        this.a2 = new A();
        this.a3 = new A();
        this.a4 = new A();
        this.a1.a = this.a2;
        this.a2.a = this.a3;
        this.a3.a = this.a4;
    }

    @Test
    public void shouldFindStartAFromEndA() {
        this.session.save((Object)this.a1);
        this.session.save((Object)this.a2);
        this.session.save((Object)this.a3);
        this.session.save((Object)this.a4);
        this.loadedA1 = (A)this.session.load(A.class, (Serializable)this.a1.id);
        this.loadedA2 = (A)this.session.load(A.class, (Serializable)this.a2.id);
        this.loadedA3 = (A)this.session.load(A.class, (Serializable)this.a3.id);
        this.loadedA4 = (A)this.session.load(A.class, (Serializable)this.a4.id);
        Assertions.assertThat((Object)this.loadedA1.a).isEqualTo((Object)this.a2);
        Assertions.assertThat((Object)this.loadedA2.a).isEqualTo((Object)this.a3);
        Assertions.assertThat((Object)this.loadedA3.a).isEqualTo((Object)this.a4);
        Assertions.assertThat((Object)this.loadedA4.a).isNull();
    }

    @Test
    public void shouldFindEndAFromStartA() {
        this.session.save((Object)this.a1);
        this.session.save((Object)this.a2);
        this.session.save((Object)this.a3);
        this.session.save((Object)this.a4);
        this.loadedA1 = (A)this.session.load(A.class, (Serializable)this.a1.id);
        this.loadedA2 = (A)this.session.load(A.class, (Serializable)this.a2.id);
        this.loadedA3 = (A)this.session.load(A.class, (Serializable)this.a3.id);
        this.loadedA4 = (A)this.session.load(A.class, (Serializable)this.a4.id);
        Assertions.assertThat((Object)this.a1.a).isEqualTo((Object)this.loadedA2);
        Assertions.assertThat((Object)this.a2.a).isEqualTo((Object)this.loadedA3);
        Assertions.assertThat((Object)this.a3.a).isEqualTo((Object)this.loadedA4);
    }

    @Test
    public void shouldPreserveAAfterReflectRemovalOtherA() {
        this.session.save((Object)this.a1);
        this.session.save((Object)this.a2);
        this.session.save((Object)this.a3);
        this.session.save((Object)this.a4);
        this.a2.a = null;
        this.session.save((Object)this.a2);
        this.loadedA2 = (A)this.session.load(A.class, (Serializable)this.a2.id);
        Assertions.assertThat((Object)this.loadedA2.a).isNull();
        this.loadedA1 = (A)this.session.load(A.class, (Serializable)this.a1.id);
        Assertions.assertThat((Object)this.loadedA1.a).isEqualTo((Object)this.a2);
        this.loadedA3 = (A)this.session.load(A.class, (Serializable)this.a3.id);
        Assertions.assertThat((Object)this.loadedA3.a).isEqualTo((Object)this.a4);
        this.loadedA4 = (A)this.session.load(A.class, (Serializable)this.a4.id);
        Assertions.assertThat((Object)this.loadedA4.a).isNull();
    }

    public static abstract class E {
        public Long id;
        public String key = UUID.randomUUID().toString();

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.id + ":" + this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.key.equals(((E)o).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    @NodeEntity(label="A")
    public static class A
    extends E {
        @Relationship(type="EDGE", direction="INCOMING")
        A a;
    }
}

