/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.relationships.transitive.abb;

import java.io.IOException;
import java.io.Serializable;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class ABBTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;
    private A a;
    private B b1;
    private B b2;
    private R r1;
    private R r2;

    @BeforeClass
    public static void oneTimeSetup() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.persistence.relationships.transitive.abb"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.setUpEntityModel();
    }

    @After
    public void cleanup() {
        this.session.purgeDatabase();
    }

    private void setUpEntityModel() {
        this.a = new A();
        this.b1 = new B();
        this.b2 = new B();
        this.r1 = new R();
        this.r2 = new R();
        this.r1.a = this.a;
        this.r1.b = this.b1;
        this.r2.a = this.a;
        this.r2.b = this.b2;
        this.a.r = new R[]{this.r1, this.r2};
        this.b1.r = this.r1;
        this.b2.r = this.r2;
    }

    @Test
    public void shouldFindBFromA() {
        this.session.save((Object)this.b1);
        this.a = (A)this.session.load(A.class, (Serializable)this.a.id);
        Assertions.assertThat((int)this.a.r.length).isEqualTo(2);
        Assertions.assertThat((Object[])this.a.r).extracting(x -> x.b).containsExactlyInAnyOrder((Object[])new B[]{this.b1, this.b2});
    }

    @Test
    public void shouldFindAFromB() {
        this.session.save((Object)this.a);
        this.b1 = (B)this.session.load(B.class, (Serializable)this.b1.id);
        this.b2 = (B)this.session.load(B.class, (Serializable)this.b2.id);
        Assertions.assertThat((Object)this.b1.r.a).isEqualTo((Object)this.a);
        Assertions.assertThat((Object)this.b2.r.a).isEqualTo((Object)this.a);
    }

    @Test
    public void shouldReflectRemovalA() {
        this.session.save((Object)this.a);
        this.b1.r = null;
        this.a.r = new R[]{this.r2};
        this.session.save((Object)this.b1);
        this.a = (A)this.session.load(A.class, (Serializable)this.a.id);
        Assertions.assertThat((int)this.a.r.length).isEqualTo(1);
        Assertions.assertThat((Object[])new B[]{this.a.r[0].b}).isEqualTo((Object)new B[]{this.b2});
    }

    @Test
    public void shouldBeAbleToAddNewB() {
        this.session.save((Object)this.a);
        B b3 = new B();
        R r3 = new R();
        r3.a = this.a;
        r3.b = b3;
        b3.r = r3;
        this.a.r = new R[]{this.r1, this.r2, r3};
        this.session.save((Object)this.a);
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((Object[])new A[]{b3.r.a}).isEqualTo((Object)new A[]{this.a});
        Assertions.assertThat((Object[])new A[]{b3.r.a}).isEqualTo((Object)new A[]{this.a});
    }

    @Test
    public void shouldBeAbleToAddNewR() {
        this.session.save((Object)this.a);
        B b3 = new B();
        R r3 = new R();
        r3.a = this.a;
        r3.b = b3;
        b3.r = r3;
        this.a.r = new R[]{this.r1, this.r2, r3};
        this.session.save((Object)r3);
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((Object[])new A[]{b3.r.a}).isEqualTo((Object)new A[]{this.a});
        Assertions.assertThat((Object[])this.a.r).isEqualTo((Object)new R[]{this.r1, this.r2, r3});
        Assertions.assertThat((Object[])new B[]{this.a.r[0].b, this.a.r[1].b, this.a.r[2].b}).isEqualTo((Object)new B[]{this.b1, this.b2, b3});
    }

    @Test
    public void shouldBeAbleToUpdateRBySavingA() {
        A a1 = new A();
        B b3 = new B();
        R r3 = new R();
        r3.a = a1;
        r3.b = b3;
        r3.number = 1;
        a1.r = new R[]{r3};
        b3.r = r3;
        this.session.save((Object)a1);
        r3.number = 2;
        this.session.save((Object)a1);
        this.session.clear();
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((int)b3.r.number).isEqualTo(2);
    }

    @Test
    public void shouldBeAbleToUpdateRBySavingB() {
        A a1 = new A();
        B b3 = new B();
        R r3 = new R();
        r3.a = a1;
        r3.b = b3;
        r3.number = 1;
        a1.r = new R[]{r3};
        b3.r = r3;
        this.session.save((Object)a1);
        r3.number = 2;
        this.session.save((Object)b3);
        this.session.clear();
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((int)b3.r.number).isEqualTo(2);
    }

    @Test
    public void shouldBeAbleToUpdateRBySavingR() {
        A a1 = new A();
        B b3 = new B();
        R r3 = new R();
        r3.a = a1;
        r3.b = b3;
        r3.number = 1;
        a1.r = new R[]{r3};
        b3.r = r3;
        this.session.save((Object)a1);
        r3.number = 2;
        this.session.save((Object)r3);
        this.session.clear();
        b3 = (B)this.session.load(B.class, (Serializable)b3.id);
        Assertions.assertThat((int)b3.r.number).isEqualTo(2);
    }

    @RelationshipEntity(type="EDGE")
    public static class R {
        Long id;
        @StartNode
        A a;
        @EndNode
        B b;
        int number;

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.a.id + "->" + this.b.id;
        }
    }

    public static abstract class E {
        public Long id;
        public String key = UUID.randomUUID().toString();

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.id + ":" + this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.key.equals(((E)o).key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    @NodeEntity(label="B")
    public static class B
    extends E {
        @Relationship(type="EDGE", direction="INCOMING")
        R r;
    }

    @NodeEntity(label="A")
    public static class A
    extends E {
        @Relationship(type="EDGE", direction="OUTGOING")
        R[] r;
    }
}

