/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.capability;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.entityMapping.Movie;
import org.neo4j.ogm.domain.music.Album;
import org.neo4j.ogm.domain.music.Artist;
import org.neo4j.ogm.domain.music.Recording;
import org.neo4j.ogm.domain.music.ReleaseFormat;
import org.neo4j.ogm.domain.music.Studio;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class GraphIdCapabilityTest
extends MultiDriverTestClass {
    private Session session;
    private Long pleaseId;
    private Long beatlesId;
    private Long recordingId;
    private Artist theBeatles;
    private Album please;
    private Recording recording;

    @Before
    public void init() throws IOException {
        SessionFactory sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.music"});
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
        this.theBeatles = new Artist("The Beatles");
        this.please = new Album("Please Please Me");
        this.theBeatles.getAlbums().add(this.please);
        this.please.setArtist(this.theBeatles);
        this.session.save((Object)this.theBeatles);
        Studio studio = new Studio("EMI Studios, London");
        this.recording = new Recording(this.please, studio, 1963);
        this.please.setRecording(this.recording);
        this.session.save((Object)this.recording);
        this.pleaseId = this.please.getId();
        this.beatlesId = this.theBeatles.getId();
        this.recordingId = this.recording.getId();
    }

    @After
    public void clearDatabase() {
        this.session.purgeDatabase();
    }

    @Test
    public void idShouldBeResolvedForValidNodeEntity() {
        Assertions.assertThat((Long)this.session.resolveGraphIdFor((Object)this.please)).isEqualTo((Object)this.pleaseId);
        Assertions.assertThat((Long)this.session.resolveGraphIdFor((Object)this.theBeatles)).isEqualTo((Object)this.beatlesId);
    }

    @Test
    public void idShouldBeResolvedForValidRelationshipEntity() {
        Assertions.assertThat((Long)this.session.resolveGraphIdFor((Object)this.recording)).isEqualTo((Object)this.recordingId);
    }

    @Test
    public void idShouldReturnNullForEntitiesNotPersisted() {
        Album revolver = new Album("Revolver");
        Assertions.assertThat((Long)this.session.resolveGraphIdFor((Object)revolver)).isNull();
        Recording revolverRecording = new Recording(revolver, new Studio(), 1966);
        Assertions.assertThat((Long)this.session.resolveGraphIdFor((Object)revolverRecording)).isNull();
    }

    @Test
    public void idShouldReturnNullForNonEntities() {
        Movie movie = new Movie();
        Assertions.assertThat((Long)this.session.resolveGraphIdFor((Object)movie)).isNull();
        Long aLong = 5L;
        Assertions.assertThat((Long)this.session.resolveGraphIdFor((Object)aLong)).isNull();
    }

    @Test
    public void idShouldReturnNullForEntitiesWithNoIdentity() {
        Assertions.assertThat((Long)this.session.resolveGraphIdFor((Object)ReleaseFormat.VINYL)).isNull();
    }

    @Test
    public void idShouldReturnNullForNullsOrPrimitives() {
        Assertions.assertThat((Long)this.session.resolveGraphIdFor(null)).isNull();
        Assertions.assertThat((Long)this.session.resolveGraphIdFor((Object)true)).isNull();
        Assertions.assertThat((Long)this.session.resolveGraphIdFor((Object)1)).isNull();
    }
}

