/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.capability;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.ogm.domain.cineasts.annotated.Actor;
import org.neo4j.ogm.domain.cineasts.annotated.Movie;
import org.neo4j.ogm.domain.cineasts.annotated.Rating;
import org.neo4j.ogm.domain.cineasts.annotated.User;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.testutil.TestUtils;

public class QueryCapabilityTest
extends MultiDriverTestClass {
    private Session session;

    @Before
    public void init() throws IOException {
        this.session = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.cineasts.annotated"}).openSession();
        this.session.purgeDatabase();
        this.session.clear();
        this.importCineasts();
    }

    private void importCineasts() {
        this.session.query(TestUtils.readCQLFile((String)"org/neo4j/ogm/cql/cineasts.cql").toString(), Utils.map((Object[])new Object[0]));
    }

    @After
    public void clearDatabase() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldQueryForArbitraryDataUsingBespokeParameterisedCypherQuery() {
        this.session.save((Object)new Actor("Helen Mirren"));
        Actor alec = new Actor("Alec Baldwin");
        this.session.save((Object)alec);
        this.session.save((Object)new Actor("Matt Damon"));
        Result resultsIterable = this.session.query("MATCH (a:Actor) WHERE ID(a)={param} RETURN a.name as name", Collections.singletonMap("param", alec.getId()));
        ((IterableAssert)Assertions.assertThat((Iterable)resultsIterable).as("Results are empty", new Object[0])).isNotNull();
        Map row = (Map)resultsIterable.iterator().next();
        Assertions.assertThat(row.get("name")).isEqualTo((Object)"Alec Baldwin");
        Result results = this.session.query("MATCH (a:Actor) WHERE ID(a)={param} RETURN a.name as name", Collections.singletonMap("param", alec.getId()));
        ((IterableAssert)Assertions.assertThat((Iterable)results).as("Results are empty", new Object[0])).isNotNull();
        Assertions.assertThat(((Map)results.iterator().next()).get("name")).isEqualTo((Object)"Alec Baldwin");
    }

    @Test(expected=RuntimeException.class)
    public void readOnlyQueryMustBeReadOnly() {
        this.session.save((Object)new Actor("Jeff"));
        this.session.query("MATCH (a:Actor) SET a.age={age}", MapUtil.map((Object[])new Object[]{"age", 5}), true);
    }

    @Test
    public void modifyingQueryShouldReturnStatistics() {
        this.session.save((Object)new Actor("Jeff"));
        this.session.save((Object)new Actor("John"));
        this.session.save((Object)new Actor("Colin"));
        Result result = this.session.query("MATCH (a:Actor) SET a.age={age}", MapUtil.map((Object[])new Object[]{"age", 5}), false);
        Assertions.assertThat((Iterable)result).isNotNull();
        Assertions.assertThat((Object)result.queryStatistics()).isNotNull();
        Assertions.assertThat((int)result.queryStatistics().getPropertiesSet()).isEqualTo(3);
        result = this.session.query("MATCH (a:Actor) SET a.age={age}", MapUtil.map((Object[])new Object[]{"age", 5}));
        Assertions.assertThat((Iterable)result).isNotNull();
        Assertions.assertThat((Object)result.queryStatistics()).isNotNull();
        Assertions.assertThat((int)result.queryStatistics().getPropertiesSet()).isEqualTo(3);
    }

    @Test
    public void modifyingQueryShouldReturnResultsWithStatistics() {
        this.session.save((Object)new Actor("Jeff"));
        this.session.save((Object)new Actor("John"));
        this.session.save((Object)new Actor("Colin"));
        Result result = this.session.query("MATCH (a:Actor) SET a.age={age} RETURN a.name", MapUtil.map((Object[])new Object[]{"age", 5}), false);
        Assertions.assertThat((Iterable)result).isNotNull();
        Assertions.assertThat((Object)result.queryStatistics()).isNotNull();
        Assertions.assertThat((int)result.queryStatistics().getPropertiesSet()).isEqualTo(3);
        ArrayList<String> names = new ArrayList<String>();
        Iterator namesIterator = ((Iterable)result.queryResults()).iterator();
        while (namesIterator.hasNext()) {
            names.add((String)((Map)namesIterator.next()).get("a.name"));
        }
        Assertions.assertThat(names).hasSize(3);
        Assertions.assertThat((boolean)names.contains("Jeff")).isTrue();
        Assertions.assertThat((boolean)names.contains("John")).isTrue();
        Assertions.assertThat((boolean)names.contains("Colin")).isTrue();
        result = this.session.query("MATCH (a:Actor) SET a.age={age} RETURN a.name, a.age", MapUtil.map((Object[])new Object[]{"age", 5}));
        Assertions.assertThat((Iterable)result).isNotNull();
        Assertions.assertThat((Object)result.queryStatistics()).isNotNull();
        Assertions.assertThat((int)result.queryStatistics().getPropertiesSet()).isEqualTo(3);
        names = new ArrayList();
        for (Map row : (Iterable)result.queryResults()) {
            names.add((String)row.get("a.name"));
            Assertions.assertThat((long)((Number)row.get("a.age")).longValue()).isEqualTo(5L);
        }
        Assertions.assertThat(names).hasSize(3);
        Assertions.assertThat((boolean)names.contains("Jeff")).isTrue();
        Assertions.assertThat((boolean)names.contains("John")).isTrue();
        Assertions.assertThat((boolean)names.contains("Colin")).isTrue();
    }

    @Test
    public void readOnlyQueryShouldNotReturnStatistics() {
        this.session.save((Object)new Actor("Jeff"));
        this.session.save((Object)new Actor("John"));
        this.session.save((Object)new Actor("Colin"));
        Result result = this.session.query("MATCH (a:Actor) RETURN a.name", Collections.EMPTY_MAP, true);
        Assertions.assertThat((Iterable)result).isNotNull();
        Assertions.assertThat((Object)result.queryStatistics()).isNull();
        ArrayList<String> names = new ArrayList<String>();
        Iterator namesIterator = ((Iterable)result.queryResults()).iterator();
        while (namesIterator.hasNext()) {
            names.add((String)((Map)namesIterator.next()).get("a.name"));
        }
        Assertions.assertThat(names).hasSize(3);
        Assertions.assertThat((boolean)names.contains("Jeff")).isTrue();
        Assertions.assertThat((boolean)names.contains("John")).isTrue();
        Assertions.assertThat((boolean)names.contains("Colin")).isTrue();
    }

    @Test
    public void modifyingQueryShouldBePermittedWhenQueryingForObject() {
        this.session.save((Object)new Actor("Jeff"));
        this.session.save((Object)new Actor("John"));
        this.session.save((Object)new Actor("Colin"));
        Actor jeff = (Actor)this.session.queryForObject(Actor.class, "MATCH (a:Actor {name:{name}}) set a.age={age} return a", MapUtil.map((Object[])new Object[]{"name", "Jeff", "age", 40}));
        Assertions.assertThat((Object)jeff).isNotNull();
        Assertions.assertThat((String)jeff.getName()).isEqualTo((Object)"Jeff");
    }

    @Test
    public void modifyingQueryShouldBePermittedWhenQueryingForObjects() {
        this.session.save((Object)new Actor("Jeff"));
        this.session.save((Object)new Actor("John"));
        this.session.save((Object)new Actor("Colin"));
        Iterable actors = this.session.query(Actor.class, "MATCH (a:Actor) set a.age={age} return a", MapUtil.map((Object[])new Object[]{"age", 40}));
        Assertions.assertThat((Iterable)actors).isNotNull();
        ArrayList<String> names = new ArrayList<String>();
        Iterator actorIterator = actors.iterator();
        while (actorIterator.hasNext()) {
            names.add(((Actor)actorIterator.next()).getName());
        }
        Assertions.assertThat(names).hasSize(3);
        Assertions.assertThat((boolean)names.contains("Jeff")).isTrue();
        Assertions.assertThat((boolean)names.contains("John")).isTrue();
        Assertions.assertThat((boolean)names.contains("Colin")).isTrue();
    }

    @Test
    public void shouldBeAbleToHandleNullValuesInQueryResults() {
        this.session.save((Object)new Actor("Jeff"));
        Result results = this.session.query("MATCH (a:Actor) return a.nonExistent as nonExistent", Collections.EMPTY_MAP);
        Map result = (Map)results.iterator().next();
        Assertions.assertThat(result.get("nonExistent")).isNull();
    }

    @Test
    public void shouldBeAbleToMapEntities() {
        Iterator results = this.session.query("MATCH (u:User {name:{name}})-[:RATED]->(m) RETURN u as user, m as movie", MapUtil.map((Object[])new Object[]{"name", "Vince"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        User user = (User)result.get("user");
        Assertions.assertThat((Object)user).isNotNull();
        Movie movie = (Movie)result.get("movie");
        Assertions.assertThat((Object)movie).isNotNull();
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Vince");
        Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Top Gear");
        Assertions.assertThat((boolean)results.hasNext()).isFalse();
    }

    @Test
    public void shouldBeAbleToMapEntitiesAndScalars() {
        Iterator results = this.session.query("MATCH (u:User {name:{name}})-[:RATED]->(m) RETURN u as user, count(m) as count", MapUtil.map((Object[])new Object[]{"name", "Michal"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        User user = (User)result.get("user");
        Assertions.assertThat((Object)user).isNotNull();
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Michal");
        Number count = (Number)result.get("count");
        Assertions.assertThat((long)count.longValue()).isEqualTo(2L);
        Assertions.assertThat((boolean)results.hasNext()).isFalse();
    }

    @Test
    public void shouldBeAbleToMapEntitiesAndScalarsMultipleRows() {
        Iterator results = this.session.query("MATCH (u:User)-[r:RATED]->(m) RETURN m as movie, avg(r.stars) as average ORDER BY average DESC", Collections.EMPTY_MAP).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        Movie movie = (Movie)result.get("movie");
        Assertions.assertThat((Object)movie).isNotNull();
        Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Pulp Fiction");
        Number avg = (Number)result.get("average");
        Assertions.assertThat((Object)avg).isEqualTo((Object)5.0);
        result = (Map)results.next();
        movie = (Movie)result.get("movie");
        Assertions.assertThat((Object)movie).isNotNull();
        Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Top Gear");
        avg = (Number)result.get("average");
        Assertions.assertThat((Object)avg).isEqualTo((Object)3.5);
        Assertions.assertThat((boolean)results.hasNext()).isFalse();
    }

    @Test
    public void shouldBeAbleToMapEntitiesAndScalarsMultipleRowsAndNoAlias() {
        Iterator results = this.session.query("MATCH (u:User)-[r:RATED]->(m) RETURN m, avg(r.stars) ORDER BY avg(r.stars) DESC", Collections.EMPTY_MAP).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        Movie movie = (Movie)result.get("m");
        Assertions.assertThat((Object)movie).isNotNull();
        Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Pulp Fiction");
        Number avg = (Number)result.get("avg(r.stars)");
        Assertions.assertThat((Object)avg).isEqualTo((Object)5.0);
        result = (Map)results.next();
        movie = (Movie)result.get("m");
        Assertions.assertThat((Object)movie).isNotNull();
        Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Top Gear");
        avg = (Number)result.get("avg(r.stars)");
        Assertions.assertThat((Object)avg).isEqualTo((Object)3.5);
        Assertions.assertThat((boolean)results.hasNext()).isFalse();
    }

    @Test
    public void shouldBeAbleToMapEntitiesAndRelationships() {
        Iterator results = this.session.query("MATCH (u:User {name:{name}})-[r:FRIENDS]->(friend) RETURN u as user, friend as friend, r", MapUtil.map((Object[])new Object[]{"name", "Michal"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        User user = (User)result.get("user");
        Assertions.assertThat((Object)user).isNotNull();
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Michal");
        User friend = (User)result.get("friend");
        Assertions.assertThat((Object)friend).isNotNull();
        Assertions.assertThat((String)friend.getName()).isEqualTo((Object)"Vince");
        Assertions.assertThat((String)user.getFriends().iterator().next().getName()).isEqualTo((Object)friend.getName());
        Assertions.assertThat((boolean)results.hasNext()).isFalse();
    }

    @Test
    public void shouldBeAbleToMapEntitiesAndRelationshipsOfDifferentTypes() {
        Iterator results = this.session.query("MATCH (u:User {name:{name}})-[r:FRIENDS]->(friend)-[r2:RATED]->(m) RETURN u as user, friend as friend, r, r2, m as movie, r2.stars as stars", MapUtil.map((Object[])new Object[]{"name", "Michal"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        User user = (User)result.get("user");
        Assertions.assertThat((Object)user).isNotNull();
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Michal");
        User friend = (User)result.get("friend");
        Assertions.assertThat((Object)friend).isNotNull();
        Assertions.assertThat((String)friend.getName()).isEqualTo((Object)"Vince");
        Assertions.assertThat((String)user.getFriends().iterator().next().getName()).isEqualTo((Object)friend.getName());
        Movie topGear = (Movie)result.get("movie");
        Assertions.assertThat((Object)topGear).isNotNull();
        Assertions.assertThat((String)topGear.getTitle()).isEqualTo((Object)"Top Gear");
        Assertions.assertThat(friend.getRatings()).hasSize(1);
        Assertions.assertThat((String)friend.getRatings().iterator().next().getMovie().getTitle()).isEqualTo((Object)topGear.getTitle());
        Number stars = (Number)result.get("stars");
        Assertions.assertThat((long)stars.longValue()).isEqualTo(4L);
        Assertions.assertThat((boolean)results.hasNext()).isFalse();
    }

    @Test
    public void shouldBeAbleToMapRelationshipEntities() {
        Iterator results = this.session.query("MATCH (u:User {name:{name}})-[r:RATED]->(m) RETURN u,r,m", MapUtil.map((Object[])new Object[]{"name", "Vince"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        Movie movie = (Movie)result.get("m");
        Assertions.assertThat((Object)movie).isNotNull();
        Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Top Gear");
        User user = (User)result.get("u");
        Assertions.assertThat((Object)user).isNotNull();
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Vince");
        Rating rating = (Rating)result.get("r");
        Assertions.assertThat((Object)rating).isNotNull();
        Assertions.assertThat((int)rating.getStars()).isEqualTo(4);
        Assertions.assertThat((Long)movie.getRatings().iterator().next().getId()).isEqualTo((Object)rating.getId());
        Assertions.assertThat((Long)user.getRatings().iterator().next().getId()).isEqualTo((Object)rating.getId());
        Assertions.assertThat((boolean)results.hasNext()).isFalse();
    }

    @Test
    public void shouldBeAbleToMapVariableDepthRelationshipsWithIncompletePaths() {
        Rating rating;
        Iterator results = this.session.query("match (u:User {name:{name}}) match (m:Movie {title:{title}}) match (u)-[r*0..2]-(m) return u,r,m", MapUtil.map((Object[])new Object[]{"name", "Vince", "title", "Top Gear"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        boolean ratedRelationshipFound = false;
        Movie movie = (Movie)result.get("m");
        Assertions.assertThat((Object)movie).isNotNull();
        Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Top Gear");
        User user = (User)result.get("u");
        Assertions.assertThat((Object)user).isNotNull();
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Vince");
        List ratings = (List)result.get("r");
        if (ratings.size() == 1) {
            rating = (Rating)ratings.get(0);
            Assertions.assertThat((Object)rating).isNotNull();
            Assertions.assertThat((int)rating.getStars()).isEqualTo(4);
            Assertions.assertThat((Long)movie.getRatings().iterator().next().getId()).isEqualTo((Object)rating.getId());
            Assertions.assertThat((Long)user.getRatings().iterator().next().getId()).isEqualTo((Object)rating.getId());
            ratedRelationshipFound = true;
        }
        Assertions.assertThat(user.getFriends()).isNull();
        result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        movie = (Movie)result.get("m");
        Assertions.assertThat((Object)movie).isNotNull();
        Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Top Gear");
        user = (User)result.get("u");
        Assertions.assertThat((Object)user).isNotNull();
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Vince");
        ratings = (List)result.get("r");
        if (ratings.size() == 1) {
            rating = (Rating)ratings.get(0);
            Assertions.assertThat((Object)rating).isNotNull();
            Assertions.assertThat((int)rating.getStars()).isEqualTo(4);
            Assertions.assertThat((Long)movie.getRatings().iterator().next().getId()).isEqualTo((Object)rating.getId());
            Assertions.assertThat((Long)user.getRatings().iterator().next().getId()).isEqualTo((Object)rating.getId());
            ratedRelationshipFound = true;
        }
        Assertions.assertThat((boolean)ratedRelationshipFound).isTrue();
        Assertions.assertThat(user.getFriends()).isNull();
    }

    @Test
    public void shouldBeAbleToMapVariableDepthRelationshipsWithCompletePaths() {
        Iterator results = this.session.query("match (u:User {name:{name}}) match (u)-[r*0..1]-(n) return u,r,n", MapUtil.map((Object[])new Object[]{"name", "Vince"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        boolean foundMichal = false;
        User user = (User)result.get("u");
        Assertions.assertThat((Object)user).isNotNull();
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Vince");
        foundMichal = this.checkForMichal(result, foundMichal);
        result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        foundMichal = this.checkForMichal(result, foundMichal);
        result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        foundMichal = this.checkForMichal(result, foundMichal);
        Assertions.assertThat((boolean)foundMichal).isTrue();
    }

    @Test
    public void shouldBeAbleToMapCollectionsOfNodes() {
        Iterator results = this.session.query("match (u:User {name:{name}})-[r:RATED]->(m) return u as user,collect(r), collect(m) as movies", MapUtil.map((Object[])new Object[]{"name", "Michal"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        Assertions.assertThat((String)((User)result.get("user")).getName()).isEqualTo((Object)"Michal");
        List ratings = (List)result.get("collect(r)");
        Assertions.assertThat((List)ratings).hasSize(2);
        for (Rating rating : ratings) {
            Assertions.assertThat((String)rating.getUser().getName()).isEqualTo((Object)"Michal");
        }
        List movies = (List)result.get("movies");
        Assertions.assertThat((List)movies).hasSize(2);
        for (Movie movie : movies) {
            if (movie.getRatings().iterator().next().getStars() == 3) {
                Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Top Gear");
                continue;
            }
            Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Pulp Fiction");
            Assertions.assertThat((int)movie.getRatings().iterator().next().getStars()).isEqualTo(5);
        }
        Assertions.assertThat((boolean)results.hasNext()).isFalse();
    }

    @Test
    public void shouldBeAbleToMapCollectionsFromPath() {
        Iterator results = this.session.query("MATCH p=(u:User {name:{name}})-[r:RATED]->(m) RETURN nodes(p) as nodes, rels(p) as rels", MapUtil.map((Object[])new Object[]{"name", "Vince"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        List nodes = (List)result.get("nodes");
        List rels = (List)result.get("rels");
        Assertions.assertThat((List)nodes).hasSize(2);
        Assertions.assertThat((List)rels).hasSize(1);
        for (Object o : nodes) {
            if (!(o instanceof User)) continue;
            User user = (User)o;
            Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Vince");
            Assertions.assertThat(user.getRatings()).hasSize(1);
            Movie movie = user.getRatings().iterator().next().getMovie();
            Assertions.assertThat((Object)movie).isNotNull();
            Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Top Gear");
            Rating rating = movie.getRatings().iterator().next();
            Assertions.assertThat((Object)rating).isNotNull();
            Assertions.assertThat((int)rating.getStars()).isEqualTo(4);
        }
    }

    @Test
    public void shouldBeAbleToMapArrays() {
        Iterator results = this.session.query("MATCH (u:User {name:{name}}) RETURN u.array as arr", MapUtil.map((Object[])new Object[]{"name", "Christophe"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        Assertions.assertThat((int)((String[])result.get("arr")).length).isEqualTo(2);
    }

    @Test
    public void shouldBeAbleToMapMixedArrays() {
        Iterator results = this.session.query("MATCH (u:User {name:{name}}) RETURN u.array as arr, [1,'two',true] as mixed", MapUtil.map((Object[])new Object[]{"name", "Christophe"})).iterator();
        Assertions.assertThat((Iterator)results).isNotNull();
        Map result = (Map)results.next();
        Assertions.assertThat((Map)result).isNotNull();
        Assertions.assertThat((int)((String[])result.get("arr")).length).isEqualTo(2);
        Object[] mixed = (Object[])result.get("mixed");
        Assertions.assertThat((int)mixed.length).isEqualTo(3);
        Assertions.assertThat((long)((Number)mixed[0]).longValue()).isEqualTo(1L);
        Assertions.assertThat((Object)mixed[1]).isEqualTo((Object)"two");
        Assertions.assertThat((Object)mixed[2]).isEqualTo((Object)true);
    }

    @Test
    public void modifyingQueryShouldBeAbleToMapEntitiesAndReturnStatistics() {
        Result result = this.session.query("MATCH (u:User {name:{name}})-[:RATED]->(m) WITH u,m SET u.age={age} RETURN u as user, m as movie", MapUtil.map((Object[])new Object[]{"name", "Vince", "age", 20}));
        Iterator results = ((Iterable)result.queryResults()).iterator();
        Assertions.assertThat(results).isNotNull();
        Map row = (Map)results.next();
        Assertions.assertThat((Map)row).isNotNull();
        User user = (User)row.get("user");
        Assertions.assertThat((Object)user).isNotNull();
        Movie movie = (Movie)row.get("movie");
        Assertions.assertThat((Object)movie).isNotNull();
        Assertions.assertThat((String)user.getName()).isEqualTo((Object)"Vince");
        Assertions.assertThat((String)movie.getTitle()).isEqualTo((Object)"Top Gear");
        Assertions.assertThat((boolean)results.hasNext()).isFalse();
    }

    @Test
    public void shouldNotOverflowIntegers() {
        long start = Integer.MAX_VALUE;
        this.session.query("CREATE (n:Sequence {id:{id}, next:{start}})", MapUtil.map((Object[])new Object[]{"id", "test", "start", start}));
        String incrementStmt = "MATCH (n:Sequence) WHERE n.id = {id} REMOVE n.lock SET n.next = n.next + {increment} RETURN n.next - {increment} as current";
        Result result = this.session.query(incrementStmt, MapUtil.map((Object[])new Object[]{"id", "test", "increment", 1}));
        Assertions.assertThat((long)((Number)((Map)result.iterator().next()).get("current")).longValue()).isEqualTo(start);
        result = this.session.query(incrementStmt, MapUtil.map((Object[])new Object[]{"id", "test", "increment", 1}));
        Assertions.assertThat((long)((Number)((Map)result.iterator().next()).get("current")).longValue()).isEqualTo(start + 1L);
    }

    @Test
    public void shouldLoadNodesWithUnmappedOrNoLabels() {
        int movieCount = 0;
        int userCount = 0;
        int unmappedCount = 0;
        int noLabelCount = 0;
        this.session.query("CREATE (unknown), (m:Unmapped), (n:Movie), (n)-[:UNKNOWN]->(m)", Collections.EMPTY_MAP);
        Result result = this.session.query("MATCH (n) return n", Collections.EMPTY_MAP);
        Assertions.assertThat((Iterable)result).isNotNull();
        for (Map row : result) {
            Object n = row.get("n");
            if (n instanceof User) {
                ++userCount;
                continue;
            }
            if (n instanceof Movie) {
                ++movieCount;
                continue;
            }
            if (!(n instanceof NodeModel)) continue;
            if (((NodeModel)n).getLabels().length == 0) {
                ++noLabelCount;
                continue;
            }
            if (!((NodeModel)n).getLabels()[0].equals("Unmapped")) continue;
            ++unmappedCount;
        }
        Assertions.assertThat((int)unmappedCount).isEqualTo(1);
        Assertions.assertThat((int)noLabelCount).isEqualTo(1);
        Assertions.assertThat((int)movieCount).isEqualTo(4);
        Assertions.assertThat((int)userCount).isEqualTo(4);
    }

    @Test
    public void shouldMapCypherCollectionsToArrays() {
        Iterator iterator = this.session.query("MATCH (n:User) return collect(n.name) as names", Collections.EMPTY_MAP).iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Map row = (Map)iterator.next();
        Assertions.assertThat((boolean)row.get("names").getClass().isArray()).isTrue();
        Assertions.assertThat((int)((String[])row.get("names")).length).isEqualTo(4);
        iterator = this.session.query("MATCH (n:User {name:'Michal'}) return collect(n.name) as names", Collections.EMPTY_MAP).iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        row = (Map)iterator.next();
        Assertions.assertThat((boolean)row.get("names").getClass().isArray()).isTrue();
        Assertions.assertThat((int)((String[])row.get("names")).length).isEqualTo(1);
        iterator = this.session.query("MATCH (n:User {name:'Does Not Exist'}) return collect(n.name) as names", Collections.EMPTY_MAP).iterator();
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        row = (Map)iterator.next();
        Assertions.assertThat((boolean)row.get("names").getClass().isArray()).isTrue();
        Assertions.assertThat((int)((Object[])row.get("names")).length).isEqualTo(0);
    }

    private boolean checkForMichal(Map<String, Object> result, boolean foundMichal) {
        User u;
        if (result.get("n") instanceof User && (u = (User)result.get("n")).getName().equals("Michal")) {
            Assertions.assertThat(u.getFriends()).hasSize(1);
            Assertions.assertThat((String)u.getFriends().iterator().next().getName()).isEqualTo((Object)"Vince");
            foundMichal = true;
        }
        return foundMichal;
    }
}

