/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.events;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.neo4j.ogm.domain.cineasts.annotated.Actor;
import org.neo4j.ogm.domain.cineasts.annotated.Knows;
import org.neo4j.ogm.domain.filesystem.Document;
import org.neo4j.ogm.domain.filesystem.Folder;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.event.Event;
import org.neo4j.ogm.session.event.EventListener;
import org.neo4j.ogm.session.event.PersistenceEvent;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public abstract class EventTestBaseClass
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    static TestEventListener eventListener;
    protected Session session;
    protected Document a;
    protected Document b;
    protected Document c;
    protected Document d;
    protected Document e;
    protected Folder folder;
    Actor jim;
    Actor bruce;
    Actor lee;
    Actor stan;
    Knows knowsJB;
    private Knows knowsLS;
    Knows knowsJL;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.filesystem", "org.neo4j.ogm.domain.cineasts.annotated"});
        eventListener = new TestEventListener();
        sessionFactory.register((EventListener)eventListener);
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
        this.a = new Document();
        this.a.setName("a");
        this.b = new Document();
        this.b.setName("b");
        this.c = new Document();
        this.c.setName("c");
        this.d = new Document();
        this.d.setName("d");
        this.e = new Document();
        this.e.setName("e");
        this.folder = new Folder();
        this.folder.setName("folder");
        this.folder.getDocuments().add(this.a);
        this.folder.getDocuments().add(this.b);
        this.folder.getDocuments().add(this.c);
        this.a.setFolder(this.folder);
        this.b.setFolder(this.folder);
        this.c.setFolder(this.folder);
        this.session.save((Object)this.d);
        this.session.save((Object)this.e);
        this.session.save((Object)this.folder);
        this.jim = new Actor("Jim");
        this.bruce = new Actor("Bruce");
        this.lee = new Actor("Lee");
        this.stan = new Actor("Stan");
        this.knowsJB = new Knows();
        this.knowsJB.setFirstActor(this.jim);
        this.knowsJB.setSecondActor(this.bruce);
        this.knowsJB.setSince(new Date());
        this.jim.getKnows().add(this.knowsJB);
        this.knowsJL = new Knows();
        this.knowsJL.setFirstActor(this.jim);
        this.knowsJL.setSecondActor(this.lee);
        this.knowsJL.setSince(new Date());
        this.jim.getKnows().add(this.knowsJL);
        this.knowsLS = new Knows();
        this.knowsLS.setFirstActor(this.lee);
        this.knowsLS.setSecondActor(this.stan);
        this.knowsLS.setSince(new Date());
        this.lee.getKnows().add(this.knowsLS);
        this.session.save((Object)this.jim);
        eventListener.clear();
    }

    @After
    public void clean() throws IOException {
        this.session.purgeDatabase();
    }

    static class TestEventListener
    implements EventListener {
        List<Event> eventsCaptured = new ArrayList<Event>();

        TestEventListener() {
        }

        public void onPreSave(Event event) {
            this.eventsCaptured.add(event);
        }

        public void onPostSave(Event event) {
            this.eventsCaptured.add(event);
        }

        public void onPreDelete(Event event) {
            this.eventsCaptured.add(event);
        }

        public void onPostDelete(Event event) {
            this.eventsCaptured.add(event);
        }

        public boolean captured(Object o, Event.TYPE lifecycle) {
            PersistenceEvent event = new PersistenceEvent(o, lifecycle);
            for (Event captured : this.eventsCaptured) {
                if (!captured.toString().equals(event.toString())) continue;
                return true;
            }
            return false;
        }

        public int count() {
            return this.eventsCaptured.size();
        }

        public void clear() {
            this.eventsCaptured.clear();
        }
    }
}

