/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.lifecycle;

import java.io.IOException;
import java.io.Serializable;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.filesystem.Document;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class DirtyObjectsTest
extends MultiDriverTestClass {
    private Neo4jSession session;
    private SessionFactory sessionFactory;

    @Before
    public void init() throws IOException {
        this.sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.filesystem"});
        this.session = (Neo4jSession)this.sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void newObjectShouldBeDirty() {
        Document d = new Document();
        Assertions.assertThat((boolean)this.session.context().isDirty((Object)d)).isTrue();
    }

    @Test
    public void savedObjectShouldNotBeDirty() {
        Document d = new Document();
        this.session.save((Object)d);
        Assertions.assertThat((boolean)this.session.context().isDirty((Object)d)).isFalse();
    }

    @Test
    public void modifiedLoadedObjectShouldBeDirty() {
        Document d = new Document();
        this.session.save((Object)d);
        d.setName("Document");
        Assertions.assertThat((boolean)this.session.context().isDirty((Object)d)).isTrue();
    }

    @Test
    public void unmodifiedLoadedObjectShouldNotBeDirty() {
        Document d = new Document();
        this.session.save((Object)d);
        d = (Document)this.session.load(Document.class, (Serializable)d.getId());
        Assertions.assertThat((boolean)this.session.context().isDirty((Object)d)).isFalse();
    }

    @Test
    public void evictedObjectShouldBeDirty() {
        Document d = new Document();
        this.session.save((Object)d);
        this.session.clear();
        Assertions.assertThat((boolean)this.session.context().isDirty((Object)d)).isTrue();
    }

    @Test
    public void evictedObjectThatIsIdenticalToTheLoadedObjectShouldNotBeDirty() {
        Document d = new Document();
        this.session.save((Object)d);
        this.session.clear();
        Document d2 = (Document)this.session.load(Document.class, (Serializable)d.getId());
        Assertions.assertThat((boolean)this.session.context().isDirty((Object)d)).isFalse();
        Assertions.assertThat((boolean)this.session.context().isDirty((Object)d2)).isFalse();
    }

    @Test
    public void reloadingAnObjectReturnsTheCachedInstance() {
        Document d = new Document();
        this.session.save((Object)d);
        Assertions.assertThat((Object)this.session.load(Document.class, (Serializable)d.getId())).isSameAs((Object)d);
    }

    @Test
    public void reloadingAnObjectReturnsTheCachedInstanceEvenIfItIsChangedInTheDatabase() {
        Document d = new Document();
        this.session.save((Object)d);
        this.session.query("MATCH (n) SET n.name='Document'", Utils.map((Object[])new Object[0]));
        Document d2 = (Document)this.sessionFactory.openSession().load(Document.class, (Serializable)d.getId());
        Assertions.assertThat((String)d2.getName()).isEqualTo((Object)"Document");
        Document d3 = (Document)this.session.load(Document.class, (Serializable)d.getId());
        Assertions.assertThat((String)d3.getName()).isEqualTo(null);
        Assertions.assertThat((Object)d3).isSameAs((Object)d);
    }
}

