/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.session.mappingContext;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.context.MappingContext;
import org.neo4j.ogm.domain.cineasts.annotated.Actor;
import org.neo4j.ogm.domain.cineasts.annotated.Knows;
import org.neo4j.ogm.domain.music.Album;
import org.neo4j.ogm.domain.music.Artist;
import org.neo4j.ogm.domain.music.Recording;
import org.neo4j.ogm.domain.music.ReleaseFormat;
import org.neo4j.ogm.domain.music.Studio;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class SessionAndMappingContextTest
extends MultiDriverTestClass {
    private Neo4jSession session;
    private Album album1;
    private Album album2;
    private Album album3;
    private Artist artist1;
    private ReleaseFormat releaseFormat;
    private Actor actor1;
    private Actor actor2;
    private Knows knows;
    private Knows knows2;

    @Before
    public void init() throws IOException {
        this.session = (Neo4jSession)new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.music", "org.neo4j.ogm.domain.cineasts.annotated"}).openSession();
        this.artist1 = new Artist();
        this.artist1.setName("MainArtist");
        Artist artist2 = new Artist();
        artist2.setName("GuestArtist");
        this.album1 = new Album();
        this.album1.setName("First");
        this.album1.setGuestArtist(artist2);
        this.album2 = new Album();
        this.album2.setName("Second");
        this.album3 = new Album();
        this.album3.setName("Third");
        this.artist1.addAlbum(this.album1);
        this.artist1.addAlbum(this.album2);
        this.artist1.addAlbum(this.album3);
        Studio studio = new Studio();
        studio.setName("Studio");
        Recording recording = new Recording();
        recording.setAlbum(this.album1);
        recording.setAlbum(this.album2);
        recording.setAlbum(this.album3);
        recording.setStudio(studio);
        recording.setYear(2001);
        this.session.save((Object)this.artist1);
        this.actor1 = new Actor("Actor1");
        this.actor2 = new Actor("Actor2");
        this.knows = new Knows();
        this.knows.setFirstActor(this.actor1);
        this.knows.setSecondActor(this.actor2);
        this.actor1.knows.add(this.knows);
        this.session.save((Object)this.actor1);
        Actor actor3 = new Actor("Actor3");
        Actor actor4 = new Actor("Actor4");
        this.knows2 = new Knows();
        this.knows2.setFirstActor(actor3);
        this.knows2.setSecondActor(actor4);
        actor3.knows.add(this.knows2);
        this.session.save((Object)actor3);
    }

    @After
    public void teardown() {
        this.session.purgeDatabase();
    }

    @Test
    public void disposeFromMappingContextOnDeleteWithTransientRelationshipTest() {
        MappingContext mappingContext = this.session.context();
        Assertions.assertThat((mappingContext.getNodeEntity(this.artist1.getId()).getClass() == Artist.class ? 1 : 0) != 0).isTrue();
        this.session.delete((Object)this.artist1);
        Object object = mappingContext.getNodeEntity(this.artist1.getId());
        Assertions.assertThat((object == null ? 1 : 0) != 0).isTrue();
        Album retrievedAlbum1 = (Album)mappingContext.getNodeEntity(this.album1.getId());
        Assertions.assertThat((retrievedAlbum1.getArtist() == null ? 1 : 0) != 0).isTrue();
        Album retrievedAlbum2 = (Album)mappingContext.getNodeEntity(this.album2.getId());
        Assertions.assertThat((retrievedAlbum2.getArtist() == null ? 1 : 0) != 0).isTrue();
        Album retrievedAlbum3 = (Album)mappingContext.getNodeEntity(this.album3.getId());
        Assertions.assertThat((retrievedAlbum3.getArtist() == null ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void disposeFromMappingContextOnDeleteWithRelationshipEntityTest() {
        Assertions.assertThat((this.session.context().getNodeEntity(this.actor1.getId()).getClass() == Actor.class ? 1 : 0) != 0).isTrue();
        Object objectRel = this.session.context().getRelationshipEntity(this.knows.id);
        Assertions.assertThat((objectRel.getClass() == Knows.class ? 1 : 0) != 0).isTrue();
        this.session.delete((Object)this.actor1);
        Result result = this.session.query("MATCH (n) RETURN n", Collections.EMPTY_MAP);
        Object object = this.session.context().getNodeEntity(this.actor1.getId());
        Assertions.assertThat((object == null ? 1 : 0) != 0).isTrue();
        objectRel = this.session.context().getRelationshipEntity(this.knows.id);
        Assertions.assertThat((objectRel == null ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((this.session.context().getNodeEntity(this.actor1.getId()) == null ? 1 : 0) != 0).isTrue();
        Knows inSessionKnows = (Knows)this.session.load(Knows.class, (Serializable)this.knows.id);
        Assertions.assertThat((inSessionKnows == null ? 1 : 0) != 0).isTrue();
        Knows inSessionKnows2 = (Knows)this.session.load(Knows.class, (Serializable)this.knows2.id);
        Assertions.assertThat((inSessionKnows2 != null ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testEntityRelationshipProperlyRemoved() {
        this.session.delete((Object)this.knows);
        Knows testKnows = (Knows)this.session.load(Knows.class, (Serializable)this.knows.id);
        Assertions.assertThat((testKnows == null ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void testDetachNode() {
        Assertions.assertThat((boolean)this.session.detachNodeEntity(this.actor1.getId())).isTrue();
        Assertions.assertThat((boolean)this.session.detachNodeEntity(this.actor1.getId())).isFalse();
    }

    @Test
    public void testDetachNode2() {
        Assertions.assertThat((boolean)this.session.detachNodeEntity(this.actor2.getId())).isTrue();
        Assertions.assertThat((boolean)this.session.detachNodeEntity(this.actor2.getId())).isFalse();
    }

    @Test
    public void testDetachRelationshipEntity() {
        Assertions.assertThat((boolean)this.session.detachRelationshipEntity(this.knows.id)).isTrue();
        Assertions.assertThat((boolean)this.session.detachRelationshipEntity(this.knows.id)).isFalse();
    }

    @Test
    public void shouldRollbackRelationshipEntityWithDifferentStartAndEndNodes() {
        Actor mary = new Actor("Mary");
        Actor john = new Actor("John");
        Knows maryKnowsJohn = new Knows();
        maryKnowsJohn.setFirstActor(mary);
        maryKnowsJohn.setSecondActor(john);
        try (Transaction tx = this.session.beginTransaction();){
            this.session.save((Object)maryKnowsJohn);
            Assertions.assertThat((Long)mary.getId()).isNotNull();
            Assertions.assertThat((Long)maryKnowsJohn.id).isNotNull();
            Assertions.assertThat((Long)john.getId()).isNotNull();
            tx.rollback();
            Assertions.assertThat((Long)mary.getId()).isNull();
            Assertions.assertThat((Long)maryKnowsJohn.id).isNull();
            Assertions.assertThat((Long)john.getId()).isNull();
        }
    }

    @Test
    public void shouldWhat() {
        Actor mary = new Actor("Mary");
        Knows maryKnowsMary = new Knows();
        maryKnowsMary.setFirstActor(mary);
        maryKnowsMary.setSecondActor(mary);
        mary.getKnows().add(maryKnowsMary);
        try (Transaction tx = this.session.beginTransaction();){
            this.session.save((Object)mary);
            this.session.context().reset((Object)mary);
        }
    }

    @Test
    public void shouldNotThrowConcurrentModificationException() {
        try (Transaction tx = this.session.beginTransaction();){
            this.session.save((Object)new Actor("Mary"));
            this.session.deleteAll(Actor.class);
        }
    }
}

