/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.transaction;

import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.transaction.DefaultTransactionManager;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.AbstractTransaction;
import org.neo4j.ogm.transaction.Transaction;

public class ClosedTransactionTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;
    private DefaultTransactionManager transactionManager;
    private Transaction tx;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.tree"});
    }

    @Before
    public void init() {
        this.transactionManager = new DefaultTransactionManager(this.session, sessionFactory.getDriver());
        this.session = sessionFactory.openSession();
    }

    @Before
    public void createTransactionAndCloseOnServerButNotOnClient() {
        this.tx = this.transactionManager.openTransaction();
        this.tx.close();
        this.transactionManager.reinstate((AbstractTransaction)this.tx);
    }

    @After
    public void clearTransactionManager() {
        this.transactionManager.clear();
    }

    @Test
    public void shouldNotThrowExceptionWhenRollingBackAClosedTransaction() {
        this.tx.rollback();
    }

    @Test
    public void shouldNotThrowExceptionWhenClosingAClosedTransaction() {
        this.tx.close();
    }

    @Test(expected=TransactionException.class)
    public void shouldThrowExceptionWhenCommittingAClosedTransaction() {
        this.tx.commit();
    }
}

