/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.transaction;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.ogm.exception.core.TransactionManagerException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.transaction.DefaultTransactionManager;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class TransactionManagerTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void setUpClass() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.social"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @After
    public void destroy() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldBeAbleToCreateManagedTransaction() {
        DefaultTransactionManager transactionManager = new DefaultTransactionManager(this.session, sessionFactory.getDriver());
        Assertions.assertThat((String)this.session.getLastBookmark()).isNull();
        try (Transaction tx = transactionManager.openTransaction();){
            Assertions.assertThat((Comparable)tx.status()).isEqualTo((Object)Transaction.Status.OPEN);
        }
    }

    @Test(expected=TransactionManagerException.class)
    @Ignore(value="What's the rationale of this test ? Actually leaves tx in an inconsistent state")
    public void shouldFailCommitFreeTransactionInManagedContext() {
        DefaultTransactionManager transactionManager = new DefaultTransactionManager(null, sessionFactory.getDriver());
        try (Transaction tx = sessionFactory.getDriver().newTransaction(Transaction.Type.READ_WRITE, null);){
            transactionManager.commit(tx);
        }
    }

    @Test(expected=TransactionManagerException.class)
    @Ignore(value="What's the rationale of this test ? Actually leaves tx in an inconsistent state")
    public void shouldFailRollbackFreeTransactionInManagedContext() {
        DefaultTransactionManager transactionManager = new DefaultTransactionManager(null, sessionFactory.getDriver());
        try (Transaction tx = sessionFactory.getDriver().newTransaction(Transaction.Type.READ_WRITE, null);){
            transactionManager.rollback(tx);
        }
    }

    @Test
    public void shouldRollbackManagedTransaction() {
        DefaultTransactionManager transactionManager = new DefaultTransactionManager(this.session, sessionFactory.getDriver());
        Assertions.assertThat((String)this.session.getLastBookmark()).isNull();
        try (Transaction tx = transactionManager.openTransaction();){
            Assertions.assertThat((Comparable)tx.status()).isEqualTo((Object)Transaction.Status.OPEN);
            tx.rollback();
            Assertions.assertThat((Comparable)tx.status()).isEqualTo((Object)Transaction.Status.ROLLEDBACK);
        }
    }
}

