/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.transaction;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.exception.CypherException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class TransactionSerialisationTest
extends MultiDriverTestClass {
    @Test
    public void shouldBeAbleToRunMultiThreadedLongRunningQueriesWithoutLosingConnectionResources() throws InterruptedException {
        int numThreads = Runtime.getRuntime().availableProcessors() * 4;
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        CountDownLatch latch = new CountDownLatch(numThreads);
        String query = "FOREACH (n in RANGE(1, 1000) | CREATE (a)-[:KNOWS]->(b))";
        for (int i = 0; i < numThreads; ++i) {
            executor.submit(new QueryRunner(latch, query));
        }
        latch.await();
        executor.shutdownNow();
    }

    @Test
    public void shouldBeAbleToHandleMultiThreadedFailingQueriesWithoutLosingConnectionResources() throws InterruptedException {
        int numThreads = Runtime.getRuntime().availableProcessors() * 4;
        ExecutorService executor = Executors.newFixedThreadPool(numThreads);
        CountDownLatch latch = new CountDownLatch(numThreads);
        String query = "FOREACH (n in RANGE(1, 1000) ? CREATE (a)-[:KNOWS]->(b))";
        for (int i = 0; i < numThreads; ++i) {
            executor.submit(new QueryRunner(latch, query));
        }
        latch.await();
        executor.shutdownNow();
    }

    static /* synthetic */ Driver access$000() {
        return driver;
    }

    class QueryRunner
    implements Runnable {
        private final CountDownLatch latch;
        private final String query;
        private final SessionFactory sessionFactory = new SessionFactory(TransactionSerialisationTest.access$000(), new String[]{"org.neo4j.ogm.domain.tree"});

        public QueryRunner(CountDownLatch latch, String query) {
            this.query = query;
            this.latch = latch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Session session = this.sessionFactory.openSession();
            try (Transaction tx = session.beginTransaction();){
                session.query(this.query, Utils.map((Object[])new Object[0]));
                tx.commit();
            }
            catch (Exception e) {
                Assertions.assertThat((boolean)(e instanceof CypherException)).isTrue();
            }
            finally {
                this.latch.countDown();
            }
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

