/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.transaction;

import java.io.IOException;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.music.Album;
import org.neo4j.ogm.domain.music.Artist;
import org.neo4j.ogm.domain.music.Recording;
import org.neo4j.ogm.domain.music.Studio;
import org.neo4j.ogm.exception.TransactionException;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.transaction.Transaction;

public class TransactionTest
extends MultiDriverTestClass {
    private Session session;

    @Before
    public void init() throws IOException {
        SessionFactory sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.music"});
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @After
    public void clearDatabase() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldNotCommitWhenTransactionIsManaged() {
        Transaction tx = this.session.beginTransaction();
        Studio emi = new Studio("EMI Studios, London");
        Artist theBeatles = new Artist("The Beatles");
        Album please = new Album("Please Please Me");
        Recording pleaseRecording = new Recording(please, emi, 1963);
        please.setRecording(pleaseRecording);
        theBeatles.getAlbums().add(please);
        please.setArtist(theBeatles);
        this.session.save((Object)theBeatles);
        tx.rollback();
        Assertions.assertThat((long)this.session.countEntitiesOfType(Artist.class)).isEqualTo(0L);
    }

    @Test
    public void shouldBeAbleToRetrySaveOnTransactionRollback() {
        Transaction tx = this.session.beginTransaction();
        Studio emi = new Studio("EMI Studios, London");
        Artist theBeatles = new Artist("The Beatles");
        Album please = new Album("Please Please Me");
        Recording pleaseRecording = new Recording(please, emi, 1963);
        please.setRecording(pleaseRecording);
        theBeatles.getAlbums().add(please);
        please.setArtist(theBeatles);
        this.session.save((Object)theBeatles);
        tx.rollback();
        this.session.save((Object)theBeatles);
        this.session.clear();
        theBeatles = (Artist)this.session.loadAll(Artist.class, -1).iterator().next();
        Assertions.assertThat((String)theBeatles.getName()).isEqualTo((Object)"The Beatles");
        Assertions.assertThat(theBeatles.getAlbums()).hasSize(1);
        Assertions.assertThat((String)theBeatles.getAlbums().iterator().next().getName()).isEqualTo((Object)"Please Please Me");
        Assertions.assertThat((String)theBeatles.getAlbums().iterator().next().getRecording().getStudio().getName()).isEqualTo((Object)"EMI Studios, London");
    }

    @Test
    public void shouldNotBeReadOnlyByDefault() {
        try (Transaction tx = this.session.beginTransaction();){
            Assertions.assertThat((boolean)tx.isReadOnly()).isFalse();
        }
    }

    @Test
    public void shouldBeAbleToCreateReadOnlyTransaction() {
        try (Transaction tx = this.session.beginTransaction(Transaction.Type.READ_ONLY);){
            Assertions.assertThat((boolean)tx.isReadOnly()).isTrue();
        }
    }

    @Test
    public void shouldNotBeAbleToExtendAReadTransactionWithAReadWriteInnerTransaction() {
        try (Transaction tx1 = this.session.beginTransaction(Transaction.Type.READ_ONLY);
             Transaction tx2 = this.session.beginTransaction(Transaction.Type.READ_WRITE);){
            Assertions.fail((String)"Should not have allowed transaction extension of different type");
        }
        catch (TransactionException tme) {
            Assertions.assertThat((String)tme.getLocalizedMessage()).isEqualTo((Object)"Incompatible transaction type specified: must be 'READ_ONLY'");
        }
    }

    @Test
    public void shouldNotBeAbleToExtendAReadWriteTransactionWithAReadOnlyInnerTransaction() {
        try (Transaction tx1 = this.session.beginTransaction(Transaction.Type.READ_WRITE);
             Transaction tx2 = this.session.beginTransaction(Transaction.Type.READ_ONLY);){
            Assertions.fail((String)"Should not have allowed transaction extension of different type");
        }
        catch (TransactionException tme) {
            Assertions.assertThat((String)tme.getLocalizedMessage()).isEqualTo((Object)"Incompatible transaction type specified: must be 'READ_WRITE'");
        }
    }

    @Test
    public void shouldAutomaticallyExtendAReadOnlyTransactionWithAReadOnlyExtension() {
        try (Transaction tx1 = this.session.beginTransaction(Transaction.Type.READ_ONLY);
             Transaction tx2 = this.session.beginTransaction();){
            Assertions.assertThat((boolean)tx2.isReadOnly()).isTrue();
        }
    }

    @Test
    public void shouldAutomaticallyExtendAReadWriteTransactionWithAReadWriteExtension() {
        try (Transaction tx1 = this.session.beginTransaction(Transaction.Type.READ_WRITE);
             Transaction tx2 = this.session.beginTransaction();){
            Assertions.assertThat((boolean)tx2.isReadOnly()).isFalse();
        }
    }

    @Test
    public void defaultTransactionShouldWorkAfterManagedTransaction() {
        Transaction tx = this.session.beginTransaction();
        Studio emi = new Studio("EMI Studios, London");
        this.session.save((Object)emi);
        tx.commit();
        tx.close();
        this.session.purgeDatabase();
    }

    @Test
    public void defaultTransactionShouldWorkAfterDefaultTransaction() {
        Studio emi = new Studio("EMI Studios, London");
        this.session.save((Object)emi);
        this.session.purgeDatabase();
    }
}

