/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.types;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.UUID;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithAnnotatedAbstractNamedParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithAnnotatedAbstractParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithAnnotatedConcreteNamedParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithAnnotatedConcreteParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithAnnotatedInterface;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithAnnotatedInterfaceParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithAnnotatedNamedInterfaceParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithMultipleAnnotatedInterfaces;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithPlainAbstractParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithPlainConcreteParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithPlainInterfaceParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedConcreteParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedInterface;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedInterfaceWithSingleImpl;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedChildWithAnnotatedAbstractNamedParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedChildWithAnnotatedAbstractParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedChildWithAnnotatedConcreteNamedParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedChildWithAnnotatedConcreteParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedChildWithAnnotatedInterfaceParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedChildWithAnnotatedNamedInterfaceParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedChildWithPlainAbstractParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedChildWithPlainConcreteParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedChildWithPlainInterfaceParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedInterfaceParent;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedNamedSingleClass;
import org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedSingleClass;
import org.neo4j.ogm.domain.hierarchy.domain.custom_id.MostBasicEntity;
import org.neo4j.ogm.domain.hierarchy.domain.custom_id.RootEntity;
import org.neo4j.ogm.domain.hierarchy.domain.custom_id.SubEntity;
import org.neo4j.ogm.domain.hierarchy.domain.custom_id.SubSubEntity;
import org.neo4j.ogm.domain.hierarchy.domain.people.Bloke;
import org.neo4j.ogm.domain.hierarchy.domain.people.Entity;
import org.neo4j.ogm.domain.hierarchy.domain.people.Female;
import org.neo4j.ogm.domain.hierarchy.domain.people.Male;
import org.neo4j.ogm.domain.hierarchy.domain.people.Person;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithAbstractParentAndAnnotatedSuperclass;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithAnnotatedAbstractNamedParent;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithAnnotatedAbstractParent;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithAnnotatedConcreteNamedParent;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithAnnotatedConcreteParent;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithAnnotatedConcreteSuperclass;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithAnnotatedInterfaceParent;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithAnnotatedNamedInterfaceParent;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithAnnotatedSuperInterface;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithPlainAbstractParent;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithPlainConcreteParent;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithPlainConcreteParentImplementingInterface;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithPlainInterfaceChild;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainChildWithPlainInterfaceParent;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainConcreteParent;
import org.neo4j.ogm.domain.hierarchy.domain.plain.PlainSingleClass;
import org.neo4j.ogm.domain.hierarchy.domain.trans.PlainChildOfTransientInterface;
import org.neo4j.ogm.domain.hierarchy.domain.trans.PlainChildOfTransientParent;
import org.neo4j.ogm.domain.hierarchy.domain.trans.PlainClassWithTransientFields;
import org.neo4j.ogm.domain.hierarchy.domain.trans.TransientChildWithPlainConcreteParent;
import org.neo4j.ogm.domain.hierarchy.domain.trans.TransientSingleClass;
import org.neo4j.ogm.domain.hierarchy.domain.trans.TransientSingleClassWithId;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.GraphTestUtils;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class ClassHierarchiesIntegrationTest
extends MultiDriverTestClass {
    private Session session;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.hierarchy.domain"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void annotatedChildWithAnnotatedAbstractNamedParent() {
        this.session.save((Object)new AnnotatedChildWithAnnotatedAbstractNamedParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithAnnotatedAbstractNamedParent:Parent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithAnnotatedAbstractNamedParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedChildWithAnnotatedNamedInterfaceParent() {
        this.session.save((Object)new AnnotatedChildWithAnnotatedNamedInterfaceParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithAnnotatedNamedInterfaceParent:Parent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithAnnotatedNamedInterfaceParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedChildWithAnnotatedAbstractParent() {
        this.session.save((Object)new AnnotatedChildWithAnnotatedAbstractParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithAnnotatedAbstractParent:AnnotatedAbstractParent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithAnnotatedAbstractParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedChildWithAnnotatedInterfaceParent() {
        this.session.save((Object)new AnnotatedChildWithAnnotatedInterfaceParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithAnnotatedInterfaceParent:AnnotatedInterface)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithAnnotatedInterfaceParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedChildWithAnnotatedConcreteNamedParent() {
        this.session.save((Object)new AnnotatedChildWithAnnotatedConcreteNamedParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithAnnotatedConcreteNamedParent:Parent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithAnnotatedConcreteNamedParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedChildWithAnnotatedConcreteParent() {
        this.session.save((Object)new AnnotatedChildWithAnnotatedConcreteParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithAnnotatedConcreteParent:AnnotatedConcreteParent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithAnnotatedConcreteParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedChildWithPlainAbstractParent() {
        this.session.save((Object)new AnnotatedChildWithPlainAbstractParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithPlainAbstractParent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithPlainAbstractParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedChildWithPlainInterfaceParent() {
        this.session.save((Object)new AnnotatedChildWithPlainInterfaceParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithPlainInterfaceParent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithPlainInterfaceParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedChildWithPlainConcreteParent() {
        this.session.save((Object)new AnnotatedChildWithPlainConcreteParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithPlainConcreteParent:PlainConcreteParent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithPlainConcreteParent.class).iterator().next()).isNotNull();
    }

    @Test
    @Ignore(value="class hierarchies are invalid for this test: multiple classes labelled 'Child' and 'Parent'")
    public void annotatedNamedChildWithAnnotatedAbstractNamedParent() {
        this.session.save((Object)new AnnotatedNamedChildWithAnnotatedAbstractNamedParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Child:Parent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedNamedChildWithAnnotatedAbstractNamedParent.class).iterator().next()).isNotNull();
    }

    @Test
    @Ignore(value="class hierarchies are invalid for this test: multiple classes labelled 'Child' and 'Parent'")
    public void annotatedNamedChildWithAnnotatedNamedInterface() {
        this.session.save((Object)new AnnotatedNamedChildWithAnnotatedNamedInterfaceParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Child:Parent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedNamedChildWithAnnotatedNamedInterfaceParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedNamedChildWithAnnotatedAbstractParent() {
        this.session.save((Object)new AnnotatedNamedChildWithAnnotatedAbstractParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Child:AnnotatedAbstractParent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedNamedChildWithAnnotatedAbstractParent.class).iterator().next()).isNotNull();
    }

    @Test
    @Ignore(value="class hierarchies are invalid for this test: multiple classes labelled 'Child' and 'Parent'")
    public void annotatedNamedChildWithAnnotatedInterfaceParent() {
        this.session.save((Object)new AnnotatedNamedChildWithAnnotatedInterfaceParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Child:AnnotatedInterface)");
        Assertions.assertThat(this.session.loadAll(AnnotatedNamedChildWithAnnotatedInterfaceParent.class).iterator().next()).isNotNull();
    }

    @Test
    @Ignore(value="class hierarchies are invalid for this test: multiple classes labelled 'Child' and 'Parent'")
    public void annotatedNamedChildWithAnnotatedConcreteNamedParent() {
        this.session.save((Object)new AnnotatedNamedChildWithAnnotatedConcreteNamedParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Child:Parent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedNamedChildWithAnnotatedConcreteNamedParent.class).iterator().next()).isNotNull();
    }

    @Test
    @Ignore(value="class hierarchies are invalid for this test: multiple classes labelled 'Child' and 'Parent'")
    public void annotatedNamedChildWithAnnotatedConcreteParent() {
        this.session.save((Object)new AnnotatedNamedChildWithAnnotatedConcreteParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Child:AnnotatedConcreteParent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedNamedChildWithAnnotatedConcreteParent.class).iterator().next()).isNotNull();
    }

    @Test
    @Ignore(value="class hierarchies are invalid for this test: multiple classes labelled 'Child' and 'Parent'")
    public void annotatedNamedChildWithPlainAbstractParent() {
        this.session.save((Object)new AnnotatedNamedChildWithPlainAbstractParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Child)");
        Assertions.assertThat(this.session.loadAll(AnnotatedNamedChildWithPlainAbstractParent.class).iterator().next()).isNotNull();
    }

    @Test
    @Ignore(value="class hierarchies are invalid for this test: multiple classes labelled 'Child' and 'Parent'")
    public void annotatedNamedChildWithPlainInterfaceParent() {
        this.session.save((Object)new AnnotatedNamedChildWithPlainInterfaceParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Child)");
        Assertions.assertThat(this.session.loadAll(AnnotatedNamedChildWithPlainInterfaceParent.class).iterator().next()).isNotNull();
    }

    @Test
    @Ignore(value="class hierarchies are invalid for this test: multiple classes labelled 'Child' and 'Parent'")
    public void annotatedNamedChildWithPlainConcreteParent() {
        this.session.save((Object)new AnnotatedNamedChildWithPlainConcreteParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Child:PlainConcreteParent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedNamedChildWithPlainConcreteParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedNamedSingleClass() {
        this.session.save((Object)new AnnotatedNamedSingleClass());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Single)");
        Assertions.assertThat(this.session.loadAll(AnnotatedNamedSingleClass.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedSingleClass() {
        this.session.save((Object)new AnnotatedSingleClass());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedSingleClass)");
        Assertions.assertThat(this.session.loadAll(AnnotatedSingleClass.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithAnnotatedAbstractNamedParent() {
        this.session.save((Object)new PlainChildWithAnnotatedAbstractNamedParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithAnnotatedAbstractNamedParent:Parent)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithAnnotatedAbstractNamedParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithAnnotatedNamedInterfaceParent() {
        this.session.save((Object)new PlainChildWithAnnotatedNamedInterfaceParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithAnnotatedNamedInterfaceParent:Parent)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithAnnotatedNamedInterfaceParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithAnnotatedAbstractParent() {
        this.session.save((Object)new PlainChildWithAnnotatedAbstractParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithAnnotatedAbstractParent:AnnotatedAbstractParent)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithAnnotatedAbstractParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithAnnotatedInterfaceParent() {
        this.session.save((Object)new PlainChildWithAnnotatedInterfaceParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithAnnotatedInterfaceParent:AnnotatedInterface)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithAnnotatedInterfaceParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithAnnotatedConcreteNamedParent() {
        this.session.save((Object)new PlainChildWithAnnotatedConcreteNamedParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithAnnotatedConcreteNamedParent:Parent)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithAnnotatedConcreteNamedParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithAnnotatedConcreteParent() {
        this.session.save((Object)new PlainChildWithAnnotatedConcreteParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithAnnotatedConcreteParent:AnnotatedConcreteParent)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithAnnotatedConcreteParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithPlainAbstractParent() {
        this.session.save((Object)new PlainChildWithPlainAbstractParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithPlainAbstractParent)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithPlainAbstractParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithPlainInterfaceParent() {
        this.session.save((Object)new PlainChildWithPlainInterfaceParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithPlainInterfaceParent)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithPlainInterfaceParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithPlainConcreteParent() {
        this.session.save((Object)new PlainChildWithPlainConcreteParent());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithPlainConcreteParent:PlainConcreteParent)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithPlainConcreteParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithPlainConcreteParentImplementingInterface() {
        this.session.save((Object)new PlainChildWithPlainConcreteParentImplementingInterface());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithPlainConcreteParentImplementingInterface:PlainConcreteParent)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithPlainConcreteParentImplementingInterface.class).iterator().next()).isNotNull();
        Assertions.assertThat(this.session.loadAll(PlainConcreteParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithPlainInterfaceChild() {
        this.session.save((Object)new PlainChildWithPlainInterfaceChild());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithPlainInterfaceChild)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithPlainInterfaceChild.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithAnnotatedSuperInterface() {
        this.session.save((Object)new PlainChildWithAnnotatedSuperInterface());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithAnnotatedSuperInterface:AnnotatedInterface)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithAnnotatedSuperInterface.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedChildWithAnnotatedInterface() {
        this.session.save((Object)new AnnotatedChildWithAnnotatedInterface());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithAnnotatedInterface:AnnotatedInterfaceWithSingleImpl)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithAnnotatedInterface.class).iterator().next()).isNotNull();
        Assertions.assertThat(this.session.loadAll(AnnotatedInterfaceWithSingleImpl.class).iterator().next()).isNotNull();
        Assertions.assertThat((String)((AnnotatedInterfaceWithSingleImpl)this.session.loadAll(AnnotatedInterfaceWithSingleImpl.class).iterator().next()).getClass().getName()).isEqualTo((Object)"org.neo4j.ogm.domain.hierarchy.domain.annotated.AnnotatedChildWithAnnotatedInterface");
    }

    @Test
    public void plainChildWithAnnotatedSuperclass() {
        this.session.save((Object)new PlainChildWithAnnotatedConcreteSuperclass());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithAnnotatedConcreteSuperclass:PlainChildWithAnnotatedConcreteParent:AnnotatedConcreteParent)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithAnnotatedConcreteSuperclass.class).iterator().next()).isNotNull();
        Assertions.assertThat(this.session.loadAll(PlainChildWithAnnotatedConcreteParent.class).iterator().next()).isNotNull();
        Assertions.assertThat(this.session.loadAll(AnnotatedConcreteParent.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildWithAbstractParentAndAnnotatedSuperclass() {
        this.session.save((Object)new PlainChildWithAbstractParentAndAnnotatedSuperclass());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainChildWithAbstractParentAndAnnotatedSuperclass:AnnotatedSingleClass)");
        Assertions.assertThat(this.session.loadAll(PlainChildWithAbstractParentAndAnnotatedSuperclass.class).iterator().next()).isNotNull();
        Assertions.assertThat(this.session.loadAll(AnnotatedSingleClass.class).iterator().next()).isNotNull();
    }

    @Test
    public void annotatedChildWithMultipleAnnotatedInterfaces() {
        this.session.save((Object)new AnnotatedChildWithMultipleAnnotatedInterfaces());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:AnnotatedChildWithMultipleAnnotatedInterfaces:AnnotatedInterface:Parent)");
        Assertions.assertThat(this.session.loadAll(AnnotatedChildWithMultipleAnnotatedInterfaces.class).iterator().next()).isNotNull();
        Assertions.assertThat((Iterable)this.session.loadAll(AnnotatedInterface.class)).hasSize(1);
        Assertions.assertThat((Iterable)this.session.loadAll(AnnotatedNamedInterfaceParent.class)).hasSize(1);
    }

    @Test
    public void plainSingleClass() {
        this.session.save((Object)new PlainSingleClass());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainSingleClass)");
        Assertions.assertThat(this.session.loadAll(PlainSingleClass.class).iterator().next()).isNotNull();
    }

    @Test
    public void plainChildOfTransientParent() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.session.save((Object)new PlainChildOfTransientParent())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("is not a valid entity class");
        try (Transaction tx = ClassHierarchiesIntegrationTest.getGraphDatabaseService().beginTx();){
            Assertions.assertThat((boolean)GraphTestUtils.allNodes((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService()).iterator().hasNext()).isFalse();
            tx.success();
        }
    }

    @Test
    public void plainChildOfTransientInterface() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.session.save((Object)new PlainChildOfTransientInterface())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("is not a valid entity class");
        try (Transaction tx = ClassHierarchiesIntegrationTest.getGraphDatabaseService().beginTx();){
            Assertions.assertThat((boolean)GraphTestUtils.allNodes((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService()).iterator().hasNext()).isFalse();
            tx.success();
        }
    }

    @Test
    public void transientChildWithPlainConcreteParent() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.session.save((Object)new TransientChildWithPlainConcreteParent())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("is not a valid entity class");
        try (Transaction tx = ClassHierarchiesIntegrationTest.getGraphDatabaseService().beginTx();){
            Assertions.assertThat((boolean)GraphTestUtils.allNodes((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService()).iterator().hasNext()).isFalse();
            tx.success();
        }
    }

    @Test
    public void transientSingleClass() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.session.save((Object)new TransientSingleClass())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("is not a valid entity class");
    }

    @Test
    public void transientSingleClassWithId() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.session.save((Object)new TransientSingleClassWithId())).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("is not a valid entity class");
        try (Transaction tx = ClassHierarchiesIntegrationTest.getGraphDatabaseService().beginTx();){
            Assertions.assertThat((boolean)GraphTestUtils.allNodes((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService()).iterator().hasNext()).isFalse();
            tx.success();
        }
    }

    @Test
    public void plainClassWithTransientFields() {
        PlainClassWithTransientFields toSave = new PlainClassWithTransientFields();
        toSave.setAnotherTransientField(new PlainSingleClass());
        toSave.setTransientField(new PlainChildOfTransientParent());
        toSave.setYetAnotherTransientField(new PlainSingleClass());
        this.session.save((Object)toSave);
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:PlainClassWithTransientFields)");
        Assertions.assertThat(this.session.loadAll(PlainClassWithTransientFields.class).iterator().next()).isNotNull();
    }

    @Test
    public void shouldNotBeAbleToLoadClassOfWrongType() {
        this.session.save((Object)new AnnotatedNamedSingleClass());
        Assertions.assertThat((boolean)this.session.loadAll(PlainSingleClass.class).iterator().hasNext()).isFalse();
    }

    @Test
    public void shouldSaveHierarchy() {
        this.session.save((Object)new Female("Daniela"));
        this.session.save((Object)new Male("Michal"));
        this.session.save((Object)new Bloke("Adam"));
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Female:Person {name:'Daniela'}),(:Male:Person {name:'Michal'}),(:Bloke:Male:Person {name:'Adam'})");
    }

    @Test
    public void shouldSaveHierarchy2() {
        this.session.save(Arrays.asList(new Female("Daniela"), new Male("Michal"), new Bloke("Adam")));
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Female:Person {name:'Daniela'}),(:Male:Person {name:'Michal'}),(:Bloke:Male:Person {name:'Adam'})");
    }

    @Test
    public void shouldReadHierarchyAndRetrieveBySuperclass() {
        Female daniela = new Female("Daniela");
        Male michal = new Male("Michal");
        Bloke adam = new Bloke("Adam");
        this.session.save(Arrays.asList(daniela, michal, adam));
        this.session.query("CREATE (:Test)", Collections.emptyMap());
        Collection entities = this.session.loadAll(Entity.class);
        Collection people = this.session.loadAll(Person.class);
        Collection males = this.session.loadAll(Male.class);
        Collection females = this.session.loadAll(Female.class);
        Collection blokes = this.session.loadAll(Bloke.class);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)entities.isEmpty()).as("Shouldn't be able to load by non-annotated, abstract classes", new Object[0])).isTrue();
        Assertions.assertThat((Iterable)people).hasSize(3);
        Assertions.assertThat((long)this.session.countEntitiesOfType(Person.class)).isEqualTo((long)people.size());
        Assertions.assertThat((boolean)people.containsAll(Arrays.asList(daniela, michal, adam))).isTrue();
        Assertions.assertThat((Iterable)males).hasSize(2);
        Assertions.assertThat((boolean)males.containsAll(Arrays.asList(michal, adam))).isTrue();
        Assertions.assertThat((Iterable)females).hasSize(1);
        Assertions.assertThat((long)this.session.countEntitiesOfType(Female.class)).isEqualTo((long)females.size());
        Assertions.assertThat((boolean)females.contains(daniela)).isTrue();
        Assertions.assertThat((Iterable)blokes).hasSize(1);
        Assertions.assertThat((boolean)blokes.contains(adam)).isTrue();
    }

    @Test
    public void shouldNotCountAbstractNonAnnotatedClass() {
        Female daniela = new Female("Daniela");
        Male michal = new Male("Michal");
        Bloke adam = new Bloke("Adam");
        this.session.save(Arrays.asList(daniela, michal, adam));
        this.session.query("CREATE (:Test)", Collections.emptyMap());
        ((AbstractLongAssert)Assertions.assertThat((long)this.session.countEntitiesOfType(Entity.class)).as("Shouldn't be able to count by non-annotated, abstract classes", new Object[0])).isEqualTo(0L);
        Assertions.assertThat((long)this.session.countEntitiesOfType(Person.class)).isEqualTo(3L);
        Assertions.assertThat((long)this.session.countEntitiesOfType(Male.class)).isEqualTo(2L);
        Assertions.assertThat((long)this.session.countEntitiesOfType(Female.class)).isEqualTo(1L);
        Assertions.assertThat((long)this.session.countEntitiesOfType(Bloke.class)).isEqualTo(1L);
    }

    @Test
    public void shouldNotDeleteAbstractNonAnnotatedClass() {
        Female daniela = new Female("Daniela");
        Male michal = new Male("Michal");
        Bloke adam = new Bloke("Adam");
        this.session.save(Arrays.asList(daniela, michal, adam));
        this.session.query("CREATE (:Test)", Collections.emptyMap());
        this.session.deleteAll(Entity.class);
        Assertions.assertThat((long)this.session.countEntitiesOfType(Person.class)).isEqualTo(3L);
        Assertions.assertThat((Iterable)this.session.query("MATCH (t:Test) RETURN t", Collections.emptyMap())).hasSize(1);
    }

    @Test
    public void shouldReadHierarchy2() {
        ClassHierarchiesIntegrationTest.getGraphDatabaseService().execute("CREATE (:Female:Person:Entity {name:'Daniela'}),(:Male:Person:Entity {name:'Michal'}),(:Bloke:Male:Person:Entity {name:'Adam'})");
        Female daniela = new Female("Daniela");
        Male michal = new Male("Michal");
        Bloke adam = new Bloke("Adam");
        Collection entities = this.session.loadAll(Entity.class);
        Collection people = this.session.loadAll(Person.class);
        Collection males = this.session.loadAll(Male.class);
        Collection females = this.session.loadAll(Female.class);
        Collection blokes = this.session.loadAll(Bloke.class);
        Assertions.assertThat((Iterable)entities).isEmpty();
        Assertions.assertThat((Iterable)people).hasSize(3);
        Assertions.assertThat((boolean)people.containsAll(Arrays.asList(daniela, michal, adam))).isTrue();
        Assertions.assertThat((Iterable)males).hasSize(2);
        Assertions.assertThat((boolean)males.containsAll(Arrays.asList(michal, adam))).isTrue();
        Assertions.assertThat((Iterable)females).hasSize(1);
        Assertions.assertThat((boolean)females.contains(daniela)).isTrue();
        Assertions.assertThat((Iterable)blokes).hasSize(1);
        Assertions.assertThat((boolean)blokes.contains(adam)).isTrue();
    }

    @Test
    public void shouldReadHierarchy3() {
        ClassHierarchiesIntegrationTest.getGraphDatabaseService().execute("CREATE (:Female:Person {name:'Daniela'}),(:Male:Person {name:'Michal'}),(:Bloke:Male:Person {name:'Adam'})");
        Female daniela = new Female("Daniela");
        Male michal = new Male("Michal");
        Bloke adam = new Bloke("Adam");
        Collection people = this.session.loadAll(Person.class);
        Collection males = this.session.loadAll(Male.class);
        Collection females = this.session.loadAll(Female.class);
        Collection blokes = this.session.loadAll(Bloke.class);
        Assertions.assertThat((Iterable)people).hasSize(3);
        Assertions.assertThat((boolean)people.containsAll(Arrays.asList(daniela, michal, adam))).isTrue();
        Assertions.assertThat((Iterable)males).hasSize(2);
        Assertions.assertThat((boolean)males.containsAll(Arrays.asList(michal, adam))).isTrue();
        Assertions.assertThat((Iterable)females).hasSize(1);
        Assertions.assertThat((boolean)females.contains(daniela)).isTrue();
        Assertions.assertThat((Iterable)blokes).hasSize(1);
        Assertions.assertThat((boolean)blokes.contains(adam)).isTrue();
    }

    @Test
    public void shouldReadHierarchy4() {
        ClassHierarchiesIntegrationTest.getGraphDatabaseService().execute("CREATE (:Female {name:'Daniela'}),(:Male {name:'Michal'}),(:Bloke:Male {name:'Adam'})");
        Female daniela = new Female("Daniela");
        Male michal = new Male("Michal");
        Bloke adam = new Bloke("Adam");
        Collection males = this.session.loadAll(Male.class);
        Collection females = this.session.loadAll(Female.class);
        Collection blokes = this.session.loadAll(Bloke.class);
        Assertions.assertThat((Iterable)males).hasSize(2);
        Assertions.assertThat((boolean)males.containsAll(Arrays.asList(michal, adam))).isTrue();
        Assertions.assertThat((Iterable)females).hasSize(1);
        Assertions.assertThat((boolean)females.contains(daniela)).isTrue();
        Assertions.assertThat((Iterable)blokes).hasSize(1);
        Assertions.assertThat((boolean)blokes.contains(adam)).isTrue();
    }

    @Test
    public void shouldReadHierarchy5() {
        ClassHierarchiesIntegrationTest.getGraphDatabaseService().execute("CREATE (:Female {name:'Daniela'}),(:Male {name:'Michal'}),(:Bloke {name:'Adam'})");
        Female daniela = new Female("Daniela");
        Male michal = new Male("Michal");
        Bloke adam = new Bloke("Adam");
        Collection males = this.session.loadAll(Male.class);
        Collection females = this.session.loadAll(Female.class);
        Collection blokes = this.session.loadAll(Bloke.class);
        Assertions.assertThat((Iterable)males).hasSize(1);
        Assertions.assertThat((boolean)males.containsAll(Arrays.asList(michal))).isTrue();
        Assertions.assertThat((Iterable)females).hasSize(1);
        Assertions.assertThat((boolean)females.contains(daniela)).isTrue();
        Assertions.assertThat((Iterable)blokes).hasSize(1);
        Assertions.assertThat((boolean)blokes.contains(adam)).isTrue();
    }

    @Test
    public void shouldNotReadHierarchy() {
        ClassHierarchiesIntegrationTest.getGraphDatabaseService().execute("CREATE (:Person {name:'Daniela'})");
        Assertions.assertThat((Iterable)this.session.loadAll(Person.class)).isEmpty();
    }

    @Test
    public void shouldLeaveExistingLabelsAlone() {
        ClassHierarchiesIntegrationTest.getGraphDatabaseService().execute("CREATE (:Female:Person:GoldMember {name:'Daniela'})");
        this.session.save(this.session.loadAll(Female.class).iterator().next());
        GraphTestUtils.assertSameGraph((GraphDatabaseService)ClassHierarchiesIntegrationTest.getGraphDatabaseService(), (String)"CREATE (:Female:Person:GoldMember {name:'Daniela'})");
    }

    @Test
    public void shouldFailWithConflictingHierarchies() {
        ClassHierarchiesIntegrationTest.getGraphDatabaseService().execute("CREATE (:Female:Person {name:'Daniela'})");
        SessionFactory sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.hierarchy.domain", "org.neo4j.ogm.domain.hierarchy.conflicting"});
        this.session = sessionFactory.openSession();
        Assertions.assertThat((Iterable)this.session.loadAll(Female.class)).isEmpty();
    }

    @Test
    public void shouldLoadRelatedSuperclasses() {
        ClassHierarchiesIntegrationTest.getGraphDatabaseService().execute("CREATE (f1:Female:Person {name:'f1'}),(m1:Male:Person {name:'m1'}),(c1:Female:Person {name:'c1'}),(m1)-[:CHILD]->(c1)");
        Male m1 = (Male)this.session.loadAll(Male.class).iterator().next();
        Assertions.assertThat((Object)m1).isNotNull();
        Assertions.assertThat((String)m1.getName()).isEqualTo((Object)"m1");
        Assertions.assertThat((String)m1.getChildren().iterator().next().getName()).isEqualTo((Object)"c1");
    }

    @Test
    public void shouldLoadImplementationWhenParentClassIsQueriedDirectSubclass() {
        UUID uuid = UUID.randomUUID();
        SubEntity subEntity = new SubEntity();
        subEntity.setMyId(uuid);
        subEntity.setName("test");
        this.session.save((Object)subEntity);
        this.session.clear();
        RootEntity rootEntity = (RootEntity)this.session.load(RootEntity.class, (Serializable)uuid);
        Assertions.assertThat((Object)rootEntity).isNotNull();
    }

    @Test
    public void shouldLoadImplementationWhenParentClassIsQueriedDeepSubclass() {
        UUID uuid = UUID.randomUUID();
        SubSubEntity subsubEntity = new SubSubEntity();
        subsubEntity.setMyId(uuid);
        subsubEntity.setName("test");
        this.session.save((Object)subsubEntity);
        this.session.clear();
        RootEntity rootEntity = (RootEntity)this.session.load(RootEntity.class, (Serializable)uuid);
        Assertions.assertThat((Object)rootEntity).isNotNull();
    }

    @Test
    public void shouldLoadImplementationWhenParentClassIsQueriedDeepSubclasWithsMostBasicEntity() {
        UUID uuid = UUID.randomUUID();
        SubSubEntity subsubEntity = new SubSubEntity();
        subsubEntity.setMyId(uuid);
        subsubEntity.setName("test");
        this.session.save((Object)subsubEntity);
        this.session.clear();
        MostBasicEntity rootEntity = (MostBasicEntity)this.session.load(MostBasicEntity.class, (Serializable)uuid);
        Assertions.assertThat((Object)rootEntity).isNull();
    }

    @Test
    public void shouldLoadImplementationWhenParentClassIsQueriedLoadAll() {
        UUID uuid = UUID.randomUUID();
        SubSubEntity subsubEntity = new SubSubEntity();
        subsubEntity.setMyId(uuid);
        subsubEntity.setName("test");
        this.session.save((Object)subsubEntity);
        this.session.clear();
        Collection rootEntity = this.session.loadAll(RootEntity.class);
        Assertions.assertThat((Iterable)rootEntity).isNotEmpty();
    }

    @Test
    public void shouldLoadImplementationWhenParentClassIsQueriedLoadAllWithAbstractNonAnnotatedBaseClass() {
        UUID uuid = UUID.randomUUID();
        SubSubEntity subsubEntity = new SubSubEntity();
        subsubEntity.setMyId(uuid);
        subsubEntity.setName("test");
        this.session.save((Object)subsubEntity);
        this.session.clear();
        Collection rootEntity = this.session.loadAll(MostBasicEntity.class);
        Assertions.assertThat((Iterable)rootEntity).isEmpty();
    }
}

