/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.types.convertible;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.ogm.domain.social.Immortal;
import org.neo4j.ogm.domain.social.Individual;
import org.neo4j.ogm.exception.core.MappingException;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class NumericConversionTest
extends MultiDriverTestClass {
    private Session session;

    @Before
    public void init() throws IOException {
        this.session = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.social"}).openSession();
    }

    @After
    public void destroy() {
        this.session.purgeDatabase();
    }

    @Test
    public void shouldSaveAndRetrieveNumbers() {
        Individual individual = new Individual();
        individual.setName("Gary");
        individual.setAge(36);
        individual.setBankBalance(99.99f);
        individual.setCode((byte)10);
        individual.setNumberOfPets(301);
        individual.setNumberOfShoes((byte)101);
        individual.setDistanceFromZoo(Float.valueOf(215.5f));
        individual.setFavouriteRadioStations(new Vector<Double>(Arrays.asList(97.4, 105.4, 98.2)));
        individual.primitiveFloatArray = new float[]{5.5f, 6.6f};
        individual.setPrimitiveByteArray(new byte[]{1, 2, 3, 4, 5});
        individual.floatArray = new Float[]{Float.valueOf(1.1f), Float.valueOf(2.2f)};
        individual.integerArray = new Integer[]{1000, 2000, 3000};
        individual.integerCollection = Arrays.asList(100, 200);
        individual.setFloatCollection(Arrays.asList(Float.valueOf(10.5f), Float.valueOf(20.5f), Float.valueOf(30.5f)));
        individual.setByteCollection(Arrays.asList(Byte.valueOf("1"), Byte.valueOf("2")));
        this.session.save((Object)individual);
        this.session.clear();
        individual = (Individual)this.session.load(Individual.class, (Serializable)individual.getId());
        Assertions.assertThat((String)individual.getName()).isEqualTo((Object)"Gary");
        Assertions.assertThat((int)individual.getAge()).isEqualTo(36);
        Assertions.assertThat((float)individual.getBankBalance()).isEqualTo(99.99f, Assertions.within((Float)Float.valueOf(0.0f)));
        Assertions.assertThat((byte)individual.getCode()).isEqualTo((byte)10);
        Assertions.assertThat((Integer)individual.getNumberOfPets()).isEqualTo((Object)301);
        Assertions.assertThat((Byte)individual.getNumberOfShoes()).isEqualTo((Object)101);
        Assertions.assertThat((Float)individual.getDistanceFromZoo()).isEqualTo((Object)Float.valueOf(215.5f));
        Assertions.assertThat(individual.getFavouriteRadioStations()).hasSize(3);
        Assertions.assertThat(individual.getFavouriteRadioStations()).contains((Object[])new Double[]{97.4, 98.2, 105.4});
        Assertions.assertThat((float[])individual.primitiveFloatArray).hasSize(2);
        Assertions.assertThat((byte[])individual.getPrimitiveByteArray()).hasSize(5);
        Assertions.assertThat((Object[])individual.floatArray).hasSize(2);
        Assertions.assertThat((Object[])individual.integerArray).hasSize(3);
        Assertions.assertThat(individual.integerCollection).hasSize(2);
        Assertions.assertThat(individual.getFloatCollection()).hasSize(3);
        Assertions.assertThat(individual.getByteCollection()).hasSize(2);
    }

    @Test(expected=MappingException.class)
    public void shouldFailForPrimitiveIntOverflow() {
        this.session.query("CREATE (i:Individual {name: 'Gary', age:21474836471})", Collections.EMPTY_MAP);
        this.session.loadAll(Individual.class).iterator().next();
    }

    @Test(expected=MappingException.class)
    public void shouldFailForPrimitiveFloatOverflow() {
        this.session.query("CREATE (i:Individual {name: 'Gary', bankBalance:1.7976931348623157E308})", Collections.EMPTY_MAP);
        this.session.loadAll(Individual.class).iterator().next();
    }

    @Test(expected=MappingException.class)
    public void shouldFailForPrimitiveByteOverflow() {
        this.session.query("CREATE (i:Individual {name: 'Gary', code:1271})", Collections.EMPTY_MAP);
        this.session.loadAll(Individual.class).iterator().next();
    }

    @Test(expected=MappingException.class)
    public void shouldFailForIntegerOverflow() {
        this.session.query("CREATE (i:Individual {name: 'Gary', numberOfPets:21474836471})", Collections.EMPTY_MAP);
        this.session.loadAll(Individual.class).iterator().next();
    }

    @Test(expected=MappingException.class)
    public void shouldFailForFloatOverflow() {
        this.session.query("CREATE (i:Individual {name: 'Gary', distanceFromZoo:1.7976931348623157E308})", Collections.EMPTY_MAP);
        this.session.loadAll(Individual.class).iterator().next();
    }

    @Test(expected=MappingException.class)
    public void shouldFailForByteOverflow() {
        this.session.query("CREATE (i:Individual {name: 'Gary', numberOfShoes:1271})", Collections.EMPTY_MAP);
        this.session.loadAll(Individual.class).iterator().next();
    }

    @Test(expected=MappingException.class)
    public void shouldFailForByteAsFloat() {
        this.session.query("CREATE (i:Individual {name: 'Gary', numberOfShoes: 3.5})", Collections.EMPTY_MAP);
        this.session.loadAll(Individual.class).iterator().next();
    }

    @Test
    public void shouldLoadDoubleWhenDecimalIsMissing() {
        this.session.query("CREATE (i:Individual {name: 'Gary', maxTemp: 31})", Collections.EMPTY_MAP);
        Individual i = (Individual)this.session.loadAll(Individual.class).iterator().next();
        Assertions.assertThat((Double)i.getMaxTemp()).isEqualTo((Object)new Double(31.0));
    }

    @Test
    public void shouldConvertToLongInsteadOfCasting() {
        Individual individual = new Individual();
        individual.setLongCollection(Arrays.asList(1L, 2L, 3L));
        this.session.save((Object)individual);
        this.session.clear();
        individual = (Individual)this.session.load(Individual.class, (Serializable)individual.getId());
        for (Number number : individual.getLongCollection()) {
            Assertions.assertThat((boolean)(number instanceof Long)).isTrue();
        }
    }

    @Test
    public void shouldMapInitializedLongList() throws Exception {
        Immortal immortal = new Immortal("John", "Doe");
        this.session.save((Object)immortal);
        this.session.clear();
        Result result = this.session.query("MATCH (m:Immortal) WHERE ID(m) = {id} RETURN m", Collections.singletonMap("id", immortal.getId()));
        Assertions.assertThat((Iterable)result).isNotNull();
    }
}

