/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.types.properties;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.ogm.domain.properties.UserWithEnumMap;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class EnumMapPropertiesTest
extends MultiDriverTestClass {
    private static Session session;

    @BeforeClass
    public static void init() throws IOException {
        session = new SessionFactory(driver, new String[]{UserWithEnumMap.class.getName()}).openSession();
    }

    @Before
    public void setUp() throws Exception {
        session.purgeDatabase();
    }

    @Test
    public void shouldMapMapAttributeToProperties() throws Exception {
        UserWithEnumMap user = new UserWithEnumMap("Frantisek");
        user.putMyProperty(UserWithEnumMap.UserProperties.CITY, "London");
        user.putMyProperty(UserWithEnumMap.UserProperties.ZIP_CODE, "SW1A 1AA");
        session.save((Object)user);
        try (Transaction tx = EnumMapPropertiesTest.getGraphDatabaseService().beginTx();){
            Node userNode = EnumMapPropertiesTest.getGraphDatabaseService().getNodeById(user.getId().longValue());
            ((MapAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)userNode.getAllProperties()).hasSize(3)).containsEntry((Object)"name", (Object)"Frantisek")).containsEntry((Object)"myProperties.CITY", (Object)"London")).containsEntry((Object)"myProperties.ZIP_CODE", (Object)"SW1A 1AA");
            tx.success();
        }
    }

    @Test
    public void shouldMapNodePropertiesToPropertiesAttribute() throws Exception {
        session.query("CREATE (u:User {`name`:'Frantisek', `myProperties.CITY`:'London', `myProperties.ZIP_CODE`:'SW1A 1AA'})", Collections.emptyMap());
        UserWithEnumMap user = (UserWithEnumMap)session.loadAll(UserWithEnumMap.class).iterator().next();
        ((MapAssert)((MapAssert)Assertions.assertThat(user.getMyProperties()).hasSize(2)).containsEntry((Object)UserWithEnumMap.UserProperties.CITY, (Object)"London")).containsEntry((Object)UserWithEnumMap.UserProperties.ZIP_CODE, (Object)"SW1A 1AA");
    }
}

