/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.persistence.types.properties;

import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.domain.properties.Place;
import org.neo4j.ogm.domain.properties.User;
import org.neo4j.ogm.domain.properties.Visit;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class RelationshipEntityPropertiesTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void init() throws IOException {
        String[] classes = new String[]{User.class.getName(), Visit.class.getName(), Place.class.getName()};
        sessionFactory = new SessionFactory(driver, classes);
    }

    @Before
    public void setUp() throws Exception {
        this.session = sessionFactory.openSession();
        this.session.purgeDatabase();
    }

    @Test
    public void shouldSaveAndLoadProperties() throws Exception {
        User user = new User();
        Place place = new Place();
        Visit visit = new Visit(user, place);
        user.addVisit(visit);
        visit.putProperty("note", "some random note about a visit to a place");
        this.session.save((Object)user);
        this.session.clear();
        Visit loaded = (Visit)this.session.load(Visit.class, (Serializable)visit.getId());
        Assertions.assertThat(loaded.getProperties()).containsEntry((Object)"note", (Object)"some random note about a visit to a place");
    }

    @Test
    public void shouldBeAbleToDeletePropertiesOnRelationshipsAgain() {
        User user = new User();
        user.setName("James Bond");
        Visit visit = new Visit();
        HashMap<String, String> initialProperties = new HashMap<String, String>();
        initialProperties.put("a", "007");
        initialProperties.put("b", "4711");
        visit.setUser(user);
        visit.setProperties(initialProperties);
        visit.setPlace(new Place());
        user.setVisits(Collections.singleton(visit));
        this.session.save((Object)user);
        this.session.clear();
        User loadedUser = (User)this.session.load(User.class, (Serializable)user.getId());
        Assertions.assertThat(loadedUser.getVisits()).hasSize(1);
        Visit loadedVisit = (Visit)loadedUser.getVisits().stream().findFirst().get();
        Assertions.assertThat(loadedVisit.getProperties()).containsOnly(new Map.Entry[]{Assertions.entry((Object)"a", (Object)"007"), Assertions.entry((Object)"b", (Object)"4711")});
        loadedVisit.getProperties().remove("b");
        this.session.save((Object)loadedUser);
        this.session.clear();
        loadedUser = (User)this.session.load(User.class, (Serializable)user.getId());
        loadedVisit = (Visit)loadedUser.getVisits().stream().findFirst().get();
        Assertions.assertThat(loadedVisit.getProperties()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"a", (Object)"007")});
    }
}

