/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.concurrency.World;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.testutil.MultiDriverTestClass;

public class ConcurrentSessionTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;
    boolean failed = false;

    @BeforeClass
    public static void oneTimeSetUp() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.concurrency"});
    }

    @Before
    public void init() {
        this.session = sessionFactory.openSession();
    }

    @Test
    public void multipleThreadsResultsGetMixedUp() throws Exception {
        World world1 = new World("world 1", 1);
        this.session.save((Object)world1, 0);
        World world2 = new World("world 2", 2);
        this.session.save((Object)world2, 0);
        int iterations = 1000;
        ExecutorService service = Executors.newFixedThreadPool(2);
        CountDownLatch countDownLatch = new CountDownLatch(iterations * 2);
        for (int i = 0; i < iterations; ++i) {
            service.execute(() -> {
                World world = (World)this.session.loadAll(World.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"world 1")).iterator().next();
                if (!"world 1".equals(world.getName())) {
                    this.failed = true;
                }
                countDownLatch.countDown();
            });
            service.execute(() -> {
                World world = (World)this.session.loadAll(World.class, new Filter("name", ComparisonOperator.EQUALS, (Object)"world 2")).iterator().next();
                if (!"world 2".equals(world.getName())) {
                    this.failed = true;
                }
                countDownLatch.countDown();
            });
        }
        countDownLatch.await();
        Assertions.assertThat((boolean)this.failed).isFalse();
    }
}

