/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.domain.music.Album;
import org.neo4j.ogm.domain.typed_relationships.SomeEntity;
import org.neo4j.ogm.domain.typed_relationships.TypedEntity;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.SessionFactory;
import org.neo4j.ogm.session.delegates.LoadByTypeDelegate;
import org.neo4j.ogm.testutil.MultiDriverTestClass;
import org.neo4j.ogm.typeconversion.DateLongConverter;
import org.neo4j.ogm.typeconversion.DateStringConverter;

public class SessionDelegateIntegrationTest
extends MultiDriverTestClass {
    private static SessionFactory sessionFactory;
    private Session session;

    @BeforeClass
    public static void createSessionFactory() {
        sessionFactory = new SessionFactory(driver, new String[]{"org.neo4j.ogm.domain.music", "org.neo4j.ogm.domain.typed_relationships"});
    }

    @Before
    public void init() throws IOException {
        this.session = sessionFactory.openSession();
    }

    @Test
    public void shouldPickupCorrectFieldInfo() {
        Date filterValue = new Date();
        Filter recordedAtFilter = new Filter("recordedAt", ComparisonOperator.GREATER_THAN, (Object)filterValue);
        Filter releasedFilter = new Filter("released", ComparisonOperator.GREATER_THAN, (Object)filterValue);
        Filter releasedAtFilter = new Filter("releasedAt", ComparisonOperator.GREATER_THAN, (Object)filterValue);
        Filter enteredChartAtFilter = new Filter("enteredChartAt", ComparisonOperator.GREATER_THAN, (Object)filterValue);
        Filter leftChartFilter = new Filter("leftChart", ComparisonOperator.GREATER_THAN, (Object)filterValue);
        Filter leftChartAtFilter = new Filter("leftChartAt", ComparisonOperator.GREATER_THAN, (Object)filterValue);
        LoadByTypeDelegate sessionDelegate = new LoadByTypeDelegate((Neo4jSession)this.session);
        sessionDelegate.resolvePropertyAnnotations(Album.class, Arrays.asList(recordedAtFilter, releasedFilter, releasedAtFilter, enteredChartAtFilter, leftChartFilter, leftChartAtFilter));
        Assertions.assertThat((Object)recordedAtFilter.getPropertyConverter()).as("Property converter %s should be used for Date fields without @Property-annotation", new Object[]{DateStringConverter.class}).isInstanceOf(DateStringConverter.class);
        Assertions.assertThat((Object)releasedFilter.getPropertyConverter()).as("Property converter %s should be used for Date fields with @Property-annotation referred by field name", new Object[]{DateStringConverter.class}).isInstanceOf(DateStringConverter.class);
        Assertions.assertThat((Object)releasedAtFilter.getPropertyConverter()).as("Property converter %s should be used for Date fields with @Property-annotation referred by property name", new Object[]{DateStringConverter.class}).isInstanceOf(DateStringConverter.class);
        Assertions.assertThat((Object)enteredChartAtFilter.getPropertyConverter()).as("Specified provider should be used", new Object[0]).isInstanceOf(DateLongConverter.class);
        Assertions.assertThat((Object)leftChartFilter.getPropertyConverter()).as("Specified provider should be used", new Object[0]).isInstanceOf(DateLongConverter.class);
        Assertions.assertThat((Object)leftChartAtFilter.getPropertyConverter()).as("Specified provider should be used", new Object[0]).isInstanceOf(DateLongConverter.class);
    }

    @Test
    public void shouldDealWithTypedRelationships() {
        SomeEntity someEntity = new SomeEntity();
        someEntity.setThing(new TypedEntity<Double>(42.21));
        someEntity.setMoreThings(Arrays.asList(new TypedEntity<String>("Die halbe Wahrheit"), new TypedEntity<String>("21")));
        someEntity.setSomeOtherStuff(Arrays.asList("A", "B", "C"));
        this.session.save((Object)someEntity);
        this.session.clear();
        someEntity = (SomeEntity)this.session.load(SomeEntity.class, (Serializable)someEntity.getId());
        Assertions.assertThat(someEntity.getThing().getSomeThing()).isEqualTo((Object)42.21);
        Assertions.assertThat(someEntity.getMoreThings()).extracting(t -> (String)t.getSomeThing()).containsExactlyInAnyOrder((Object[])new String[]{"Die halbe Wahrheit", "21"});
        Assertions.assertThat(someEntity.getSomeOtherStuff()).containsExactlyInAnyOrder((Object[])new String[]{"A", "B", "C"});
    }
}

