/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.RelationshipQueryStatements;

public class RelationshipEntityQueryPagingTest {
    private final QueryStatements query = new RelationshipQueryStatements();

    @Test
    public void testFindByLabel() throws Exception {
        Assertions.assertThat((String)this.query.findByType("ORBITS", 3).setPagination(new Pagination(1, 10)).getStatement()).isEqualTo((Object)"MATCH ()-[r0:`ORBITS`]-()  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m SKIP 10 LIMIT 10 MATCH p1 = (n)-[*0..3]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..3]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByProperty() throws Exception {
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter("distance", ComparisonOperator.EQUALS, (Object)60.2)), 1).setPagination(new Pagination(0, 4)).getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`ORBITS`]->(m) WHERE r0.`distance` = { `distance_0` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m SKIP 0 LIMIT 4 MATCH p1 = (n)-[*0..1]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..1]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }
}

