/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.CypherQuery;
import org.neo4j.ogm.session.request.strategy.AggregateStatements;
import org.neo4j.ogm.session.request.strategy.impl.CountStatements;

public class CountStatementsTest {
    private AggregateStatements statements = new CountStatements();

    @Test
    public void testCountNodesWithLabel() throws Exception {
        Assertions.assertThat((String)this.statements.countNodes(Collections.singleton("Person")).getStatement()).isEqualTo((Object)"MATCH (n:`Person`) RETURN COUNT(n)");
    }

    @Test
    public void testCountNodesWithMultipleLabels() throws Exception {
        Assertions.assertThat((String)this.statements.countNodes(Arrays.asList("Person", "Candidate")).getStatement()).isEqualTo((Object)"MATCH (n:`Person`:`Candidate`) RETURN COUNT(n)");
    }

    @Test
    public void testCountNodesWithLabelAndFilters() throws Exception {
        CypherQuery query = this.statements.countNodes("Person", (Iterable)new Filters().add(new Filter("name", ComparisonOperator.EQUALS, (Object)"Jim")));
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n:`Person`) WHERE n.`name` = { `name_0` } WITH n RETURN COUNT(n)");
        Assertions.assertThat((String)query.getParameters().toString()).isEqualTo((Object)"{name_0=Jim}");
    }

    @Test
    public void testCountEdgesWithTypeAndFilters() throws Exception {
        CypherQuery query = this.statements.countEdges("INFLUENCE", (Iterable)new Filters().add(new Filter("score", ComparisonOperator.EQUALS, (Object)-12.2)));
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`INFLUENCE`]->(m) WHERE r0.`score` = { `score_0` }  RETURN COUNT(r0)");
        Assertions.assertThat((String)query.getParameters().toString()).isEqualTo((Object)"{score_0=-12.2}");
    }

    @Test
    public void testCountEdgesWithSpecificPath() throws Exception {
        Assertions.assertThat((String)this.statements.countEdges("StartNode", "TYPE", "EndNode").getStatement()).isEqualTo((Object)"MATCH (:`StartNode`)-[r0:`TYPE`]->(:`EndNode`) RETURN COUNT(r0)");
    }
}

