/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request.strategy.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.PagingAndSortingQuery;
import org.neo4j.ogm.exception.core.InvalidDepthException;
import org.neo4j.ogm.exception.core.MissingOperatorException;
import org.neo4j.ogm.session.request.strategy.LoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.request.strategy.impl.PathRelationshipLoadClauseBuilder;
import org.neo4j.ogm.session.request.strategy.impl.RelationshipQueryStatements;

public class RelationshipQueryStatementsTest {
    private final QueryStatements<Long> query = new RelationshipQueryStatements();
    private final QueryStatements<String> primaryQuery = new RelationshipQueryStatements("uuid", (LoadClauseBuilder)new PathRelationshipLoadClauseBuilder());

    @Test
    public void testFindOne() throws Exception {
        Assertions.assertThat((String)this.query.findOne((Serializable)Long.valueOf(0L), 2).getStatement()).isEqualTo((Object)"MATCH ()-[r0]->() WHERE ID(r0)={id}  WITH r0,STARTNODE(r0) AS n, ENDNODE(r0) AS m MATCH p1 = (n)-[*0..2]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..2]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindOneByType() throws Exception {
        Assertions.assertThat((String)this.query.findOneByType("ORBITS", (Serializable)Long.valueOf(0L), 2).getStatement()).isEqualTo((Object)"MATCH ()-[r0:`ORBITS`]->() WHERE ID(r0)={id}  WITH r0,STARTNODE(r0) AS n, ENDNODE(r0) AS m MATCH p1 = (n)-[*0..2]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..2]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindOneByTypePrimaryIndex() throws Exception {
        PagingAndSortingQuery query = this.primaryQuery.findOneByType("ORBITS", (Serializable)((Object)"test-uuid"), 2);
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH ()-[r0:`ORBITS`]->() WHERE r0.`uuid`={id}  WITH r0,STARTNODE(r0) AS n, ENDNODE(r0) AS m MATCH p1 = (n)-[*0..2]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..2]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
        Assertions.assertThat((Map)query.getParameters()).contains(new Map.Entry[]{Assertions.entry((Object)"id", (Object)"test-uuid")});
    }

    @Test
    public void testFindByLabel() throws Exception {
        Assertions.assertThat((String)this.query.findByType("ORBITS", 3).getStatement()).isEqualTo((Object)"MATCH ()-[r0:`ORBITS`]-()  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..3]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..3]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindAllByTypeCollection() throws Exception {
        Assertions.assertThat((String)this.query.findAllByType("ORBITS", Arrays.asList(1L, 2L, 3L), 1).getStatement()).isEqualTo((Object)"MATCH ()-[r0:`ORBITS`]-() WHERE ID(r0) IN {ids}  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..1]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..1]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindAllByTypePrimaryIndex() throws Exception {
        PagingAndSortingQuery query = this.primaryQuery.findAllByType("ORBITS", Arrays.asList("test-uuid-1", "test-uuid-2"), 2);
        Assertions.assertThat((String)query.getStatement()).isEqualTo((Object)"MATCH ()-[r0:`ORBITS`]-() WHERE r0.`uuid` IN {ids}  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..2]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..2]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
        Assertions.assertThat((Map)query.getParameters()).contains(new Map.Entry[]{Assertions.entry((Object)"ids", Arrays.asList("test-uuid-1", "test-uuid-2"))});
    }

    @Test
    public void testFindByProperty() throws Exception {
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter("distance", ComparisonOperator.EQUALS, (Object)60.2)), 4).getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`ORBITS`]->(m) WHERE r0.`distance` = { `distance_0` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test(expected=InvalidDepthException.class)
    public void testFindOneZeroDepth() throws Exception {
        this.query.findOne((Serializable)Long.valueOf(0L), 0).getStatement();
    }

    @Test(expected=InvalidDepthException.class)
    public void testFindByLabelZeroDepth() throws Exception {
        this.query.findByType("ORBITS", 0).getStatement();
    }

    @Test(expected=InvalidDepthException.class)
    public void testFindByPropertyZeroDepth() throws Exception {
        this.query.findByType("ORBITS", new Filters().add(new Filter("perihelion", ComparisonOperator.EQUALS, (Object)19.7)), 0).getStatement();
    }

    @Test(expected=InvalidDepthException.class)
    public void testFindOneInfiniteDepth() throws Exception {
        this.query.findOne((Serializable)Long.valueOf(0L), -1).getStatement();
    }

    @Test(expected=InvalidDepthException.class)
    public void testFindByLabelInfiniteDepth() throws Exception {
        this.query.findByType("ORBITS", -1).getStatement();
    }

    @Test(expected=InvalidDepthException.class)
    public void testFindByPropertyInfiniteDepth() throws Exception {
        this.query.findByType("ORBITS", new Filters().add(new Filter("period", ComparisonOperator.EQUALS, (Object)2103.776)), -1).getStatement();
    }

    @Test
    public void testFindByNestedPropertyOutgoing() throws Exception {
        Filter planetFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetFilter.setNestedPropertyName("world");
        planetFilter.setNestedEntityTypeLabel("Planet");
        planetFilter.setRelationshipType("ORBITS");
        planetFilter.setRelationshipDirection("OUTGOING");
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(planetFilter), 4).getStatement()).isEqualTo((Object)"MATCH (n:`Planet`) WHERE n.`name` = { `world_name_0` } MATCH (n)-[r0:`ORBITS`]->(m)  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByNestedPropertyIncoming() throws Exception {
        Filter planetFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetFilter.setNestedPropertyName("world");
        planetFilter.setNestedEntityTypeLabel("Planet");
        planetFilter.setRelationshipType("ORBITS");
        planetFilter.setRelationshipDirection("INCOMING");
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(planetFilter), 4).getStatement()).isEqualTo((Object)"MATCH (m:`Planet`) WHERE m.`name` = { `world_name_0` } MATCH (n)-[r0:`ORBITS`]->(m)  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByMultipleNestedProperties() throws Exception {
        Filter planetNameFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetNameFilter.setNestedPropertyName("world");
        planetNameFilter.setNestedEntityTypeLabel("Planet");
        planetNameFilter.setRelationshipType("ORBITS");
        planetNameFilter.setRelationshipDirection("OUTGOING");
        Filter planetMoonsFilter = new Filter("moons", ComparisonOperator.EQUALS, (Object)"Earth");
        planetMoonsFilter.setNestedPropertyName("moons");
        planetMoonsFilter.setNestedEntityTypeLabel("Planet");
        planetMoonsFilter.setRelationshipType("ORBITS");
        planetMoonsFilter.setRelationshipDirection("OUTGOING");
        planetMoonsFilter.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter[]{planetNameFilter, planetMoonsFilter}), 4).getStatement()).isEqualTo((Object)"MATCH (n:`Planet`) WHERE n.`name` = { `world_name_0` } AND n.`moons` = { `moons_moons_1` } MATCH (n)-[r0:`ORBITS`]->(m)  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByMultipleNestedPropertiesOnBothEnds() throws Exception {
        Filter moonFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        moonFilter.setNestedPropertyName("world");
        moonFilter.setNestedEntityTypeLabel("Moon");
        moonFilter.setRelationshipType("ORBITS");
        moonFilter.setRelationshipDirection("OUTGOING");
        Filter planetFilter = new Filter("colour", ComparisonOperator.EQUALS, (Object)"Red");
        planetFilter.setNestedPropertyName("colour");
        planetFilter.setNestedEntityTypeLabel("Planet");
        planetFilter.setRelationshipType("ORBITS");
        planetFilter.setRelationshipDirection("INCOMING");
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter[]{moonFilter, planetFilter}), 4).getStatement()).isEqualTo((Object)"MATCH (n:`Moon`) WHERE n.`name` = { `world_name_0` } MATCH (m:`Planet`) WHERE m.`colour` = { `colour_colour_1` } MATCH (n)-[r0:`ORBITS`]->(m)  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByPropertiesAnded() throws Exception {
        Filter distance = new Filter("distance", ComparisonOperator.EQUALS, (Object)60.2);
        Filter time = new Filter("time", ComparisonOperator.EQUALS, (Object)3600);
        time.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter[]{distance, time}), 4).getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`ORBITS`]->(m) WHERE r0.`distance` = { `distance_0` } AND r0.`time` = { `time_1` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByPropertiesOred() throws Exception {
        Filter distance = new Filter("distance", ComparisonOperator.EQUALS, (Object)60.2);
        Filter time = new Filter("time", ComparisonOperator.EQUALS, (Object)3600);
        time.setBooleanOperator(BooleanOperator.OR);
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter[]{distance, time}), 4).getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`ORBITS`]->(m) WHERE r0.`distance` = { `distance_0` } OR r0.`time` = { `time_1` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByPropertiesWithDifferentComparisonOperatorsAnded() throws Exception {
        Filter distance = new Filter("distance", ComparisonOperator.LESS_THAN, (Object)60.2);
        Filter time = new Filter("time", ComparisonOperator.EQUALS, (Object)3600);
        time.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter[]{distance, time}), 4).getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`ORBITS`]->(m) WHERE r0.`distance` < { `distance_0` } AND r0.`time` = { `time_1` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByPropertiesWithDifferentComparisonOperatorsOred() throws Exception {
        Filter distance = new Filter("distance", ComparisonOperator.EQUALS, (Object)60.2);
        Filter time = new Filter("time", ComparisonOperator.GREATER_THAN, (Object)3600);
        time.setBooleanOperator(BooleanOperator.OR);
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter[]{distance, time}), 4).getStatement()).isEqualTo((Object)"MATCH (n)-[r0:`ORBITS`]->(m) WHERE r0.`distance` = { `distance_0` } OR r0.`time` > { `time_1` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByBaseAndNestedPropertyOutgoing() throws Exception {
        Filter planetFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetFilter.setNestedPropertyName("world");
        planetFilter.setNestedEntityTypeLabel("Planet");
        planetFilter.setRelationshipType("ORBITS");
        planetFilter.setRelationshipDirection("OUTGOING");
        Filter time = new Filter("time", ComparisonOperator.EQUALS, (Object)3600);
        time.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter[]{planetFilter, time}), 4).getStatement()).isEqualTo((Object)"MATCH (n:`Planet`) WHERE n.`name` = { `world_name_0` } MATCH (n)-[r0:`ORBITS`]->(m) WHERE r0.`time` = { `time_1` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByBaseAndNestedPropertyIncoming() throws Exception {
        Filter planetFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetFilter.setNestedPropertyName("world");
        planetFilter.setNestedEntityTypeLabel("Planet");
        planetFilter.setRelationshipType("ORBITS");
        planetFilter.setRelationshipDirection("INCOMING");
        Filter time = new Filter("time", ComparisonOperator.EQUALS, (Object)3600);
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter[]{planetFilter, time}), 4).getStatement()).isEqualTo((Object)"MATCH (m:`Planet`) WHERE m.`name` = { `world_name_0` } MATCH (n)-[r0:`ORBITS`]->(m) WHERE r0.`time` = { `time_1` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test
    public void testFindByBaseAndMultipleNestedPropertiesOnBothEnds() throws Exception {
        Filter moonFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        moonFilter.setNestedPropertyName("world");
        moonFilter.setNestedEntityTypeLabel("Moon");
        moonFilter.setRelationshipType("ORBITS");
        moonFilter.setRelationshipDirection("OUTGOING");
        Filter planetFilter = new Filter("colour", ComparisonOperator.EQUALS, (Object)"Red");
        planetFilter.setNestedPropertyName("colour");
        planetFilter.setNestedEntityTypeLabel("Planet");
        planetFilter.setRelationshipType("ORBITS");
        planetFilter.setRelationshipDirection("INCOMING");
        Filter time = new Filter("time", ComparisonOperator.EQUALS, (Object)3600);
        time.setBooleanOperator(BooleanOperator.AND);
        Assertions.assertThat((String)this.query.findByType("ORBITS", new Filters().add(new Filter[]{moonFilter, planetFilter, time}), 4).getStatement()).isEqualTo((Object)"MATCH (n:`Moon`) WHERE n.`name` = { `world_name_0` } MATCH (m:`Planet`) WHERE m.`colour` = { `colour_colour_1` } MATCH (n)-[r0:`ORBITS`]->(m) WHERE r0.`time` = { `time_2` }  WITH DISTINCT(r0) as r0,startnode(r0) AS n, endnode(r0) AS m MATCH p1 = (n)-[*0..4]-() WITH r0, COLLECT(DISTINCT p1) AS startPaths, m MATCH p2 = (m)-[*0..4]-() WITH r0, startPaths, COLLECT(DISTINCT p2) AS endPaths WITH r0,startPaths + endPaths  AS paths UNWIND paths AS p RETURN DISTINCT p, ID(r0)");
    }

    @Test(expected=MissingOperatorException.class)
    public void testFindByPropertiesAndedWithMissingBooleanOperator() throws Exception {
        Filter distance = new Filter("distance", ComparisonOperator.EQUALS, (Object)60.2);
        Filter time = new Filter("time", ComparisonOperator.EQUALS, (Object)3600);
        this.query.findByType("ORBITS", new Filters().add(new Filter[]{distance, time}), 4).getStatement();
    }

    @Test(expected=MissingOperatorException.class)
    public void testFindByMultipleNestedPropertiesMissingBooleanOperator() throws Exception {
        Filter planetNameFilter = new Filter("name", ComparisonOperator.EQUALS, (Object)"Earth");
        planetNameFilter.setNestedPropertyName("world");
        planetNameFilter.setNestedEntityTypeLabel("Planet");
        planetNameFilter.setRelationshipType("ORBITS");
        planetNameFilter.setRelationshipDirection("OUTGOING");
        Filter planetMoonsFilter = new Filter("moons", ComparisonOperator.EQUALS, (Object)"Earth");
        planetMoonsFilter.setNestedPropertyName("moons");
        planetMoonsFilter.setNestedEntityTypeLabel("Planet");
        planetMoonsFilter.setRelationshipType("ORBITS");
        planetMoonsFilter.setRelationshipDirection("OUTGOING");
        this.query.findByType("ORBITS", new Filters().add(new Filter[]{planetNameFilter, planetMoonsFilter}), 4).getStatement();
    }
}

