/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.convertible.bytes.Photo;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class ByteArrayConversionTest {
    private static final MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.convertible.bytes"});
    private static final ClassInfo photoInfo = metaData.classInfo("Photo");

    @Test
    public void testConvertersLoaded() {
        Assertions.assertThat((boolean)photoInfo.propertyField("image").hasPropertyConverter()).isTrue();
        Assertions.assertThat((boolean)photoInfo.propertyField("image").hasPropertyConverter()).isTrue();
        Assertions.assertThat((boolean)photoInfo.propertyField("image").hasPropertyConverter()).isTrue();
    }

    @Test
    public void setImageAndCheck() {
        Photo photo = new Photo();
        AttributeConverter converter = photoInfo.propertyField("image").getPropertyConverter();
        photo.setImage(new byte[]{1, 2, 3, 4});
        Assertions.assertThat((Object)converter.toGraphProperty((Object)photo.getImage())).isEqualTo((Object)"AQIDBA==");
    }

    @Test
    public void getImageAndCheck() {
        Photo photo = new Photo();
        AttributeConverter converter = photoInfo.propertyField("image").getPropertyConverter();
        photo.setImage((byte[])converter.toEntityAttribute((Object)"AQIDBA=="));
        byte[] image = photo.getImage();
        Assertions.assertThat((int)image.length).isEqualTo(4);
        Assertions.assertThat((byte[])image).isEqualTo((Object)new byte[]{1, 2, 3, 4});
    }
}

