/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.convertible.bytes.PhotoWrapper;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class ByteArrayWrapperConversionTest {
    private static final MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.convertible.bytes"});
    private static final ClassInfo photoInfo = metaData.classInfo("PhotoWrapper");

    @Test
    public void testConvertersLoaded() {
        Assertions.assertThat((boolean)photoInfo.propertyField("image").hasPropertyConverter()).isTrue();
    }

    @Test
    public void setImageAndCheck() {
        PhotoWrapper photo = new PhotoWrapper();
        AttributeConverter converter = photoInfo.propertyField("image").getPropertyConverter();
        photo.setImage(new Byte[]{(byte)1, (byte)2, (byte)3, (byte)4});
        Assertions.assertThat((Object)converter.toGraphProperty((Object)photo.getImage())).isEqualTo((Object)"AQIDBA==");
    }

    @Test
    public void getImageAndCheck() {
        PhotoWrapper photo = new PhotoWrapper();
        AttributeConverter converter = photoInfo.propertyField("image").getPropertyConverter();
        photo.setImage((Byte[])converter.toEntityAttribute((Object)"AQIDBA=="));
        Byte[] image = photo.getImage();
        Assertions.assertThat((int)image.length).isEqualTo(4);
        Assertions.assertThat((Byte)image[0]).isEqualTo((Object)Byte.decode("1"));
        Assertions.assertThat((Byte)image[1]).isEqualTo((Object)Byte.decode("2"));
        Assertions.assertThat((Byte)image[2]).isEqualTo((Object)Byte.decode("3"));
        Assertions.assertThat((Byte)image[3]).isEqualTo((Object)Byte.decode("4"));
    }
}

