/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.DateArrayStringConverter;
import org.neo4j.ogm.typeconversion.DateCollectionStringConverter;
import org.neo4j.ogm.typeconversion.DateLongConverter;
import org.neo4j.ogm.typeconversion.DateStringConverter;

public class DateConversionTest {
    private static final MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.convertible.date"});
    private static final ClassInfo memoInfo = metaData.classInfo("Memo");
    SimpleDateFormat simpleDateISO8601format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    @Test
    public void assertFieldDateConversionToISO8601FormatByDefault() {
        FieldInfo fieldInfo = memoInfo.propertyField("recorded");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((boolean)attributeConverter.getClass().isAssignableFrom(DateStringConverter.class)).isTrue();
        Assertions.assertThat((Object)attributeConverter.toGraphProperty((Object)new Date(0L))).isEqualTo((Object)"1970-01-01T00:00:00.000Z");
    }

    @Test
    public void assertFieldDateConversionWithUserDefinedFormat() {
        FieldInfo fieldInfo = memoInfo.propertyField("actioned");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((boolean)attributeConverter.getClass().isAssignableFrom(DateStringConverter.class)).isTrue();
        Assertions.assertThat((Object)attributeConverter.toGraphProperty((Object)new Date(0L))).isEqualTo((Object)"1970-01-01");
    }

    @Test
    public void assertFieldDateLongConversion() {
        FieldInfo fieldInfo = memoInfo.propertyField("closed");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((boolean)attributeConverter.getClass().isAssignableFrom(DateLongConverter.class)).isTrue();
        Date date = new Date(0L);
        Long value = (Long)attributeConverter.toGraphProperty((Object)date);
        Assertions.assertThat((Long)value).isEqualTo((Object)new Long(0L));
    }

    @Test
    public void assertFieldCustomTypeConversion() {
        FieldInfo fieldInfo = memoInfo.propertyField("approved");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toGraphProperty((Object)new Date(1234567890123L))).isEqualTo((Object)"20090213113130");
    }

    @Test
    public void assertConvertingNullGraphPropertyWorksCorrectly() {
        FieldInfo methodInfo = memoInfo.propertyField("approved");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute(null)).isEqualTo(null);
    }

    @Test
    public void assertConvertingNullAttributeWorksCorrectly() {
        FieldInfo methodInfo = memoInfo.propertyField("approved");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toGraphProperty(null)).isEqualTo(null);
    }

    @Test
    public void assertArrayFieldDateConversionToISO8601FormatByDefault() {
        this.simpleDateISO8601format.setTimeZone(TimeZone.getTimeZone("UTC"));
        Date[] dates = new Date[]{new Date(0L), new Date(20000L)};
        FieldInfo fieldInfo = memoInfo.propertyField("escalations");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((boolean)attributeConverter.getClass().isAssignableFrom(DateArrayStringConverter.class)).isTrue();
        String[] converted = (String[])attributeConverter.toGraphProperty((Object)dates);
        Assertions.assertThat((converted[0].equals("1970-01-01T00:00:00.000Z") || converted[1].equals("1970-01-01T00:00:00.000Z") ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((converted[0].equals(this.simpleDateISO8601format.format(new Date(20000L))) || converted[1].equals(this.simpleDateISO8601format.format(new Date(20000L))) ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void assertConvertingNullArrayGraphPropertyWorksCorrectly() {
        FieldInfo methodInfo = memoInfo.propertyField("escalations");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute(null)).isEqualTo(null);
    }

    @Test
    public void assertConvertingNullArrayAttributeWorksCorrectly() {
        FieldInfo methodInfo = memoInfo.propertyField("escalations");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toGraphProperty(null)).isEqualTo(null);
    }

    @Test
    public void assertCollectionFieldDateConversionToISO8601FormatByDefault() {
        this.simpleDateISO8601format.setTimeZone(TimeZone.getTimeZone("UTC"));
        ArrayList<Date> dates = new ArrayList<Date>();
        dates.add(new Date(0L));
        dates.add(new Date(20000L));
        FieldInfo fieldInfo = memoInfo.propertyField("implementations");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((boolean)attributeConverter.getClass().isAssignableFrom(DateCollectionStringConverter.class)).isTrue();
        String[] converted = (String[])attributeConverter.toGraphProperty(dates);
        Assertions.assertThat((converted[0].equals("1970-01-01T00:00:00.000Z") || converted[1].equals("1970-01-01T00:00:00.000Z") ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((converted[0].equals(this.simpleDateISO8601format.format(new Date(20000L))) || converted[1].equals(this.simpleDateISO8601format.format(new Date(20000L))) ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void assertConvertingNullCollectionGraphPropertyWorksCorrectly() {
        FieldInfo methodInfo = memoInfo.propertyField("implementations");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute(null)).isEqualTo(null);
    }

    @Test
    public void assertConvertingNullCollectionAttributeWorksCorrectly() {
        FieldInfo methodInfo = memoInfo.propertyField("implementations");
        Assertions.assertThat((boolean)methodInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = methodInfo.getPropertyConverter();
        Assertions.assertThat((Object)attributeConverter.toGraphProperty(null)).isEqualTo(null);
    }

    @Test
    public void assertFieldDateConversionWithExplicitAnnotation() {
        FieldInfo fieldInfo = memoInfo.propertyField("modified");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((boolean)attributeConverter.getClass().isAssignableFrom(DateStringConverter.class)).isTrue();
        Assertions.assertThat((Object)attributeConverter.toGraphProperty((Object)new Date(0L))).isEqualTo((Object)"1970-01-01T00:00:00.000Z");
    }

    @Test
    public void assertFieldDateConversionWithExplicitAnnotationWorksForNullGraphValue() {
        FieldInfo fieldInfo = memoInfo.propertyField("modified");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((boolean)attributeConverter.getClass().isAssignableFrom(DateStringConverter.class)).isTrue();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute(null)).isNull();
    }

    @Test(expected=RuntimeException.class)
    public void assertFieldDateConversionWithExplicitAnnotationFailsForEmptyGraphValue() {
        FieldInfo fieldInfo = memoInfo.propertyField("modified");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((boolean)attributeConverter.getClass().isAssignableFrom(DateStringConverter.class)).isTrue();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute((Object)"")).isNull();
    }

    @Test
    public void assertFieldLenientDateConversionWithExplicitAnnotationWorksForEmptyGraphValue() {
        FieldInfo fieldInfo = memoInfo.propertyField("legacyDate");
        Assertions.assertThat((boolean)fieldInfo.hasPropertyConverter()).isTrue();
        AttributeConverter attributeConverter = fieldInfo.getPropertyConverter();
        Assertions.assertThat((boolean)attributeConverter.getClass().isAssignableFrom(DateStringConverter.class)).isTrue();
        Assertions.assertThat((Object)attributeConverter.toEntityAttribute((Object)"")).isNull();
    }
}

