/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.typeconversion;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.neo4j.ogm.domain.convertible.numbers.Account;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class NumberConversionTest {
    private static final MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.convertible.numbers"});
    private static final ClassInfo accountInfo = metaData.classInfo("Account");

    @Test
    public void assertAccountFieldsHaveDefaultConverters() {
        Assertions.assertThat((boolean)accountInfo.propertyField("balance").hasPropertyConverter()).isTrue();
        Assertions.assertThat((boolean)accountInfo.propertyField("facility").hasPropertyConverter()).isTrue();
        Assertions.assertThat((boolean)accountInfo.propertyField("deposits").hasPropertyConverter()).isTrue();
        Assertions.assertThat((boolean)accountInfo.propertyField("loans").hasPropertyConverter()).isTrue();
    }

    @Test
    public void assertAccountMethodsHaveDefaultConverters() {
        Assertions.assertThat((boolean)accountInfo.propertyField("balance").hasPropertyConverter()).isTrue();
        Assertions.assertThat((boolean)accountInfo.propertyField("facility").hasPropertyConverter()).isTrue();
        Assertions.assertThat((boolean)accountInfo.propertyField("deposits").hasPropertyConverter()).isTrue();
        Assertions.assertThat((boolean)accountInfo.propertyField("loans").hasPropertyConverter()).isTrue();
    }

    @Test
    public void assertAccountBalanceConverterWorks() {
        AttributeConverter converter = accountInfo.propertyField("balance").getPropertyConverter();
        Account account = new Account(new BigDecimal("12345.67"), new BigInteger("1000"));
        Assertions.assertThat((Object)converter.toGraphProperty((Object)account.getBalance())).isEqualTo((Object)"12345.67");
        account.setBalance((BigDecimal)converter.toEntityAttribute((Object)"34567.89"));
        Assertions.assertThat((BigDecimal)account.getBalance()).isEqualTo((Object)new BigDecimal("34567.89"));
    }

    @Test
    public void assertAccountDepositConverterWorks() {
        AttributeConverter converter = accountInfo.propertyField("deposits").getPropertyConverter();
        BigDecimal[] deposits = new BigDecimal[]{new BigDecimal("12345.67"), new BigDecimal("34567.89")};
        Account account = new Account(new BigDecimal("12345.67"), new BigInteger("1000"));
        account.setDeposits(deposits);
        String[] convertedDeposits = (String[])converter.toGraphProperty((Object)account.getDeposits());
        Assertions.assertThat((int)convertedDeposits.length).isEqualTo(2);
        Assertions.assertThat((String)convertedDeposits[0]).isEqualTo((Object)"12345.67");
        Assertions.assertThat((String)convertedDeposits[1]).isEqualTo((Object)"34567.89");
        account.setDeposits((BigDecimal[])converter.toEntityAttribute((Object)convertedDeposits));
        Assertions.assertThat((BigDecimal)account.getDeposits()[0]).isEqualTo((Object)new BigDecimal("12345.67"));
        Assertions.assertThat((BigDecimal)account.getDeposits()[1]).isEqualTo((Object)new BigDecimal("34567.89"));
    }

    @Test
    public void assertAccountLoNAConverterWorks() {
        AttributeConverter converter = accountInfo.propertyField("loans").getPropertyConverter();
        ArrayList<BigInteger> loans = new ArrayList<BigInteger>();
        loans.add(BigInteger.valueOf(123456L));
        loans.add(BigInteger.valueOf(567890L));
        Account account = new Account(new BigDecimal("12345.67"), new BigInteger("1000"));
        account.setLoans(loans);
        String[] convertedLoans = (String[])converter.toGraphProperty(account.getLoans());
        Assertions.assertThat((int)convertedLoans.length).isEqualTo(2);
        Assertions.assertThat((String)convertedLoans[0]).isEqualTo((Object)"123456");
        Assertions.assertThat((String)convertedLoans[1]).isEqualTo((Object)"567890");
        account.setLoans((List)converter.toEntityAttribute((Object)convertedLoans));
        Assertions.assertThat((BigInteger)account.getLoans().get(0)).isEqualTo((Object)BigInteger.valueOf(123456L));
        Assertions.assertThat((BigInteger)account.getLoans().get(1)).isEqualTo((Object)BigInteger.valueOf(567890L));
    }

    @Test
    public void assertAccountFacilityConverterWorks() {
        AttributeConverter converter = accountInfo.propertyField("facility").getPropertyConverter();
        Account account = new Account(new BigDecimal("12345.67"), new BigInteger("1000"));
        Assertions.assertThat((Object)converter.toGraphProperty((Object)account.getFacility())).isEqualTo((Object)"1000");
        account.setFacility((BigInteger)converter.toEntityAttribute((Object)"2000"));
        Assertions.assertThat((BigInteger)account.getFacility()).isEqualTo((Object)new BigInteger("2000"));
    }

    @Test
    public void assertConvertingNullGraphPropertyWorksCorrectly() {
        AttributeConverter converter = accountInfo.propertyField("facility").getPropertyConverter();
        Assertions.assertThat((Object)converter.toEntityAttribute(null)).isEqualTo(null);
        converter = accountInfo.propertyField("deposits").getPropertyConverter();
        Assertions.assertThat((Object)converter.toEntityAttribute(null)).isEqualTo(null);
        converter = accountInfo.propertyField("loans").getPropertyConverter();
        Assertions.assertThat((Object)converter.toEntityAttribute(null)).isEqualTo(null);
    }

    @Test
    public void assertConvertingNullAttributeWorksCorrectly() {
        AttributeConverter converter = accountInfo.propertyField("facility").getPropertyConverter();
        Assertions.assertThat((Object)converter.toGraphProperty(null)).isEqualTo(null);
        converter = accountInfo.propertyField("deposits").getPropertyConverter();
        Assertions.assertThat((Object)converter.toGraphProperty(null)).isEqualTo(null);
        converter = accountInfo.propertyField("loans").getPropertyConverter();
        Assertions.assertThat((Object)converter.toGraphProperty(null)).isEqualTo(null);
    }

    @Test
    public void assertHasCompositeConverter() {
        MetaData metaData = new MetaData(new String[]{"org.neo4j.ogm.domain.restaurant"});
        ClassInfo restaurantInfo = metaData.classInfo("Restaurant");
        Assertions.assertThat((boolean)restaurantInfo.propertyField("location").hasCompositeConverter()).isTrue();
    }

    @Test(expected=RuntimeException.class)
    public void assertConvertingEmptyGraphPropertyFails() {
        AttributeConverter converter = accountInfo.propertyField("futureBalance").getPropertyConverter();
        Assertions.assertThat((Object)converter.toEntityAttribute((Object)"")).isEqualTo(null);
    }

    @Test
    public void assertConvertingEmptyGraphPropertyWorksCorrectlyWithLenientConverter() {
        AttributeConverter converter = accountInfo.propertyField("futureBalanceLenient").getPropertyConverter();
        Assertions.assertThat((Object)converter.toEntityAttribute((Object)"")).isEqualTo(null);
    }
}

