/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.builtin.routing;

import java.util.List;
import java.util.Optional;
import org.neo4j.collection.RawIterator;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.ProcedureSignature;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.ResourceTracker;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.Context;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.builtin.routing.ParameterNames;
import org.neo4j.procedure.builtin.routing.RoutingResult;
import org.neo4j.procedure.builtin.routing.RoutingResultFormat;
import org.neo4j.values.AnyValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;

public abstract class BaseGetRoutingTableProcedure
implements CallableProcedure {
    private static final String NAME = "getRoutingTable";
    private final ProcedureSignature signature;
    private final DatabaseManager<?> databaseManager;
    protected final Config config;
    protected final Log log;

    protected BaseGetRoutingTableProcedure(List<String> namespace, DatabaseManager<?> databaseManager, Config config, LogProvider logProvider) {
        this.signature = this.buildSignature(namespace);
        this.databaseManager = databaseManager;
        this.config = config;
        this.log = logProvider.getLog(this.getClass());
    }

    public final ProcedureSignature signature() {
        return this.signature;
    }

    public final RawIterator<AnyValue[], ProcedureException> apply(Context ctx, AnyValue[] input, ResourceTracker resourceTracker) throws ProcedureException {
        NamedDatabaseId databaseId = this.extractDatabaseId(input);
        this.assertDatabaseOperational(databaseId);
        MapValue routingContext = BaseGetRoutingTableProcedure.extractRoutingContext(input);
        RoutingResult result = this.invoke(databaseId, routingContext);
        this.log.debug("Routing result for database %s and routing context %s is %s", new Object[]{databaseId, routingContext, result});
        this.assertRoutingResultNotEmpty(result, databaseId);
        return RawIterator.of((Object[])new AnyValue[][]{RoutingResultFormat.build(result)});
    }

    protected abstract String description();

    protected abstract RoutingResult invoke(NamedDatabaseId var1, MapValue var2) throws ProcedureException;

    private NamedDatabaseId extractDatabaseId(AnyValue[] input) throws ProcedureException {
        String databaseName;
        AnyValue arg = input[1];
        if (arg == Values.NO_VALUE) {
            databaseName = (String)this.config.get(GraphDatabaseSettings.default_database);
        } else if (arg instanceof TextValue) {
            databaseName = ((TextValue)arg).stringValue();
        } else {
            throw new IllegalArgumentException("Illegal database name argument " + arg);
        }
        return (NamedDatabaseId)this.databaseManager.databaseIdRepository().getByName(databaseName).orElseThrow(() -> BaseGetRoutingTableProcedure.databaseNotFoundException(databaseName));
    }

    private void assertDatabaseOperational(NamedDatabaseId namedDatabaseId) throws ProcedureException {
        Optional databaseContext = this.databaseManager.getDatabaseContext(namedDatabaseId);
        if (databaseContext.isEmpty()) {
            throw BaseGetRoutingTableProcedure.databaseNotFoundException(namedDatabaseId.name());
        }
        Database db = ((DatabaseContext)databaseContext.get()).database();
        if (!db.getDatabaseAvailabilityGuard().isAvailable()) {
            throw BaseGetRoutingTableProcedure.databaseUnavailableException(namedDatabaseId.name());
        }
    }

    private void assertRoutingResultNotEmpty(RoutingResult result, NamedDatabaseId namedDatabaseId) throws ProcedureException {
        if (result.containsNoEndpoints()) {
            this.assertDatabaseOperational(namedDatabaseId);
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, "Routing table for database " + namedDatabaseId.name() + " is empty", new Object[0]);
        }
    }

    private static MapValue extractRoutingContext(AnyValue[] input) {
        AnyValue arg = input[0];
        if (arg == Values.NO_VALUE) {
            return MapValue.EMPTY;
        }
        if (arg instanceof MapValue) {
            return (MapValue)arg;
        }
        throw new IllegalArgumentException("Illegal routing context argument " + arg);
    }

    private ProcedureSignature buildSignature(List<String> namespace) {
        return ProcedureSignature.procedureSignature((QualifiedName)new QualifiedName(namespace, NAME)).in(ParameterNames.CONTEXT.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTMap).in(ParameterNames.DATABASE.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTString, DefaultParameterValue.nullValue((Neo4jTypes.AnyType)Neo4jTypes.NTString)).out(ParameterNames.TTL.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTInteger).out(ParameterNames.SERVERS.parameterName(), (Neo4jTypes.AnyType)Neo4jTypes.NTList((Neo4jTypes.AnyType)Neo4jTypes.NTMap)).mode(Mode.DBMS).description(this.description()).systemProcedure().build();
    }

    private static ProcedureException databaseNotFoundException(String databaseName) {
        return new ProcedureException((Status)Status.Database.DatabaseNotFound, "Unable to get a routing table for database '" + databaseName + "' because this database does not exist", new Object[0]);
    }

    private static ProcedureException databaseUnavailableException(String databaseName) {
        return new ProcedureException((Status)Status.Database.DatabaseUnavailable, "Unable to get a routing table for database '" + databaseName + "' because this database is unavailable", new Object[0]);
    }
}

