/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.helpers.Args;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.impl.util.Charsets;
import org.neo4j.shell.CtrlCHandler;
import org.neo4j.shell.InterruptSignalHandler;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellLobby;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.RmiLocation;
import org.neo4j.shell.impl.ShellBootstrap;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;

public class StartClient {
    private AtomicBoolean hasBeenShutdown = new AtomicBoolean();
    public static final String ARG_PATH = "path";
    public static final String ARG_READONLY = "readonly";
    public static final String ARG_HOST = "host";
    public static final String ARG_PORT = "port";
    public static final String ARG_NAME = "name";
    public static final String ARG_PID = "pid";
    public static final String ARG_COMMAND = "c";
    public static final String ARG_FILE = "file";
    public static final String ARG_FILE_STDIN = "-";
    public static final String ARG_CONFIG = "config";
    private final PrintStream out;
    private final PrintStream err;
    private static final Method attachMethod;
    private static final Method loadMethod;

    private StartClient(PrintStream out, PrintStream err) {
        this.out = out;
        this.err = err;
    }

    public static void main(String[] arguments) {
        InterruptSignalHandler signalHandler = InterruptSignalHandler.getHandler();
        try {
            new StartClient(System.out, System.err).start(arguments, signalHandler);
        }
        catch (ShellExecutionFailureException e) {
            e.dumpMessage(System.out, System.err);
            System.exit(1);
        }
    }

    private void start(String[] arguments, CtrlCHandler signalHandler) {
        Args args = Args.withFlags((String[])new String[]{ARG_READONLY}).parse(arguments);
        if (args.has("?") || args.has("h") || args.has("help") || args.has("usage")) {
            StartClient.printUsage(this.out);
            return;
        }
        String path = args.get(ARG_PATH, null);
        String host = args.get(ARG_HOST, null);
        String port = args.get(ARG_PORT, null);
        String name = args.get(ARG_NAME, null);
        String pid = args.get(ARG_PID, null);
        if (path != null && (port != null || name != null || host != null || pid != null) || pid != null && host != null) {
            this.err.println("You have supplied both path as well as host/port/name. You should either supply only path or host/port/name so that either a local or remote shell client can be started");
        } else if (path != null) {
            try {
                StartClient.checkNeo4jDependency();
            }
            catch (ShellException e) {
                throw new ShellExecutionFailureException(e, args);
            }
            this.startLocal(args, signalHandler);
        } else {
            String readonly = args.get(ARG_READONLY, null);
            if (readonly != null) {
                this.err.println("Warning: -readonly is ignored unless you connect with -path!");
            }
            if (pid != null) {
                this.startServer(pid, args);
            }
            this.startRemote(args, signalHandler);
        }
    }

    private static void checkNeo4jDependency() throws ShellException {
        try {
            Class.forName("org.neo4j.graphdb.GraphDatabaseService");
        }
        catch (Exception e) {
            throw new ShellException("Neo4j not found on the classpath");
        }
    }

    private void startLocal(Args args, CtrlCHandler signalHandler) {
        String dbPath = args.get(ARG_PATH, null);
        if (dbPath == null) {
            this.err.println("ERROR: To start a local Neo4j service and a shell client on top of that you need to supply a path to a Neo4j store or just a new path where a new store will be created if it doesn't exist. -path /my/path/here");
            return;
        }
        try {
            boolean readOnly = args.getBoolean(ARG_READONLY, Boolean.valueOf(false), Boolean.valueOf(true));
            this.tryStartLocalServerAndClient(dbPath, readOnly, args, signalHandler);
        }
        catch (Exception e) {
            throw new ShellExecutionFailureException(e, args);
        }
    }

    private void tryStartLocalServerAndClient(String dbPath, boolean readOnly, Args args, CtrlCHandler signalHandler) throws Exception {
        String configFile = args.get(ARG_CONFIG, null);
        final GraphDatabaseShellServer server = new GraphDatabaseShellServer(dbPath, readOnly, configFile);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                StartClient.this.shutdownIfNecessary(server);
            }
        });
        if (!StartClient.isCommandLine(args)) {
            this.out.println("NOTE: Local Neo4j graph database service at '" + dbPath + "'");
        }
        ShellClient client = ShellLobby.newClient(server, StartClient.getSessionVariablesFromArgs(args), signalHandler);
        this.grabPromptOrJustExecuteCommand(client, args);
        this.shutdownIfNecessary(server);
    }

    private void shutdownIfNecessary(ShellServer server) {
        try {
            if (!this.hasBeenShutdown.compareAndSet(false, true)) {
                server.shutdown();
            }
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    private void startServer(String pid, Args args) {
        String port = args.get(ARG_PORT, Integer.toString(1337));
        String name = args.get(ARG_NAME, "shell");
        try {
            String jarfile = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsolutePath();
            Object vm = attachMethod.invoke(null, pid);
            loadMethod.invoke(vm, jarfile, new ShellBootstrap(Integer.parseInt(port), name).serialize());
        }
        catch (Exception e) {
            throw new ShellExecutionFailureException(e, args);
        }
    }

    private void startRemote(Args args, CtrlCHandler signalHandler) {
        try {
            String host = args.get(ARG_HOST, "localhost");
            int port = args.getNumber(ARG_PORT, (Number)1337).intValue();
            String name = args.get(ARG_NAME, "shell");
            ShellClient client = ShellLobby.newClient(RmiLocation.location(host, port, name), StartClient.getSessionVariablesFromArgs(args), signalHandler);
            if (!StartClient.isCommandLine(args)) {
                this.out.println("NOTE: Remote Neo4j graph database service '" + name + "' at port " + port);
            }
            this.grabPromptOrJustExecuteCommand(client, args);
        }
        catch (Exception e) {
            throw new ShellExecutionFailureException(e, args);
        }
    }

    private static boolean isCommandLine(Args args) {
        return args.get(ARG_COMMAND, null) != null || args.get(ARG_FILE, null) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void grabPromptOrJustExecuteCommand(ShellClient client, Args args) throws Exception {
        String command = args.get(ARG_COMMAND, null);
        if (command != null) {
            client.evaluate(command);
            client.shutdown();
            return;
        }
        String fileName = args.get(ARG_FILE, null);
        if (fileName != null) {
            try (BufferedReader reader = null;){
                if (fileName.equals(ARG_FILE_STDIN)) {
                    reader = new BufferedReader(new InputStreamReader(System.in, Charsets.UTF_8));
                } else {
                    File file = new File(fileName);
                    if (!file.exists()) {
                        throw new ShellException("File to execute does not exist: " + fileName);
                    }
                    reader = FileUtils.newBufferedFileReader((File)file, (Charset)Charsets.UTF_8);
                }
                this.executeCommandStream(client, reader);
            }
            return;
        }
        client.grabPrompt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommandStream(ShellClient client, BufferedReader reader) throws IOException, ShellException {
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                client.evaluate(line);
            }
        }
        finally {
            client.shutdown();
            reader.close();
        }
    }

    static Map<String, Serializable> getSessionVariablesFromArgs(Args args) throws RemoteException, ShellException {
        String profile = args.get("profile", null);
        HashMap<String, Serializable> session = new HashMap<String, Serializable>();
        if (profile != null) {
            StartClient.applyProfileFile(new File(profile), session);
        }
        for (Map.Entry entry : args.asMap().entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("D")) continue;
            key = key.substring(1);
            session.put(key, (Serializable)entry.getValue());
        }
        if (StartClient.isCommandLine(args)) {
            session.put("quiet", Boolean.valueOf(true));
        }
        return session;
    }

    private static void applyProfileFile(File file, Map<String, Serializable> session) throws ShellException {
        try (FileInputStream fis = new FileInputStream(file);){
            Properties properties = new Properties();
            properties.load(fis);
            for (Object key : properties.keySet()) {
                String stringKey = (String)key;
                String value = properties.getProperty(stringKey);
                session.put(stringKey, (Serializable)((Object)value));
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Couldn't find profile '" + file.getAbsolutePath() + "'");
        }
    }

    private static int longestString(String ... strings) {
        int length = 0;
        for (String string : strings) {
            if (string.length() <= length) continue;
            length = string.length();
        }
        return length;
    }

    private static void printUsage(PrintStream out) {
        int port = 1337;
        String name = "shell";
        int longestArgLength = StartClient.longestString(ARG_FILE, ARG_COMMAND, ARG_CONFIG, ARG_HOST, ARG_NAME, ARG_PATH, ARG_PID, ARG_PORT, ARG_READONLY);
        out.println(StartClient.padArg(ARG_HOST, longestArgLength) + "Domain name or IP of host to connect to (default: localhost)" + "\n" + StartClient.padArg(ARG_PORT, longestArgLength) + "Port of host to connect to (default: " + 1337 + ")\n" + StartClient.padArg(ARG_NAME, longestArgLength) + "RMI name, i.e. rmi://<host>:<port>/<name> (default: " + "shell" + ")\n" + StartClient.padArg(ARG_PID, longestArgLength) + "Process ID to connect to\n" + StartClient.padArg(ARG_COMMAND, longestArgLength) + "Command line to execute. After executing it the " + "shell exits\n" + StartClient.padArg(ARG_FILE, longestArgLength) + "File containing commands to execute, or '-' to read " + "from stdin. After executing it the shell exits\n" + StartClient.padArg(ARG_READONLY, longestArgLength) + "Connect in readonly mode (only for connecting " + "with -" + ARG_PATH + ")\n" + StartClient.padArg(ARG_PATH, longestArgLength) + "Points to a neo4j db path so that a local server can " + "be started there\n" + StartClient.padArg(ARG_CONFIG, longestArgLength) + "Points to a config file when starting a local " + "server\n\n" + "Example arguments for remote:\n" + "\t-" + ARG_PORT + " " + port + "\n" + "\t-" + ARG_HOST + " " + "192.168.1.234" + " -" + ARG_PORT + " " + port + " -" + ARG_NAME + "" + " " + name + "\n" + "\t-" + ARG_HOST + " " + "localhost" + " -" + ARG_READONLY + "\n" + "\t...or no arguments for default values\n" + "Example arguments for local:\n" + "\t-" + ARG_PATH + " /path/to/db" + "\n" + "\t-" + ARG_PATH + " /path/to/db -" + ARG_CONFIG + " /path/to/neo4j.config" + "\n" + "\t-" + ARG_PATH + " /path/to/db -" + ARG_READONLY);
    }

    private static String padArg(String arg, int length) {
        return " -" + StartClient.pad(arg, length) + "  ";
    }

    private static String pad(String string, int length) {
        while (string.length() < length) {
            string = string + " ";
        }
        return string;
    }

    static {
        Method load;
        Method attach;
        try {
            Class<?> vmClass = Class.forName("com.sun.tools.attach.VirtualMachine");
            attach = vmClass.getMethod("attach", String.class);
            load = vmClass.getMethod("loadAgent", String.class, String.class);
        }
        catch (Exception e) {
            load = null;
            attach = null;
        }
        attachMethod = attach;
        loadMethod = load;
    }

    private static class ShellExecutionFailureException
    extends RuntimeException {
        private final Throwable cause;
        private final Args args;

        ShellExecutionFailureException(Throwable cause, Args args) {
            this.cause = cause;
            this.args = args;
        }

        private void dumpMessage(PrintStream out, PrintStream err) {
            String message = this.cause.getCause() instanceof ConnectException ? "Connection refused" : this.cause.getMessage();
            err.println("ERROR (-v for expanded information):\n\t" + message);
            if (this.args.has("v")) {
                this.cause.printStackTrace(err);
            }
            err.println();
            StartClient.printUsage(out);
        }
    }
}

