/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.migration;

import java.io.File;
import java.io.IOException;
import org.neo4j.common.ProgressReporter;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.CapabilityType;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;

public class SchemaIndexMigrator
extends AbstractStoreMigrationParticipant {
    private final FileSystemAbstraction fileSystem;
    private boolean deleteObsoleteIndexes;
    private File schemaIndexDirectory;
    private final IndexDirectoryStructure indexDirectoryStructure;
    private final StorageEngineFactory storageEngineFactory;

    public SchemaIndexMigrator(String name, FileSystemAbstraction fileSystem, IndexDirectoryStructure indexDirectoryStructure, StorageEngineFactory storageEngineFactory) {
        super(name);
        this.fileSystem = fileSystem;
        this.indexDirectoryStructure = indexDirectoryStructure;
        this.storageEngineFactory = storageEngineFactory;
    }

    @Override
    public void migrate(DatabaseLayout directoryLayout, DatabaseLayout migrationLayout, ProgressReporter progressReporter, String versionToMigrateFrom, String versionToMigrateTo) {
        StoreVersion toVersionInformation;
        StoreVersion fromVersionInformation = this.storageEngineFactory.versionInformation(versionToMigrateFrom);
        if (!fromVersionInformation.hasCompatibleCapabilities(toVersionInformation = this.storageEngineFactory.versionInformation(versionToMigrateTo), CapabilityType.INDEX)) {
            this.schemaIndexDirectory = this.indexDirectoryStructure.rootDirectory();
            if (this.schemaIndexDirectory != null) {
                this.deleteObsoleteIndexes = true;
            }
        }
    }

    @Override
    public void moveMigratedFiles(DatabaseLayout migrationLayout, DatabaseLayout directoryLayout, String versionToUpgradeFrom, String versionToMigrateTo) throws IOException {
        if (this.deleteObsoleteIndexes) {
            this.deleteIndexes(this.schemaIndexDirectory);
        }
    }

    @Override
    public void cleanup(DatabaseLayout migrationLayout) {
    }

    private void deleteIndexes(File indexRootDirectory) throws IOException {
        this.fileSystem.deleteRecursively(indexRootDirectory);
    }
}

