/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.neo4j.annotations.service.Service;
import org.neo4j.configuration.Config;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.id.IdController;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.lock.LockService;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.LogVersionRepository;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageFilesState;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.storageengine.migration.SchemaRuleMigrationAccess;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.token.TokenHolders;

@Service
public interface StorageEngineFactory {
    public StoreVersionCheck versionCheck(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4, LogService var5, PageCacheTracer var6);

    public StoreVersion versionInformation(String var1);

    public StoreVersion versionInformation(long var1);

    public List<StoreMigrationParticipant> migrationParticipants(FileSystemAbstraction var1, Config var2, PageCache var3, JobScheduler var4, LogService var5, PageCacheTracer var6, MemoryTracker var7);

    public StorageEngine instantiate(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4, TokenHolders var5, SchemaState var6, ConstraintRuleAccessor var7, IndexConfigCompleter var8, LockService var9, IdGeneratorFactory var10, IdController var11, DatabaseHealth var12, LogProvider var13, RecoveryCleanupWorkCollector var14, PageCacheTracer var15, boolean var16, MemoryTracker var17);

    public List<Path> listStorageFiles(FileSystemAbstraction var1, DatabaseLayout var2) throws IOException;

    public boolean storageExists(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3);

    public TransactionIdStore readOnlyTransactionIdStore(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3, PageCursorTracer var4) throws IOException;

    public LogVersionRepository readOnlyLogVersionRepository(DatabaseLayout var1, PageCache var2, PageCursorTracer var3) throws IOException;

    public MetadataProvider transactionMetaDataStore(FileSystemAbstraction var1, DatabaseLayout var2, Config var3, PageCache var4, PageCacheTracer var5) throws IOException;

    public StoreId storeId(DatabaseLayout var1, PageCache var2, PageCursorTracer var3) throws IOException;

    public SchemaRuleMigrationAccess schemaRuleMigrationAccess(FileSystemAbstraction var1, PageCache var2, Config var3, DatabaseLayout var4, LogService var5, String var6, PageCacheTracer var7, PageCursorTracer var8, MemoryTracker var9);

    public StorageFilesState checkRecoveryRequired(FileSystemAbstraction var1, DatabaseLayout var2, PageCache var3);

    public CommandReaderFactory commandReaderFactory();

    public static StorageEngineFactory selectStorageEngine() {
        return (StorageEngineFactory)Iterables.single((Iterable)Services.loadAll(StorageEngineFactory.class));
    }
}

